/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.boss;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.boss.EntityPart;
import com.chocolate.chocolateQuest.magic.ElementsHelper;
import com.chocolate.chocolateQuest.magic.IElementWeak;
import com.chocolate.chocolateQuest.packets.PacketEntityAnimation;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;

public class EntityBaseBoss
extends EntityCreature
implements IBossDisplayData,
IMob,
IEntityAdditionalSpawnData,
IElementWeak {
    private boolean firstTick = true;
    float lvl = 1.0f;
    float size = 1.0f;
    protected boolean ridableBB = true;
    float rotSpeed = 3.0f;
    boolean limitRotation = false;
    int rage = 0;
    float xpRatio = 1.0f;
    protected int physicDefense = 0;
    protected int magicDefense = 0;
    protected int blastDefense = 0;
    protected int fireDefense = 0;
    protected int projectileDefense = 0;

    public EntityBaseBoss(World par1World) {
        super(par1World);
        this.addAITasks();
        this.setMonsterScale(this.lvl);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(17, (Object)0);
        this.field_70728_aV = 30 + (int)(this.getMonsterDificulty() * 10.0f * this.xpRatio);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
    }

    protected void scaleAttributes() {
    }

    protected boolean func_70650_aV() {
        return true;
    }

    public void initBody() {
        this.firstTick = false;
    }

    public void setPart(EntityPart entityPart, int partID) {
        this.firstTick = false;
    }

    public void setMonsterScale(float size) {
        if (size < 0.0f) {
            size = 1.0f;
        }
        this.lvl = size;
        this.size = size * this.getSizeVariation() + this.getMinSize();
        this.resize();
        this.scaleAttributes();
        this.func_70691_i(this.func_110138_aP());
    }

    public float getMinSize() {
        return 1.0f;
    }

    public float getSizeVariation() {
        return 1.0f;
    }

    public float getMonsterDificulty() {
        return this.lvl;
    }

    public void func_70636_d() {
        if (this.firstTick) {
            this.initBody();
        }
        super.func_70636_d();
        if (this.rage > 0) {
            --this.rage;
        }
        this.func_82168_bl();
        if (this.field_70173_aa % 50 == 0 && this.func_110143_aJ() < this.func_110138_aP()) {
            if (this.func_70638_az() != null) {
                if (this.field_70173_aa % 500 == 0) {
                    this.func_70691_i(1.0f);
                }
            } else {
                this.func_70691_i(1.0f);
            }
        }
        this.field_70759_as = this.field_70177_z;
    }

    public void func_70034_d(float par1) {
        if (!this.limitRotation()) {
            super.func_70034_d(par1);
        }
    }

    public void func_70612_e(float par1, float par2) {
        if (this.limitRotation() && !this.field_70170_p.field_72995_K) {
            if (this.field_70177_z - this.field_70126_B > this.rotSpeed) {
                this.field_70177_z = this.field_70126_B + this.rotSpeed;
            } else if (this.field_70177_z - this.field_70126_B < -this.rotSpeed) {
                this.field_70177_z = this.field_70126_B - this.rotSpeed;
            }
        }
        super.func_70612_e(par1, par2);
    }

    protected boolean limitRotation() {
        return true;
    }

    public void moveAsBoss() {
    }

    public void func_70785_a(Entity par1Entity, float par2) {
        super.func_70785_a(par1Entity, par2);
    }

    public boolean func_70652_k(Entity par1Entity) {
        return this.attackEntityAsMob(par1Entity, 1.0f);
    }

    public boolean attackEntityAsMob(Entity par1Entity, float damageScale) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        EntityDamageSource ds = new EntityDamageSource("mob", (Entity)this);
        if (par1Entity instanceof EntityCreeper) {
            damage = 40.0f;
        }
        return par1Entity.func_70097_a((DamageSource)ds, damage * damageScale);
    }

    public void addAITasks() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean isAttacking() {
        return this.getAnimFlag(0);
    }

    public void setAttacking(boolean attacking) {
        this.setAnimFlag(0, attacking);
    }

    protected boolean getAnimFlag(int index) {
        return (this.field_70180_af.func_75683_a(17) & 1 << index) != 0;
    }

    protected void setAnimFlag(int index, boolean result) {
        byte b = this.field_70180_af.func_75683_a(17);
        if (result) {
            this.field_70180_af.func_75692_b(17, (Object)((byte)(b | 1 << index)));
        } else {
            this.field_70180_af.func_75692_b(17, (Object)((byte)(b & ~(1 << index))));
        }
    }

    public boolean func_70097_a(DamageSource ds, float damage) {
        float td = damage;
        damage = ElementsHelper.getAmmountDecreased(this, damage, ds);
        boolean ret = super.func_70097_a(ds, damage);
        this.rage = (int)((float)this.rage + damage);
        if (ds.func_76364_f() != null) {
            if (!this.func_70686_a(ds.func_76364_f().getClass())) {
                return true;
            }
            if (ret && !this.field_70170_p.field_72995_K && ds.func_76364_f() instanceof EntityLivingBase) {
                this.func_70624_b((EntityLivingBase)ds.func_76364_f());
            }
        }
        return ret;
    }

    public boolean attackFromPart(DamageSource par1DamageSource, float par2, EntityPart part) {
        return this.func_70097_a(par1DamageSource, par2);
    }

    public void func_71038_i() {
        if (!this.field_82175_bq || this.field_110158_av < 0) {
            this.field_110158_av = -1;
            this.field_82175_bq = true;
            if (!this.field_70170_p.field_72995_K) {
                PacketEntityAnimation packet = new PacketEntityAnimation(this.func_145782_y(), 0);
                ChocolateQuest.channel.sendToAllAround((Entity)this, packet, 64);
            }
        }
    }

    public float getScaleSize() {
        return this.size;
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.size = additionalData.readFloat();
        this.resize();
        this.onSpawn();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeFloat(this.size);
        this.onSpawn();
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.size = nbt.func_74760_g("size");
        this.lvl = nbt.func_74760_g("scale");
        this.resize();
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("size", this.size);
        nbt.func_74776_a("scale", this.lvl);
    }

    public boolean shouldMoveToEntity(double d1, Entity target) {
        float sizeBB = this.field_70130_N + target.field_70130_N + this.size / 2.0f;
        return d1 > (double)sizeBB && !this.attackInProgress();
    }

    protected void resize() {
        this.func_70105_a(this.size, this.size);
    }

    public void func_70653_a(Entity entity, float par2, double par3, double par5) {
    }

    public AxisAlignedBB func_70046_E() {
        if (!this.ridableBB) {
            return null;
        }
        return this.field_70121_D;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        if (entity.func_70028_i((Entity)this) || !this.ridableBB) {
            return null;
        }
        return entity.field_70121_D;
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70108_f(Entity par1Entity) {
        par1Entity.field_70159_w += (par1Entity.field_70165_t - this.field_70165_t) / (double)this.field_70130_N;
        par1Entity.field_70179_y += (par1Entity.field_70161_v - this.field_70161_v) / (double)this.field_70130_N;
    }

    public void onSpawn() {
    }

    public void animationBoss(byte animType) {
    }

    public void attackToXYZ(byte arm, double x, double y, double z) {
    }

    public boolean attackInProgress() {
        return false;
    }

    public boolean isRaging() {
        return this.func_110143_aJ() < this.func_110138_aP() / 5.0f;
    }

    @Override
    public int getPhysicDefense() {
        return this.physicDefense;
    }

    @Override
    public int getMagicDefense() {
        return this.magicDefense;
    }

    @Override
    public int getBlastDefense() {
        return this.blastDefense;
    }

    @Override
    public int getFireDefense() {
        return this.fireDefense;
    }

    @Override
    public int getProjectileDefense() {
        return this.projectileDefense;
    }

    public boolean func_70686_a(Class par1Class) {
        return super.func_70686_a(par1Class) && par1Class != this.getClass();
    }

    protected void func_70628_a(boolean flag, int i) {
        int ammount = 2 + (int)(this.getMonsterDificulty() * this.getMonsterDificulty()) / 2;
        this.func_70099_a(new ItemStack(ChocolateQuest.material, ammount, this.getDropMaterial()), 0.2f);
    }

    protected int getDropMaterial() {
        return 5;
    }
}

