/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.entity.boss;

import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.entity.boss.AttackKick;
import com.chocolate.chocolateQuest.entity.boss.EntityBaseBoss;
import com.chocolate.chocolateQuest.packets.PacketEntityAnimation;
import com.chocolate.chocolateQuest.utils.BDHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;

public class AttackKickQuadruped
extends AttackKick {
    public int kickTimeBack;
    public byte kickTypeBack;
    float legOffset = 0.5f;

    public AttackKickQuadruped(EntityBaseBoss owner) {
        super(owner);
    }

    @Override
    public void onUpdate() {
        if (this.kickTime > 0) {
            --this.kickTime;
            if (this.kickTime == this.getSpeed() / 4) {
                this.doKickDamage(this.kickType);
            }
        }
        if (this.kickTimeBack > 0) {
            --this.kickTimeBack;
            if (this.kickTimeBack == this.getSpeed() / 4) {
                this.doKickDamage(this.kickTypeBack);
            }
        }
    }

    @Override
    public void attackTarget(Entity entity) {
        int angle = (int)MathHelper.func_76138_g((double)(BDHelper.getAngleBetweenEntities((Entity)this.owner, entity) - (double)this.owner.field_70177_z));
        byte type = -1;
        if (angle < 90 && angle > -90) {
            if (this.kickTime > 0) {
                return;
            }
            if (angle < 80 && angle > 0) {
                type = 3;
            } else if (angle > -80 && angle < 0) {
                type = 1;
            }
        } else {
            if (this.kickTimeBack > 0) {
                return;
            }
            if (angle < -100) {
                type = 2;
            } else if (angle > 100) {
                type = 4;
            }
        }
        if (type != -1) {
            this.kick(type);
        }
    }

    @Override
    public void kick(byte type) {
        if (!this.owner.field_70170_p.field_72995_K) {
            PacketEntityAnimation packet = new PacketEntityAnimation(this.owner.func_145782_y(), type);
            ChocolateQuest.channel.sendToAllAround((Entity)this.owner, packet, 64);
        }
        if (type == 1 || type == 3) {
            this.kickTime = this.getSpeed();
            this.kickType = type;
        } else {
            this.kickTimeBack = this.getSpeed();
            this.kickTypeBack = type;
        }
    }

    @Override
    public boolean isAttackInProgress() {
        return this.kickTime > 0 || this.kickTimeBack > 0;
    }

    @Override
    public double getAngleBetweenEntities(Entity entity, Entity target, byte kickType) {
        float dist = this.owner.field_70130_N * this.legOffset;
        float rotationYaw = this.owner.field_70177_z * 3.141592f / 180.0f;
        double despX = -Math.sin(rotationYaw) * (double)dist;
        double despZ = Math.cos(rotationYaw) * (double)dist;
        if (kickType == 4 || kickType == 2) {
            despX = -despX;
            despZ = -despZ;
        }
        double d = entity.field_70165_t + despX - target.field_70165_t;
        double d2 = entity.field_70161_v + despZ - target.field_70161_v;
        double angle = Math.atan2(d, d2);
        angle = angle * 180.0 / 3.141592;
        angle = -MathHelper.func_76138_g((double)(angle - 180.0));
        return angle;
    }
}

