/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.WorldGeneratorNew;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.builder.support.PlateauBuilder;
import java.util.Properties;
import java.util.Random;
import net.minecraft.world.World;

public class BuilderTemplateSurface
extends BuilderBase {
    String folderName;
    int underGroundOffset;
    boolean replaceBanners = true;
    PlateauBuilder supportStructure;

    @Override
    public BuilderBase load(Properties prop) {
        this.folderName = prop.getProperty("folder").trim();
        if (this.folderName == null) {
            return null;
        }
        this.underGroundOffset = HelperReadConfig.getIntegerProperty(prop, "underGroundOffset", 10);
        if (HelperReadConfig.getBooleanProperty(prop, "supportStructure", false)) {
            this.supportStructure = new PlateauBuilder();
            this.supportStructure.load(prop);
        }
        this.replaceBanners = HelperReadConfig.getBooleanProperty(prop, "replaceBanners", this.replaceBanners);
        return this;
    }

    @Override
    public String getName() {
        return "templateSurface";
    }

    @Override
    public void generate(Random random, World world, int i, int k, int mob) {
        Schematic schematic = BuilderHelper.getRandomNBTMap(this.folderName, random);
        int maxX = schematic.width;
        int maxY = schematic.length;
        i -= maxX / 2;
        k -= maxY / 2;
        boolean cont = false;
        int cant = 0;
        int media = 0;
        for (int x = 0; x < maxX; ++x) {
            for (int y = 0; y < maxY; ++y) {
                int h = world.func_72825_h(i + x, y + k);
                media += h;
                ++cant;
            }
        }
        int height = media / cant;
        this.generate(random, world, i, height, k, mob);
    }

    @Override
    public void generate(Random random, World world, int i, int j, int k, int idMob) {
        Schematic schematic = BuilderHelper.getRandomNBTMap(this.folderName, random);
        this.generate(random, schematic, world, i, j, k, idMob);
    }

    public void generate(Random random, Schematic schematic, World world, int i, int j, int k, int idMob) {
        WorldGeneratorNew.createChunks(world, i, k, schematic.width, schematic.length);
        if (this.supportStructure != null) {
            this.supportStructure.generate(random, world, i, j - 2, k, schematic.width, schematic.length);
        }
        j -= this.underGroundOffset;
        j = Math.max(1, j);
        BuilderHelper builderHelper = BuilderHelper.builderHelper;
        builderHelper.putSchematicInWorld(random, world, schematic, i, j, k, idMob, this.replaceBanners);
    }
}

