/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.builder.BuilderEmptyCave;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.builder.schematic.Schematic;
import com.chocolate.chocolateQuest.builder.support.PlateauBuilder;
import java.util.Properties;
import java.util.Random;
import net.minecraft.world.World;

public class BuilderTemplate
extends BuilderBase {
    String folderName;
    int posY;
    PlateauBuilder supportStructure;
    BuilderEmptyCave cave;
    boolean replaceBanners = true;

    @Override
    public BuilderBase load(Properties prop) {
        this.folderName = prop.getProperty("folder").trim();
        if (this.folderName == null) {
            return null;
        }
        this.posY = Math.max(1, HelperReadConfig.getIntegerProperty(prop, "posY", 64));
        if (HelperReadConfig.getBooleanProperty(prop, "supportStructure", false)) {
            this.supportStructure = new PlateauBuilder();
            this.supportStructure.load(prop);
        }
        this.cave = new BuilderEmptyCave();
        if (HelperReadConfig.getBooleanProperty(prop, "emptyCave", false)) {
            this.cave = new BuilderEmptyCave();
            this.cave.load(prop);
        }
        this.replaceBanners = HelperReadConfig.getBooleanProperty(prop, "replaceBanners", this.replaceBanners);
        return this;
    }

    @Override
    public String getName() {
        return "templateFloating";
    }

    @Override
    public void generate(Random random, World world, int x, int z, int mob) {
        Schematic schematic = BuilderHelper.getRandomNBTMap(this.folderName, random);
        short maxX = schematic.width;
        short maxY = schematic.length;
        this.generate(random, schematic, world, x - maxX / 2, this.posY, z - maxY / 2, mob);
    }

    @Override
    public void generate(Random random, World world, int i, int j, int k, int idMob) {
        Schematic schematic = BuilderHelper.getRandomNBTMap(this.folderName, random);
        this.generate(random, schematic, world, i, this.posY, k, idMob);
    }

    public void generate(Random random, Schematic schematic, World world, int i, int j, int k, int idMob) {
        BuilderHelper builderHelper = BuilderHelper.builderHelper;
        if (this.supportStructure != null) {
            this.supportStructure.generate(random, world, i, j, k, schematic.width, schematic.length);
        }
        if (this.cave != null) {
            int borderSize = 4;
            this.cave.generate(random, world, i - borderSize, j + this.cave.posY, k - borderSize, schematic.width + borderSize * 2, schematic.length + borderSize * 2, this.cave.height <= 0 ? schematic.height + 3 : this.cave.height);
        }
        builderHelper.putSchematicInWorld(random, world, schematic, i, j, k, idMob, this.replaceBanners);
    }
}

