/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.builder;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.BuilderBlockData;
import com.chocolate.chocolateQuest.API.HelperReadConfig;
import com.chocolate.chocolateQuest.builder.Perlin3D;
import java.util.Properties;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class BuilderEmptyCave
extends BuilderBase {
    BuilderBlockData caveBlock = new BuilderBlockData(Blocks.field_150350_a);
    int size = 48;
    int height = 28;
    int posY;
    int boss = 0;
    String spawnBoss = "no";
    boolean inverted = false;
    int borderWidth = 0;
    World world;

    @Override
    public BuilderBase load(Properties prop) {
        this.caveBlock = HelperReadConfig.getBlock(prop, "caveBlock", this.caveBlock);
        this.size = HelperReadConfig.getIntegerProperty(prop, "caveSize", 32);
        this.height = HelperReadConfig.getIntegerProperty(prop, "caveHeight", 28);
        this.posY = HelperReadConfig.getIntegerProperty(prop, "caveY", 20);
        this.inverted = HelperReadConfig.getBooleanProperty(prop, "inverted", this.inverted);
        return this;
    }

    @Override
    public void generate(Random random, World world, int i, int j, int mob) {
        this.generate(random, world, i, this.posY, j, mob);
    }

    @Override
    public String getName() {
        return "emptyCave";
    }

    @Override
    public void generate(Random random, World world, int i, int j, int k, int idMob) {
        this.generate(random, world, i, j, k, this.size, this.size, this.height);
    }

    public void generate(Random random, World world, int i, int j, int k, int sizeX, int sizeZ, int height) {
        i -= this.borderWidth;
        k -= this.borderWidth;
        sizeX += this.borderWidth * 2;
        sizeZ += this.borderWidth * 2;
        int width = 32;
        int rooms = Math.max(1, width / 8);
        Perlin3D p = new Perlin3D(world.func_72905_C(), 8, random);
        Perlin3D p2 = new Perlin3D(world.func_72905_C(), 32, random);
        int wallSize = 3 + this.borderWidth;
        int freq = 1;
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < height; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    float noiseVar = Math.max(0.0f, 3.0f - (float)y / 2.0f);
                    noiseVar += Math.max(0.0f, 4.0f - (float)(height - y + 1) / 2.0f);
                    noiseVar += (float)Math.max(0, wallSize - x / freq);
                    noiseVar += (float)Math.max(0, wallSize - (sizeX - x - 1) / freq);
                    noiseVar += (float)Math.max(0, wallSize - z / freq);
                    double noiseValue = p.getNoiseAt(x + i, y + j, z + k) * p2.getNoiseAt(x + i, y + j, z + k) * (double)(noiseVar += (float)Math.max(0, wallSize - (sizeZ - z - 1) / freq));
                    if (this.inverted) {
                        if (!(noiseValue > 0.5)) continue;
                        this.caveBlock.placeBlock(world, i + x, j + y, k + z, random);
                        continue;
                    }
                    if (!(noiseValue < 0.5)) continue;
                    this.caveBlock.placeBlock(world, i + x, j + y, k + z, random);
                }
            }
        }
    }
}

