/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest.block;

import com.chocolate.chocolateQuest.entity.EntityHumanBase;
import com.chocolate.chocolateQuest.entity.mob.registry.DungeonMonstersBase;
import com.chocolate.chocolateQuest.entity.mob.registry.RegisterDungeonMobs;
import com.chocolate.chocolateQuest.misc.EquipementHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockMobSpawnerTileEntity
extends TileEntity {
    public int delay = 20;
    public int mob;
    public int metadata;
    public double yaw;
    public double yaw2 = 0.0;
    public NBTTagCompound mobNBT = null;

    public boolean anyPlayerInRange() {
        EntityPlayer player = this.field_145850_b.func_72977_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 16.0);
        return player != null && !player.field_71075_bZ.field_75098_d;
    }

    public void func_145845_h() {
        if (!this.anyPlayerInRange()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.delay == -1) {
                this.updateDelay();
            }
            if (this.delay > 0) {
                --this.delay;
                return;
            }
            this.spawnEntity();
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        super.func_145845_h();
    }

    public void spawnEntity() {
        int tmob = this.mob;
        Entity entity = BlockMobSpawnerTileEntity.getEntity(this.metadata, tmob, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (entity == null) {
            entity = new EntityZombie(this.field_145850_b);
        }
        if (this.mobNBT != null) {
            this.editEntityStats(this.mobNBT);
            Entity e = EntityList.func_75615_a((NBTTagCompound)this.mobNBT, (World)this.field_145850_b);
            if (e != null) {
                entity = e;
            }
            if (entity instanceof EntityHumanBase) {
                NBTTagCompound ridingNBT;
                Entity riding;
                EntityHumanBase human = (EntityHumanBase)entity;
                human.readEntityFromSpawnerNBT(this.mobNBT, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                if (this.mobNBT.func_74781_a("Riding") != null && (riding = EntityList.func_75615_a((NBTTagCompound)(ridingNBT = (NBTTagCompound)this.mobNBT.func_74781_a("Riding")), (World)this.field_145850_b)) != null) {
                    riding.func_70107_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5);
                    this.field_145850_b.func_72838_d(riding);
                    human.func_70078_a(riding);
                    if (riding instanceof EntityHumanBase) {
                        ((EntityHumanBase)riding).entityTeam = human.entityTeam;
                    }
                }
            }
        }
        entity.func_70012_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
        this.field_145850_b.func_72838_d(entity);
        this.field_145850_b.func_72926_e(2004, this.field_145851_c, this.field_145848_d, this.field_145849_e, 0);
        if (this.field_145850_b.field_72995_K && entity instanceof EntityLiving) {
            ((EntityLiving)entity).func_70656_aK();
        }
    }

    private void updateDelay() {
        this.delay = 200 + this.field_145850_b.field_73012_v.nextInt(600);
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.mob = par1NBTTagCompound.func_74762_e("mob");
        this.metadata = par1NBTTagCompound.func_74762_e("typeMob");
        this.mobNBT = (NBTTagCompound)par1NBTTagCompound.func_74781_a("mobData");
        if (this.mobNBT != null && this.mobNBT.func_82582_d()) {
            this.mobNBT = null;
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("mob", this.mob);
        par1NBTTagCompound.func_74768_a("typeMob", this.metadata);
        if (this.mobNBT != null) {
            par1NBTTagCompound.func_74782_a("mobData", (NBTBase)this.mobNBT);
        }
    }

    public void editEntityStats(NBTTagCompound eTag) {
        DungeonMonstersBase mobType = null;
        if (this.mob >= 0) {
            mobType = RegisterDungeonMobs.mobList.get(this.mob);
        }
        if (mobType != null && (eTag.func_74779_i("id").equals("chocolateQuest.dummy") || eTag.func_74779_i("id").equals(""))) {
            NBTTagList list = eTag.func_150295_c("Party", (int)eTag.func_74732_a());
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.editEntityStats(list.func_150305_b(i));
            }
            eTag.func_74778_a("id", mobType.getRegisteredEntityName());
            eTag.func_74778_a("team", mobType.getTeamName());
            NBTTagList attributes = eTag.func_150295_c("Attributes", (int)eTag.func_74732_a());
            for (int a = 0; a < attributes.func_74745_c(); ++a) {
                double base;
                NBTTagCompound tag = attributes.func_150305_b(a);
                String name = tag.func_74779_i("Name");
                if (name.equals("generic.maxHealth")) {
                    base = tag.func_74769_h("Base");
                    tag.func_74780_a("Base", base * mobType.getHealth());
                    eTag.func_74777_a("Health", (short)(base * mobType.getHealth()));
                    eTag.func_74776_a("HealF", (float)(base * mobType.getHealth()));
                }
                if (name.equals("generic.attackDamage")) {
                    base = tag.func_74769_h("Base");
                    tag.func_74780_a("generic.attackDamage", mobType.getAttack());
                }
                if (!name.equals("generic.followRange")) continue;
                base = tag.func_74769_h("Base");
                tag.func_74780_a("generic.followRange", mobType.getRange());
            }
        }
    }

    public static Entity getEntity(int metadata, int mob, World world, int x, int y, int z) {
        Object e = null;
        DungeonMonstersBase mobType = null;
        if (mob >= 0) {
            mobType = RegisterDungeonMobs.mobList.get(mob);
        }
        if (mobType != null) {
            e = metadata <= 14 ? mobType.getEntity(world, x, y, z) : mobType.getBoss(world, x, y, z);
            if (e instanceof EntityHumanBase) {
                EquipementHelper.equipEntity((EntityLivingBase)e, metadata % 5);
            }
        } else {
            e = metadata < 5 ? new EntityZombie(world) : (metadata <= 9 ? new EntitySkeleton(world) : new EntitySpider(world));
        }
        return e;
    }
}

