/*
 * Decompiled with CFR 0.152.
 */
package com.chocolate.chocolateQuest;

import com.chocolate.chocolateQuest.API.BuilderBase;
import com.chocolate.chocolateQuest.API.DungeonBase;
import com.chocolate.chocolateQuest.API.DungeonRegister;
import com.chocolate.chocolateQuest.ChocolateQuest;
import com.chocolate.chocolateQuest.builder.BuilderHelper;
import com.chocolate.chocolateQuest.entity.mob.registry.DungeonMonstersBase;
import com.chocolate.chocolateQuest.entity.mob.registry.RegisterDungeonMobs;
import com.chocolate.chocolateQuest.quest.worldManager.TerrainManager;
import com.chocolate.chocolateQuest.utils.BDHelper;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGeneratorNew
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_72995_K) {
            return;
        }
        Random rnd = new Random();
        rnd.setSeed(WorldGeneratorNew.getSeed(world, chunkX, chunkZ));
        int dungeonSeparation = TerrainManager.getTerritorySeparation();
        if (chunkX % dungeonSeparation == 0 && chunkZ % dungeonSeparation == 0) {
            this.generateSurface(world, rnd, chunkX * 16 + 1, chunkZ * 16 + 1);
        }
    }

    public static long getSeed(World world, int chunkX, int chunkZ) {
        long mix = WorldGeneratorNew.xorShift64(chunkX) + Long.rotateLeft(WorldGeneratorNew.xorShift64(chunkZ), 32) + -1094792450L;
        long result = WorldGeneratorNew.xorShift64(mix);
        return world.func_72905_C() + result;
    }

    public static long xorShift64(long x) {
        x ^= x << 21;
        x ^= x >>> 35;
        x ^= x << 4;
        return x;
    }

    public static void createChunks(World world, int posX, int posZ, int sizeX, int sizeZ) {
    }

    public void generateSurface(World world, Random random, int i, int k) {
        if (world.func_72912_H().func_76067_t().func_77127_a() == "flat" && !ChocolateQuest.config.dungeonsInFlat) {
            return;
        }
        this.generateBigDungeon(world, random, i, k, true);
    }

    public void generateBigDungeon(World world, Random random, int i, int k, boolean addDungeon) {
        BuilderBase builder = null;
        BiomeGenBase biome = world.func_72807_a(i, k);
        DungeonBase dungeon = null;
        block0: for (DungeonBase d : DungeonRegister.dungeonList) {
            String[] b;
            if (d.isUnique() && TerrainManager.instance.isDungeonSpawned(d.getName()) || d.getChance() <= 0) continue;
            int[] dimension = d.getDimension();
            boolean dimensionPass = false;
            for (int a = 0; a < dimension.length; ++a) {
                if (dimension[a] != world.field_73011_w.field_76574_g) continue;
                dimensionPass = true;
                break;
            }
            if (!dimensionPass) continue;
            for (String currentName : b = d.getBiomes()) {
                if (!this.isValidBiome(currentName, biome)) continue;
                if (random.nextInt(d.getChance()) != 0) continue block0;
                dungeon = d;
                continue block0;
            }
        }
        if (dungeon != null) {
            BuilderHelper.builderHelper.initialize(i);
            builder = dungeon.getBuilder();
            int idMob = RegisterDungeonMobs.mobList.get(dungeon.getMobID()).getDungeonMonster(world, i, 60, k).getID();
            builder.generate(random, world, i, k, idMob);
            BDHelper.println("Generatig " + dungeon.getName() + " at x: " + i + ",  z:" + k);
            BuilderHelper.builderHelper.flush(world);
            if (dungeon.isUnique()) {
                TerrainManager.instance.dungeonSpawned(dungeon.getName());
            }
        }
    }

    public boolean isValidBiome(String biomeName, BiomeGenBase biome) {
        if (biomeName.equals("ALL") || biomeName.equals("*")) {
            return true;
        }
        if (biomeName.equals("NONWATER")) {
            return !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER);
        }
        if (biome.field_76791_y.equals(biomeName)) {
            return true;
        }
        BiomeDictionary.Type type = null;
        for (BiomeDictionary.Type e : BiomeDictionary.Type.values()) {
            if (!biomeName.equals(e.toString())) continue;
            type = e;
        }
        if (type != null) {
            return BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, type);
        }
        return false;
    }

    public static int getMobIndex(ArrayList<DungeonMonstersBase> chestList, Random random) {
        int[] weights = new int[chestList.size()];
        int maxNum = 0;
        for (int i = 0; i < chestList.size(); ++i) {
            weights[i] = chestList.get(i).getWeight();
            maxNum += weights[i];
        }
        int randomNum = random.nextInt(maxNum);
        int index = 0;
        for (int weightSum = weights[0]; weightSum <= randomNum; weightSum += weights[++index]) {
        }
        return index;
    }
}

