/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.rail;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import crazypants.enderio.rail.BlockEnderRail;
import crazypants.enderio.rail.TeleporterEIO;
import crazypants.util.BlockCoord;
import crazypants.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Teleporter;
import net.minecraftforge.common.util.ForgeDirection;

public class PlayerTeleportHandler {
    static PlayerTeleportHandler instance = new PlayerTeleportHandler();
    List<TeleportAction> queue = new ArrayList<TeleportAction>();

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (TeleportAction action : this.queue) {
            action.doTeleport();
        }
        this.queue.clear();
    }

    public void teleportPlayer(TileTransceiver reciever, EntityPlayerMP playerToTP, EntityMinecart playerToMount) {
        this.queue.add(new TeleportAction(reciever, playerToTP, playerToMount));
    }

    private static class TeleportAction {
        TileTransceiver reciever;
        EntityPlayerMP playerToTP;
        EntityMinecart playerToMount;

        private TeleportAction(TileTransceiver reciever, EntityPlayerMP playerToTP, EntityMinecart playerToMount) {
            this.reciever = reciever;
            this.playerToTP = playerToTP;
            this.playerToMount = playerToMount;
        }

        void doTeleport() {
            int toDim = this.reciever.func_145831_w().field_73011_w.field_76574_g;
            int meta = this.reciever.func_145832_p();
            ForgeDirection railDir = BlockEnderRail.getDirection(meta);
            int xOffset = Math.abs(railDir.offsetX);
            int zOffset = Math.abs(railDir.offsetZ);
            BlockCoord startPos = new BlockCoord(this.reciever).getLocation(ForgeDirection.UP);
            boolean foundSpot = false;
            for (int i = 1; i < 3 && !foundSpot; ++i) {
                this.playerToTP.func_70107_b((double)startPos.x + 0.5 - (double)(xOffset * i), (double)startPos.y, (double)startPos.z + 0.5 - (double)(zOffset * i));
                List<AxisAlignedBB> collides = EntityUtil.getCollidingBlockGeometry(this.reciever.func_145831_w(), (Entity)this.playerToTP);
                boolean bl = foundSpot = collides == null || collides.isEmpty();
                if (foundSpot) continue;
                this.playerToTP.func_70107_b((double)startPos.x + 0.5 + (double)(xOffset * i), (double)startPos.y, (double)startPos.z + 0.5 + (double)(zOffset * i));
                collides = EntityUtil.getCollidingBlockGeometry(this.reciever.func_145831_w(), (Entity)this.playerToTP);
                foundSpot = collides == null || collides.isEmpty();
            }
            if (!foundSpot) {
                this.playerToTP.func_70107_b((double)startPos.x + 0.5, (double)startPos.y, (double)startPos.z + 0.5);
            }
            this.reciever.getRailController().onPlayerTeleported(this.playerToTP, this.playerToMount);
            this.playerToTP.field_71133_b.func_71203_ab().transferPlayerToDimension(this.playerToTP, toDim, (Teleporter)new TeleporterEIO(this.playerToTP.field_71133_b.func_71218_a(toDim)));
        }
    }
}

