/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.material;

import crazypants.enderio.Log;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.recipe.RecipeConfig;
import crazypants.enderio.machine.recipe.RecipeConfigParser;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.material.OreDictionaryPreferences;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class OreDictionaryPreferenceParser
extends DefaultHandler {
    private static final String CORE_FILE_NAME = "OreDictionaryPreferences_Core.xml";
    private static final String CUSTOM_FILE_NAME = "OreDictionaryPreferences_User.xml";
    public static final String ELEMENT_PREF = "preference";
    public static final String ELEMENT_STACK = "itemStack";
    private static final String AT_ORE_DICT = "oreDictionary";
    public static final String AT_ITEM_META = "itemMeta";
    public static final String AT_ITEM_NAME = "itemName";
    public static final String AT_MOD_ID = "modID";
    private OreDictionaryPreferences prefs;
    private String oreDictName;
    private ItemStack prefStack;

    public static void loadConfig() {
        File coreFile = new File(Config.configDirectory, CORE_FILE_NAME);
        String defaultVals = null;
        try {
            defaultVals = RecipeConfig.readRecipes(coreFile, CORE_FILE_NAME, true);
        }
        catch (IOException e) {
            Log.error("Could not load painter lists " + coreFile + " from EnderIO jar: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        if (!coreFile.exists()) {
            Log.error("Could not load default lists from " + coreFile + " as the file does not exist.");
            return;
        }
        try {
            OreDictionaryPreferenceParser.parse(defaultVals);
        }
        catch (Exception e) {
            Log.error("Could not parse default lists from " + coreFile + ": " + e);
        }
        File userFile = new File(Config.configDirectory, CUSTOM_FILE_NAME);
        String userConfigStr = null;
        try {
            userConfigStr = RecipeConfig.readRecipes(userFile, CUSTOM_FILE_NAME, false);
            if (userConfigStr == null || userConfigStr.trim().length() == 0) {
                Log.error("Empty user config file: " + userFile.getAbsolutePath());
            } else {
                OreDictionaryPreferenceParser.parse(userConfigStr);
            }
        }
        catch (Exception e) {
            Log.error("Could not load user defined painter lists from file: OreDictionaryPreferences_User.xml");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(String str) throws Exception {
        StringReader reader = new StringReader(str);
        InputSource is = new InputSource(reader);
        try {
            OreDictionaryPreferenceParser.parse(is);
        }
        finally {
            reader.close();
        }
    }

    private static void parse(InputSource is) throws Exception {
        OreDictionaryPreferenceParser parser = new OreDictionaryPreferenceParser(OreDictionaryPreferences.instance);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setContentHandler(parser);
        xmlReader.parse(is);
    }

    private OreDictionaryPreferenceParser(OreDictionaryPreferences prefs) {
        this.prefs = prefs;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (ELEMENT_PREF.equals(localName)) {
            this.oreDictName = RecipeConfigParser.getStringValue(AT_ORE_DICT, attributes, null);
            return;
        }
        if (ELEMENT_STACK.equals(localName) && this.oreDictName != null && this.prefStack == null) {
            RecipeInput ri = RecipeConfigParser.getItemStack(attributes);
            if (ri != null && ri.getInput() != null) {
                this.prefStack = ri.getInput();
            }
            return;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (ELEMENT_PREF.equals(localName)) {
            if (this.oreDictName != null && this.prefStack != null) {
                boolean matched = false;
                int[] ids = OreDictionary.getOreIDs((ItemStack)this.prefStack);
                if (ids != null) {
                    for (int i = 0; i < ids.length && !matched; ++i) {
                        matched = this.oreDictName.equals(OreDictionary.getOreName((int)ids[i]));
                    }
                }
                if (matched) {
                    this.prefs.setPreference(this.oreDictName, this.prefStack);
                } else {
                    Log.warn("OreDictionaryPreferenceParser: Attempted to register " + this.prefStack + " as the preffered output for " + this.oreDictName + " but it is not registered in the OreDictionary as " + this.oreDictName);
                }
            }
            this.oreDictName = null;
            this.prefStack = null;
        }
    }
}

