/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.vat;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.vat.ContainerVat;
import crazypants.enderio.machine.vat.GuiVat;
import crazypants.enderio.machine.vat.PacketDumpTank;
import crazypants.enderio.machine.vat.PacketTanks;
import crazypants.enderio.machine.vat.PacketVatProgress;
import crazypants.enderio.machine.vat.TileVat;
import crazypants.enderio.network.PacketHandler;
import crazypants.render.VertexRotation;
import crazypants.vecmath.Vector3d;
import java.util.Random;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockVat
extends AbstractMachineBlock<TileVat> {
    public static int renderId;
    protected IIcon onIcon;
    protected IIcon topIcon;
    protected IIcon blockIconSingle;
    protected IIcon blockIconSingleOn;

    public static BlockVat create() {
        PacketHandler.INSTANCE.registerMessage(PacketTanks.class, PacketTanks.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketVatProgress.class, PacketVatProgress.class, PacketHandler.nextID(), Side.CLIENT);
        PacketHandler.INSTANCE.registerMessage(PacketDumpTank.class, PacketDumpTank.class, PacketHandler.nextID(), Side.SERVER);
        BlockVat res = new BlockVat();
        res.init();
        return res;
    }

    public BlockVat() {
        super(ModObject.blockVat, TileVat.class);
    }

    @Override
    public void func_149651_a(IIconRegister iIconRegister) {
        this.field_149761_L = iIconRegister.func_94245_a("enderio:vatFront");
        this.blockIconSingle = iIconRegister.func_94245_a("enderio:vatFrontSingle");
        this.blockIconSingleOn = iIconRegister.func_94245_a("enderio:vatFrontOnSingle");
        this.onIcon = iIconRegister.func_94245_a("enderio:vatFrontOn");
        this.topIcon = iIconRegister.func_94245_a("enderio:vatTop");
        this.overlayIconPull = iIconRegister.func_94245_a("enderio:vatOverlayPull");
        this.overlayIconPush = iIconRegister.func_94245_a("enderio:vatOverlayPush");
        this.overlayIconPushPull = iIconRegister.func_94245_a("enderio:vatOverlayPushPull");
        this.overlayIconDisabled = iIconRegister.func_94245_a("enderio:vatOverlayDisabled");
        this.overlayIconNone = iIconRegister.func_94245_a("enderio:machineOverlayNone");
    }

    public int func_149717_k() {
        return 0;
    }

    @Override
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileEntity te = world.func_147438_o(x, y, z);
        boolean on = false;
        if (te instanceof AbstractMachineEntity) {
            AbstractMachineEntity me = (AbstractMachineEntity)te;
            on = me.isActive();
        }
        if (blockSide == ForgeDirection.UP.ordinal() || blockSide == ForgeDirection.DOWN.ordinal()) {
            return this.topIcon;
        }
        if (blockSide == ForgeDirection.EAST.ordinal() || blockSide == ForgeDirection.WEST.ordinal()) {
            if (on) {
                return this.blockIconSingleOn;
            }
            return this.blockIconSingle;
        }
        if (on) {
            return this.onIcon;
        }
        return this.field_149761_L;
    }

    @Override
    public IIcon func_149691_a(int blockSide, int blockMeta) {
        if (blockSide == ForgeDirection.UP.ordinal() || blockSide == ForgeDirection.DOWN.ordinal()) {
            return this.topIcon;
        }
        return this.field_149761_L;
    }

    @Override
    public int func_149645_b() {
        return renderId;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileVat) {
            return new ContainerVat(player.field_71071_by, (TileVat)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileVat) {
            return new GuiVat(player.field_71071_by, (TileVat)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess p_149646_1_, int p_149646_2_, int p_149646_3_, int p_149646_4_, int p_149646_5_) {
        return true;
    }

    @Override
    protected String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:vatFrontOn";
        }
        return "enderio:vatFront";
    }

    @Override
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.isActive((IBlockAccess)world, x, y, z)) {
            float startX = x;
            float startY = (float)y + 0.35f;
            float startZ = z;
            for (int k = 0; k < 2; ++k) {
                int ran2adn5 = (int)Math.round(Math.random() * 3.0 + 2.0);
                ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[ran2adn5];
                if (dir.offsetY != 0) continue;
                for (int i = 0; i < 2; ++i) {
                    float xOffset = 0.52f * (float)(1 - dir.offsetX) + (float)dir.offsetX * (-0.1f + rand.nextFloat() * 0.2f);
                    float yOffset = -0.1f + rand.nextFloat() * 0.2f;
                    float zOffset = 0.52f * (float)(1 - dir.offsetZ) + (float)dir.offsetZ * (-0.1f + rand.nextFloat() * 0.2f);
                    if ((double)rand.nextFloat() > 0.5) {
                        VertexRotation vr = new VertexRotation(0.7853981633974483, new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, 0.25, 0.5));
                        Vector3d vec = new Vector3d(xOffset, yOffset, zOffset);
                        vr.apply(vec);
                        xOffset = (float)vec.x;
                        yOffset = (float)vec.y;
                        zOffset = (float)vec.z;
                    }
                    world.func_72869_a("smoke", (double)(startX + xOffset), (double)(startY + yOffset), (double)(startZ + zOffset), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

