/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.gui;

import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.gui.GuiTransceiver;
import crazypants.gui.GuiScrollableList;
import crazypants.render.ColorUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;

public class GuiChannelList
extends GuiScrollableList<Channel> {
    private List<Channel> channels = new ArrayList<Channel>();
    private final GuiTransceiver parent;

    public GuiChannelList(GuiTransceiver parent, int width, int height, int originX, int originY) {
        super(width, height, originX, originY, Minecraft.func_71410_x().field_71466_p.field_78288_b + 4);
        this.parent = parent;
    }

    void setChannels(List<Channel> val) {
        if (val == null) {
            this.channels = Collections.emptyList();
        }
        this.channels = val;
    }

    @Override
    public int getNumElements() {
        return this.channels.size();
    }

    @Override
    public Channel getElementAt(int index) {
        if (index < 0 || index >= this.channels.size()) {
            return null;
        }
        return this.channels.get(index);
    }

    @Override
    protected boolean elementClicked(int i, boolean flag) {
        return this.getElementAt(i) != null;
    }

    @Override
    protected void drawElement(int index, int xPosition, int yPosition, int rowHeight, Tessellator tessellator) {
        if (index < 0 || index >= this.channels.size()) {
            return;
        }
        Channel c = this.getElementAt(index);
        if (c == null) {
            return;
        }
        int col = ColorUtil.getRGB(Color.white);
        this.parent.func_73731_b(this.parent.getFontRenderer(), c.getName(), xPosition + this.margin, yPosition + this.margin / 2, col);
        if (!c.isPublic()) {
            IconEIO.PRIVATE.renderIcon(xPosition + this.width - 18, yPosition - 3, 16.0, 15.0, 0.0, true);
        }
    }
}

