/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver.gui;

import crazypants.enderio.conduit.gui.item.InventoryFilterUpgrade;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.gui.AbstractMachineContainer;
import crazypants.enderio.machine.transceiver.TileTransceiver;
import java.awt.Point;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerTransceiver
extends AbstractMachineContainer {
    public static final int GUI_WIDTH = 256;
    static final Point PLAYER_INV_OFFSET = new Point(47, 86);
    static final Point ITEM_INV_OFFSET = new Point(54, 30);
    static final Point HIDDEN_OFFSET = new Point(-3000, -3000);
    static final Point FILTER_OFFSET = new Point(ContainerTransceiver.PLAYER_INV_OFFSET.x, 30);
    private TileTransceiver trans;
    private Map<Slot, Point> sendFilterLocs;
    private Map<Slot, Point> recFilterLocs;

    public ContainerTransceiver(InventoryPlayer inventory, TileTransceiver te) {
        super(inventory, te);
        this.trans = te;
    }

    @Override
    protected void addMachineSlots(InventoryPlayer playerInv) {
        int i;
        this.trans = (TileTransceiver)this.tileEntity;
        for (i = 0; i < 8; ++i) {
            this.func_75146_a(new Slot((IInventory)this.tileEntity, i, 0, 0){

                public boolean func_75214_a(ItemStack itemstack) {
                    return ContainerTransceiver.this.trans.func_94041_b(this.getSlotIndex(), itemstack);
                }
            });
        }
        while (i < 16) {
            this.func_75146_a(new Slot((IInventory)this.tileEntity, i, 0, 0){

                public boolean func_75214_a(ItemStack p_75214_1_) {
                    return false;
                }
            });
            ++i;
        }
        this.setItemSlotLocations(this.getItemInventoryOffset());
        List<Slot> sendFilterSlots = this.trans.getSendItemFilter().getSlots(0, 0);
        this.sendFilterLocs = new HashMap<Slot, Point>();
        for (Slot slot : sendFilterSlots) {
            this.func_75146_a(slot);
            this.sendFilterLocs.put(slot, new Point(slot.field_75223_e, slot.field_75221_f));
        }
        List<Slot> recFilterSlots = this.trans.getReceiveItemFilter().getSlots(0, 0);
        this.recFilterLocs = new HashMap<Slot, Point>();
        for (Slot slot : recFilterSlots) {
            this.func_75146_a(slot);
            this.recFilterLocs.put(slot, new Point(slot.field_75223_e, slot.field_75221_f));
        }
        this.setSendFilterSlotsVisible(false);
        this.setReceiveFilterSlotsVisible(false);
    }

    public void setPlayerInventoryVisible(boolean visible) {
        Set entries = this.playerSlotLocations.entrySet();
        for (Map.Entry entry : entries) {
            ((Slot)entry.getKey()).field_75223_e = visible ? ((Point)entry.getValue()).x : -3000;
            ((Slot)entry.getKey()).field_75221_f = visible ? ((Point)entry.getValue()).y : -3000;
        }
    }

    public void setBufferSlotsVisible(boolean visible) {
        Point itemOffset = visible ? this.getItemInventoryOffset() : HIDDEN_OFFSET;
        this.setItemSlotLocations(itemOffset);
    }

    public void setSendFilterSlotsVisible(boolean visible) {
        this.setFilterSlotsVisible(this.sendFilterLocs, visible);
    }

    public void setReceiveFilterSlotsVisible(boolean visible) {
        this.setFilterSlotsVisible(this.recFilterLocs, visible);
    }

    public void setFilterSlotsVisible(Map<Slot, Point> slots, boolean visible) {
        Point offset = HIDDEN_OFFSET;
        if (visible) {
            offset = FILTER_OFFSET;
        }
        for (Map.Entry<Slot, Point> entry : slots.entrySet()) {
            entry.getKey().field_75223_e = offset.x + entry.getValue().x + 1;
            entry.getKey().field_75221_f = offset.y + entry.getValue().y + 1;
        }
    }

    private void setItemSlotLocations(Point offset) {
        int i;
        int x = offset.x;
        int y = offset.y;
        for (i = 0; i < 4; ++i) {
            ((Slot)this.field_75151_b.get((int)i)).field_75223_e = x;
            ((Slot)this.field_75151_b.get((int)i)).field_75221_f = y;
            x += 18;
        }
        x = offset.x;
        y = offset.y + 18;
        while (i < 8) {
            ((Slot)this.field_75151_b.get((int)i)).field_75223_e = x;
            ((Slot)this.field_75151_b.get((int)i)).field_75221_f = y;
            x += 18;
            ++i;
        }
        x = offset.x + 72 + this.getItemBufferSpacing();
        y = offset.y;
        while (i < 12) {
            ((Slot)this.field_75151_b.get((int)i)).field_75223_e = x;
            ((Slot)this.field_75151_b.get((int)i)).field_75221_f = y;
            x += 18;
            ++i;
        }
        x = offset.x + 72 + this.getItemBufferSpacing();
        y = offset.y + 18;
        while (i < 16) {
            ((Slot)this.field_75151_b.get((int)i)).field_75223_e = x;
            ((Slot)this.field_75151_b.get((int)i)).field_75221_f = y;
            x += 18;
            ++i;
        }
    }

    @Override
    public Point getPlayerInventoryOffset() {
        return PLAYER_INV_OFFSET;
    }

    public Point getItemInventoryOffset() {
        return ITEM_INV_OFFSET;
    }

    public Point getFilterOffset() {
        return FILTER_OFFSET;
    }

    public int getItemBufferSpacing() {
        return 5;
    }

    @Override
    protected int getIndexOfFirstPlayerInvSlot(SlotDefinition slotDef) {
        return slotDef.getNumSlots() + this.sendFilterLocs.size() + this.recFilterLocs.size();
    }

    public static class FilterSlot
    extends Slot {
        InventoryFilterUpgrade inv;

        public FilterSlot(InventoryFilterUpgrade inv) {
            super((IInventory)inv, 0, 0, 0);
            this.inv = inv;
        }

        public boolean func_75214_a(ItemStack stack) {
            return this.inv.func_94041_b(0, stack);
        }
    }
}

