/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelType;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public class ChannelRegister {
    protected EnumMap<ChannelType, List<Channel>> channels = new EnumMap(ChannelType.class);

    public List<Channel> getChannelsForType(ChannelType type) {
        return this.channels.get((Object)type);
    }

    public void addChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        List<Channel> chans = this.getChannelsForType(channel.getType());
        if (!chans.contains(channel)) {
            chans.add(channel);
        }
    }

    public void removeChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        this.getChannelsForType(channel.getType()).remove(channel);
    }

    public void reset() {
        this.channels.clear();
        for (ChannelType type : ChannelType.values()) {
            this.channels.put(type, new ArrayList());
        }
    }
}

