/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.combustion;

import crazypants.render.BoundingBox;
import crazypants.render.CustomCubeRenderer;
import crazypants.render.CustomRenderBlocks;
import crazypants.render.IRenderFace;
import crazypants.render.RenderUtil;
import crazypants.render.VertexTransform;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector4f;
import crazypants.vecmath.Vertex;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TranslatedCubeRenderer {
    public static TranslatedCubeRenderer instance = new TranslatedCubeRenderer();
    private XFormRenderer xformRenderer = new XFormRenderer();
    private CustomCubeRenderer ccr = new CustomCubeRenderer();

    public void renderBoundingBox(int x, int y, int z, Block block, BoundingBox bb, VertexTransform vt, boolean enableLighting) {
        this.renderBoundingBox(x, y, z, block, bb, vt, null, enableLighting);
    }

    public void renderBoundingBox(int x, int y, int z, Block block, BoundingBox bb, VertexTransform vt) {
        this.renderBoundingBox(x, y, z, block, bb, vt, null);
    }

    public void renderBoundingBox(int x, int y, int z, Block block, BoundingBox bb, VertexTransform vt, IIcon overrideTexture) {
        this.renderBoundingBox(x, y, z, block, bb, vt, overrideTexture, true);
    }

    public void renderBoundingBox(int x, int y, int z, Block block, BoundingBox bb, VertexTransform vt, IIcon overrideTexture, boolean doLighting) {
        block.func_149676_a(bb.minX, bb.minY, bb.minZ, bb.maxX, bb.maxY, bb.maxZ);
        this.xformRenderer.xform = vt;
        this.xformRenderer.enableLighting = doLighting;
        this.ccr.setOverrideTexture(overrideTexture);
        this.ccr.renderBlock((IBlockAccess)Minecraft.func_71410_x().field_71441_e, block, x, y, z, this.xformRenderer);
        this.ccr.setOverrideTexture(null);
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public CustomCubeRenderer getRenderer() {
        return this.ccr;
    }

    private class XFormRenderer
    implements IRenderFace {
        VertexTransform xform;
        boolean enableLighting = true;

        private XFormRenderer() {
        }

        @Override
        public void renderFace(CustomRenderBlocks rb, ForgeDirection face, Block par1Block, double x, double y, double z, IIcon texture, List<Vertex> refVertices, boolean translateToXyz) {
            if (this.xform != null) {
                Vector3d xyz = new Vector3d(x, y, z);
                for (Vertex v : refVertices) {
                    v.xyz.sub(xyz);
                    this.xform.apply(v);
                    if (this.enableLighting) continue;
                    v.brightness = 0xF000F0;
                    float col = RenderUtil.getColorMultiplierForFace(face);
                    v.color = new Vector4f(col, col, col, 1.0f);
                    v.normal = null;
                }
            }
            Tessellator.field_78398_a.func_78372_c((float)x, (float)y, (float)z);
            RenderUtil.addVerticesToTesselator(refVertices);
            Tessellator.field_78398_a.func_78372_c(-((float)x), -((float)y), -((float)z));
        }
    }
}

