/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.AbstractPoweredTaskEntity;
import crazypants.enderio.machine.ContinuousTask;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.IPoweredTask;
import crazypants.enderio.machine.SlotDefinition;
import crazypants.enderio.machine.farm.FakeFarmPlayer;
import crazypants.enderio.machine.farm.PacketFarmAction;
import crazypants.enderio.machine.farm.PacketFarmLockedSlot;
import crazypants.enderio.machine.farm.PacketUpdateNotification;
import crazypants.enderio.machine.farm.farmers.FarmersCommune;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.RubberTreeFarmerIC2;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.power.BasicCapacitor;
import crazypants.enderio.power.Capacitors;
import crazypants.enderio.power.ICapacitor;
import crazypants.util.BlockCoord;
import crazypants.util.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileFarmStation
extends AbstractPoweredTaskEntity {
    public static final String NOTIFICATION_NO_HOE = "noHoe";
    public static final String NOTIFICATION_NO_AXE = "noAxe";
    public static final String NOTIFICATION_NO_SEEDS = "noSeeds";
    private BlockCoord lastScanned;
    private EntityPlayerMP farmerJoe;
    private int farmSize = Config.farmDefaultSize;
    private int minToolSlot = 0;
    private int maxToolSlot = 1;
    int minSupSlot = this.maxToolSlot + 1;
    int maxSupSlot = this.minSupSlot + 4;
    List<Integer> lockedSlots = new ArrayList<Integer>();
    private final int upgradeBonusSize = 2;
    private ICapacitor cap = new BasicCapacitor(200, 25000);
    public int tier = 1;
    public String notification = "";
    public boolean sendNotification = false;

    public TileFarmStation() {
        super(new SlotDefinition(6, 4, 1));
        this.setCapacitor(Capacitors.BASIC_CAPACITOR);
    }

    public int getFarmSize() {
        return this.farmSize + this.getUpgradeDist();
    }

    public void actionPerformed(boolean isAxe) {
        if (isAxe) {
            this.usePower(Config.farmAxeActionEnergyUseRF);
        } else {
            this.usePower(Config.farmActionEnergyUseRF);
        }
        this.clearNotification();
    }

    public boolean tillBlock(BlockCoord plantingLocation) {
        BlockCoord dirtLoc = plantingLocation.getLocation(ForgeDirection.DOWN);
        Block dirtBlock = this.getBlock(dirtLoc);
        if (dirtBlock == Blocks.field_150346_d || dirtBlock == Blocks.field_150349_c) {
            if (!this.hasHoe()) {
                this.setNotification(NOTIFICATION_NO_HOE);
                return false;
            }
            this.damageHoe(1, dirtLoc);
            this.field_145850_b.func_147449_b(dirtLoc.x, dirtLoc.y, dirtLoc.z, Blocks.field_150458_ak);
            this.field_145850_b.func_72908_a((double)((float)dirtLoc.x + 0.5f), (double)((float)dirtLoc.y + 0.5f), (double)((float)dirtLoc.z + 0.5f), Blocks.field_150458_ak.field_149762_H.func_150498_e(), (Blocks.field_150458_ak.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150458_ak.field_149762_H.func_150494_d() * 0.8f);
            this.actionPerformed(false);
            return true;
        }
        return dirtBlock == Blocks.field_150458_ak;
    }

    public int getMaxLootingValue() {
        int result = 0;
        for (int i = this.minToolSlot; i <= this.maxToolSlot; ++i) {
            int level;
            if (this.inventory[i] == null || (level = this.getLooting(this.inventory[i])) <= result) continue;
            result = level;
        }
        return result;
    }

    private int getUpgradeDist() {
        int upg = this.slotDefinition.getMaxUpgradeSlot();
        if (this.inventory[upg] == null) {
            return 0;
        }
        return 2 * this.inventory[upg].func_77960_j();
    }

    public boolean hasHoe() {
        return this.hasTool(ToolType.HOE);
    }

    public boolean hasAxe() {
        return this.hasTool(ToolType.AXE);
    }

    public int getAxeLootingValue() {
        ItemStack tool = this.getTool(ToolType.AXE);
        if (tool == null) {
            return 0;
        }
        return this.getLooting(tool);
    }

    public void damageAxe(Block blk, BlockCoord bc) {
        this.damageTool(ToolType.AXE, blk, bc, 1);
    }

    public void damageHoe(int i, BlockCoord bc) {
        this.damageTool(ToolType.HOE, null, bc, i);
    }

    public boolean hasTool(ToolType type) {
        return this.getTool(type) != null;
    }

    private ItemStack getTool(ToolType type) {
        for (int i = this.minToolSlot; i <= this.maxToolSlot; ++i) {
            if (!type.itemMatches(this.inventory[i]) || this.inventory[i].field_77994_a <= 0) continue;
            return this.inventory[i];
        }
        return null;
    }

    public void damageTool(ToolType type, Block blk, BlockCoord bc, int damage) {
        float rand = this.field_145850_b.field_73012_v.nextFloat();
        if (rand >= Config.farmToolTakeDamageChance) {
            return;
        }
        ItemStack tool = this.getTool(type);
        if (tool == null) {
            return;
        }
        boolean canDamage = this.canDamage(tool);
        if (type == ToolType.AXE) {
            tool.func_77973_b().func_150894_a(tool, this.field_145850_b, blk, bc.x, bc.y, bc.z, (EntityLivingBase)this.farmerJoe);
        } else if (type == ToolType.HOE) {
            int origDamage = tool.func_77960_j();
            tool.func_77973_b().func_77648_a(tool, (EntityPlayer)this.farmerJoe, this.field_145850_b, bc.x, bc.y, bc.z, 1, 0.5f, 0.5f, 0.5f);
            if (origDamage == tool.func_77960_j() && canDamage) {
                tool.func_77972_a(1, (EntityLivingBase)this.farmerJoe);
            }
        } else if (canDamage) {
            tool.func_77972_a(1, (EntityLivingBase)this.farmerJoe);
        }
        if (tool.field_77994_a == 0 || canDamage && tool.func_77960_j() >= tool.func_77958_k()) {
            this.destroyTool(type);
        }
    }

    private boolean canDamage(ItemStack stack) {
        return stack != null && stack.func_77984_f() && stack.func_77973_b().func_77645_m();
    }

    private void destroyTool(ToolType type) {
        for (int i = this.minToolSlot; i <= this.maxToolSlot; ++i) {
            if (!type.itemMatches(this.inventory[i]) || this.inventory[i].field_77994_a != 0) continue;
            this.inventory[i] = null;
            this.func_70296_d();
            return;
        }
    }

    private int getLooting(ItemStack stack) {
        return Math.max(EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)stack), EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
    }

    public EntityPlayerMP getFakePlayer() {
        return this.farmerJoe;
    }

    public Block getBlock(BlockCoord bc) {
        return this.field_145850_b.func_147439_a(bc.x, bc.y, bc.z);
    }

    public Block getBlock(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z);
    }

    public int getBlockMeta(BlockCoord bc) {
        return this.field_145850_b.func_72805_g(bc.x, bc.y, bc.z);
    }

    public boolean isOpen(BlockCoord bc) {
        Block block = this.field_145850_b.func_147439_a(bc.x, bc.y, bc.z);
        return block.isAir((IBlockAccess)this.field_145850_b, bc.x, bc.y, bc.z) || block.isReplaceable((IBlockAccess)this.field_145850_b, bc.x, bc.y, bc.z);
    }

    public void setNotification(String unloc) {
        String newNote = Lang.localize("farm.note." + unloc);
        if (!newNote.equals(this.notification)) {
            this.notification = newNote;
            this.sendNotification = true;
        }
    }

    public void clearNotification() {
        if (this.hasNotification()) {
            this.notification = "";
            this.sendNotification = true;
        }
    }

    public boolean hasNotification() {
        return !"".equals(this.notification);
    }

    private void sendNotification() {
        PacketHandler.INSTANCE.sendToAll((IMessage)new PacketUpdateNotification(this, this.notification));
    }

    @Override
    protected boolean isMachineItemValidForSlot(int i, ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (i <= this.maxToolSlot) {
            if (ToolType.isTool(stack)) {
                int otherSlot;
                int n = otherSlot = i == this.minToolSlot ? this.maxToolSlot : this.minToolSlot;
                if (this.inventory[otherSlot] == null) {
                    return true;
                }
                for (ToolType type : ToolType.values()) {
                    if (!type.itemMatches(this.inventory[otherSlot]) || !type.itemMatches(stack)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return (this.inventory[i] != null || !this.isSlotLocked(i)) && FarmersCommune.instance.canPlant(stack);
    }

    @Override
    protected boolean checkProgress(boolean redstoneChecksPassed) {
        if (redstoneChecksPassed) {
            this.usePower();
            if (this.canTick(redstoneChecksPassed)) {
                this.doTick();
            }
        }
        return false;
    }

    protected boolean canTick(boolean redstoneChecksPassed) {
        if (this.field_145850_b.func_82737_E() % 2L != 0L) {
            return false;
        }
        if (this.getEnergyStored() < this.getPowerUsePerTick()) {
            this.setNotification("noPower");
            return false;
        }
        int curScaled = this.getProgressScaled(16);
        if (curScaled != this.lastProgressScaled) {
            this.sendTaskProgressPacket();
            this.lastProgressScaled = curScaled;
        }
        return true;
    }

    protected void doTick() {
        IHarvestResult harvest;
        BlockCoord bc;
        if (this.sendNotification && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.sendNotification = false;
            this.sendNotification();
        }
        if (!this.hasPower() && Config.farmActionEnergyUseRF > 0 && Config.farmAxeActionEnergyUseRF > 0) {
            this.setNotification("noPower");
            return;
        }
        if ("noPower".equals(this.notification)) {
            this.clearNotification();
        }
        if ((bc = this.getNextCoord()) != null && bc.equals(this.getLocation())) {
            bc = this.getNextCoord();
        }
        if (bc == null) {
            return;
        }
        this.lastScanned = bc;
        Block block = this.field_145850_b.func_147439_a(bc.x, bc.y, bc.z);
        if (block == null) {
            return;
        }
        int meta = this.field_145850_b.func_72805_g(bc.x, bc.y, bc.z);
        if (this.farmerJoe == null) {
            this.farmerJoe = new FakeFarmPlayer(MinecraftServer.func_71276_C().func_71218_a(this.field_145850_b.field_73011_w.field_76574_g));
        }
        if (this.isOpen(bc)) {
            FarmersCommune.instance.prepareBlock(this, bc, block, meta);
            block = this.field_145850_b.func_147439_a(bc.x, bc.y, bc.z);
        }
        if (this.isOutputFull()) {
            this.setNotification("outputFull");
            return;
        }
        if (!this.hasPower() && Config.farmActionEnergyUseRF > 0 && Config.farmAxeActionEnergyUseRF > 0) {
            this.setNotification("noPower");
            return;
        }
        if (!this.isOpen(bc) && (harvest = FarmersCommune.instance.harvestBlock(this, bc, block, meta)) != null && harvest.getDrops() != null) {
            PacketFarmAction pkt = new PacketFarmAction(harvest.getHarvestedBlocks());
            PacketHandler.INSTANCE.sendToAllAround((IMessage)pkt, new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)bc.x, (double)bc.y, (double)bc.z, 64.0));
            for (EntityItem ei : harvest.getDrops()) {
                if (ei == null) continue;
                this.insertHarvestDrop((Entity)ei);
                if (ei.field_70128_L) continue;
                this.field_145850_b.func_72838_d((Entity)ei);
            }
        }
    }

    private boolean isOutputFull() {
        for (int i = this.slotDefinition.minOutputSlot; i <= this.slotDefinition.maxOutputSlot; ++i) {
            ItemStack curStack = this.inventory[i];
            if (curStack != null && curStack.field_77994_a >= curStack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public boolean hasSeed(ItemStack seeds, BlockCoord bc) {
        int slot = this.getSupplySlotForCoord(bc);
        ItemStack inv = this.inventory[slot];
        return inv != null && (inv.field_77994_a > 1 || !this.isSlotLocked(slot)) && inv.func_77969_a(seeds);
    }

    public ItemStack takeSeedFromSupplies(ItemStack stack, BlockCoord forBlock) {
        return this.takeSeedFromSupplies(stack, forBlock, true);
    }

    public ItemStack takeSeedFromSupplies(ItemStack stack, BlockCoord forBlock, boolean matchMetadata) {
        if (stack == null || forBlock == null) {
            return null;
        }
        int slot = this.getSupplySlotForCoord(forBlock);
        ItemStack inv = this.inventory[slot];
        if (inv != null && (matchMetadata ? inv.func_77969_a(stack) : inv.func_77973_b() == stack.func_77973_b())) {
            if (inv.field_77994_a <= 1 && this.isSlotLocked(slot)) {
                return null;
            }
            ItemStack result = inv.func_77946_l();
            result.field_77994_a = 1;
            inv = inv.func_77946_l();
            --inv.field_77994_a;
            if (inv.field_77994_a == 0) {
                inv = null;
            }
            this.func_70299_a(slot, inv);
            return result;
        }
        return null;
    }

    public ItemStack takeSeedFromSupplies(BlockCoord bc) {
        return this.takeSeedFromSupplies(this.getSeedTypeInSuppliesFor(bc), bc);
    }

    public ItemStack getSeedTypeInSuppliesFor(BlockCoord bc) {
        int slot = this.getSupplySlotForCoord(bc);
        ItemStack inv = this.inventory[slot];
        if (!(inv == null || inv.field_77994_a <= 1 && this.isSlotLocked(slot))) {
            return inv.func_77946_l();
        }
        return null;
    }

    protected int getSupplySlotForCoord(BlockCoord forBlock) {
        if (forBlock.x <= this.field_145851_c && forBlock.z > this.field_145849_e) {
            return this.minSupSlot;
        }
        if (forBlock.x > this.field_145851_c && forBlock.z > this.field_145849_e - 1) {
            return this.minSupSlot + 1;
        }
        if (forBlock.x < this.field_145851_c && forBlock.z <= this.field_145849_e) {
            return this.minSupSlot + 2;
        }
        return this.minSupSlot + 3;
    }

    private void insertHarvestDrop(Entity entity) {
        if (!this.field_145850_b.field_72995_K && entity instanceof EntityItem && !entity.field_70128_L) {
            EntityItem item = (EntityItem)entity;
            ItemStack stack = item.func_92059_d().func_77946_l();
            int numInserted = this.insertResult(stack);
            stack.field_77994_a -= numInserted;
            item.func_92058_a(stack);
            if (stack.field_77994_a == 0) {
                item.func_70106_y();
            }
        }
    }

    private int insertResult(ItemStack stack) {
        int origSize = stack.field_77994_a;
        stack = stack.func_77946_l();
        int inserted = 0;
        for (int i = this.slotDefinition.minInputSlot; i <= this.slotDefinition.maxInputSlot && inserted < stack.field_77994_a; ++i) {
            ItemStack curStack = this.inventory[i];
            if (!this.func_94041_b(i, stack) || curStack != null && curStack.field_77994_a >= 16) continue;
            if (curStack == null) {
                this.inventory[i] = stack.func_77946_l();
                inserted = stack.field_77994_a;
                continue;
            }
            if (!curStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)curStack, (ItemStack)stack)) continue;
            inserted = Math.min(16 - curStack.field_77994_a, stack.field_77994_a);
            this.inventory[i].field_77994_a += inserted;
        }
        stack.field_77994_a -= inserted;
        if (inserted >= origSize) {
            return origSize;
        }
        IMachineRecipe.ResultStack[] in = new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(stack)};
        this.mergeResults(in);
        return origSize - (in[0].item == null ? 0 : in[0].item.field_77994_a);
    }

    @Override
    protected int getNumCanMerge(ItemStack itemStack, ItemStack result) {
        if (!itemStack.func_77969_a(result) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)result)) {
            return 0;
        }
        return Math.min(itemStack.func_77976_d() - itemStack.field_77994_a, result.field_77994_a);
    }

    private BlockCoord getNextCoord() {
        int size = this.getFarmSize();
        BlockCoord loc = this.getLocation();
        if (this.lastScanned == null) {
            this.lastScanned = new BlockCoord(loc.x - size, loc.y, loc.z - size);
            return this.lastScanned;
        }
        int nextX = this.lastScanned.x + 1;
        int nextZ = this.lastScanned.z;
        if (nextX > loc.x + size) {
            nextX = loc.x - size;
            if (++nextZ > loc.z + size) {
                this.lastScanned = null;
                return this.getNextCoord();
            }
        }
        return new BlockCoord(nextX, this.lastScanned.y, nextZ);
    }

    public void toggleLockedState(int buttonID) {
        if (this.field_145850_b.field_72995_K) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketFarmLockedSlot(this, buttonID));
        }
        if (this.lockedSlots.contains(buttonID += this.minSupSlot)) {
            this.lockedSlots.remove((Object)buttonID);
        } else {
            this.lockedSlots.add(buttonID);
        }
    }

    public boolean isSlotLocked(int slot) {
        return this.lockedSlots.contains(slot);
    }

    @Override
    public String func_145825_b() {
        return EnderIO.blockFarmStation.func_149732_F();
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public String getMachineName() {
        return ModObject.blockFarmStation.unlocalisedName;
    }

    @Override
    public float getProgress() {
        return 0.5f;
    }

    @Override
    public void setCapacitor(Capacitors capacitorType) {
        this.capacitorType = capacitorType;
        this.tier = capacitorType.ordinal();
        this.currentTask = this.createTask();
        int ppt = this.calcPowerUsePerTick();
        switch (capacitorType.ordinal()) {
            case 1: {
                this.cap = new BasicCapacitor(ppt * 40, 500000, ppt);
                break;
            }
            case 2: {
                this.cap = new BasicCapacitor(ppt * 40, 1000000, ppt);
                break;
            }
            default: {
                this.cap = new BasicCapacitor(ppt * 40, 250000, ppt);
            }
        }
        if (this.getEnergyStored() > this.getMaxEnergyStored()) {
            this.setEnergyStored(this.getMaxEnergyStored());
        }
    }

    private int calcPowerUsePerTick() {
        return Math.round((float)Config.farmContinuousEnergyUseRF * ((float)this.getFarmSize() / (float)Config.farmDefaultSize));
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtRoot) {
        super.readCustomNBT(nbtRoot);
        this.currentTask = this.createTask();
        for (int i : nbtRoot.func_74759_k("lockedSlots")) {
            this.lockedSlots.add(i);
        }
    }

    IPoweredTask createTask() {
        return new ContinuousTask(this.getPowerUsePerTick());
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtRoot) {
        super.writeCustomNBT(nbtRoot);
        nbtRoot.func_74757_a("isActive", this.isActive());
        int[] locked = new int[this.lockedSlots.size()];
        for (int i = 0; i < this.lockedSlots.size(); ++i) {
            locked[i] = this.lockedSlots.get(i);
        }
        nbtRoot.func_74783_a("lockedSlots", locked);
    }

    public static enum ToolType {
        HOE{

            @Override
            boolean match(ItemStack item) {
                for (ItemStack stack : Config.farmHoes) {
                    if (stack.func_77973_b() != item.func_77973_b()) continue;
                    return true;
                }
                return false;
            }
        }
        ,
        AXE{

            @Override
            boolean match(ItemStack item) {
                return item.func_77973_b().getHarvestLevel(item, "axe") >= 0;
            }
        }
        ,
        TREETAP{

            @Override
            boolean match(ItemStack item) {
                return item.func_77973_b().getClass() == RubberTreeFarmerIC2.treeTap;
            }
        };


        public final boolean itemMatches(ItemStack item) {
            if (item == null) {
                return false;
            }
            return this.match(item) && !this.isBrokenTinkerTool(item);
        }

        private boolean isBrokenTinkerTool(ItemStack item) {
            return item.func_77942_o() && item.func_77978_p().func_74764_b("InfiTool") && item.func_77978_p().func_74775_l("InfiTool").func_74767_n("Broken");
        }

        abstract boolean match(ItemStack var1);

        public static boolean isTool(ItemStack stack) {
            for (ToolType type : ToolType.values()) {
                if (!type.itemMatches(stack)) continue;
                return true;
            }
            return false;
        }
    }
}

