/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.darksteel;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class EnergyContainer {
    private int capacityRF;
    private int maxReceiveRF;
    private int maxExtractRF;

    public EnergyContainer(int capacityRF, int maxReceiveRF, int maxExtractRF) {
        this.capacityRF = capacityRF;
        this.maxReceiveRF = maxReceiveRF;
        this.maxExtractRF = maxExtractRF;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyReceived = Math.min(this.capacityRF - energy, Math.min(this.maxReceiveRF, maxReceive));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy += energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container == null || container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        int energy = container.field_77990_d.func_74762_e("Energy");
        int energyExtracted = Math.min(energy, Math.min(this.maxExtractRF, maxExtract));
        if (!simulate) {
            container.field_77990_d.func_74768_a("Energy", energy -= energyExtracted);
        }
        return energyExtracted;
    }

    public static int getEnergyStored(ItemStack container) {
        if (container == null || container.field_77990_d == null || !container.field_77990_d.func_74764_b("Energy")) {
            return 0;
        }
        return container.field_77990_d.func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.capacityRF;
    }

    public static void setEnergy(ItemStack container, int energy) {
        if (container.field_77990_d == null) {
            container.field_77990_d = new NBTTagCompound();
        }
        container.field_77990_d.func_74768_a("Energy", energy);
    }

    public void setFull(ItemStack container) {
        EnergyContainer.setEnergy(container, this.capacityRF);
    }

    public boolean isAbsorbDamageWithPower(ItemStack is) {
        NBTTagCompound root = is.func_77978_p();
        if (root == null) {
            return false;
        }
        return root.func_74767_n("absorbWithPower");
    }

    public void setAbsorbDamageWithPower(ItemStack is, boolean val) {
        NBTTagCompound root = is.func_77978_p();
        if (root == null) {
            root = new NBTTagCompound();
            is.func_77982_d(root);
        }
        root.func_74757_a("absorbWithPower", val);
    }
}

