/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.fluid;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import org.apache.commons.lang3.StringUtils;

public class BlockFluidEio
extends BlockFluidClassic {
    protected Fluid fluid;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] icons;

    public static BlockFluidEio create(Fluid fluid, Material material) {
        BlockFluidEio res = new BlockFluidEio(fluid, material);
        res.init();
        fluid.setBlock((Block)res);
        return res;
    }

    protected BlockFluidEio(Fluid fluid, Material material) {
        super(fluid, material);
        this.fluid = fluid;
        this.func_149663_c(fluid.getUnlocalizedName());
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, (String)("block" + StringUtils.capitalize((String)this.fluidName)));
    }

    public IIcon func_149691_a(int side, int meta) {
        return side != 0 && side != 1 ? this.icons[1] : this.icons[0];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[]{iconRegister.func_94245_a("enderio:" + this.fluidName + "_still"), iconRegister.func_94245_a("enderio:" + this.fluidName + "_flow")};
        this.fluid.setIcons(this.icons[0], this.icons[1]);
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    public void func_149670_a(World p_149670_1_, int p_149670_2_, int p_149670_3_, int p_149670_4_, Entity entity) {
        if (entity.field_70170_p.field_72995_K) {
            super.func_149670_a(p_149670_1_, p_149670_2_, p_149670_3_, p_149670_4_, entity);
            return;
        }
        if (this == EnderIO.blockFireWater) {
            entity.func_70015_d(50);
        } else if (this == EnderIO.blockRocketFuel && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 150, 3, true));
        } else if (this == EnderIO.blockNutrientDistillation && entity instanceof EntityPlayerMP) {
            long time = entity.field_70170_p.func_82737_E();
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (time % Config.nutrientFoodBoostDelay == 0L && player.getEntityData().func_74763_f("eioLastFoodBoost") != time) {
                player.func_71024_bL().func_75122_a(1, 0.1f);
                player.getEntityData().func_74772_a("eioLastFoodBoost", time);
            }
        } else if (this == EnderIO.blockHootch && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 0, true));
        }
        super.func_149670_a(p_149670_1_, p_149670_2_, p_149670_3_, p_149670_4_, entity);
    }
}

