/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.item;

import cpw.mods.fml.common.gameevent.TickEvent;
import crazypants.enderio.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduit.ConduitNetworkTickHandler;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.ItemConduit;
import crazypants.enderio.conduit.item.NetworkedInventory;
import crazypants.enderio.conduit.item.filter.IItemFilter;
import crazypants.util.BlockCoord;
import crazypants.util.Lang;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemConduitNetwork
extends AbstractConduitNetwork<IItemConduit, IItemConduit> {
    private long timeAtLastApply;
    final List<NetworkedInventory> inventories = new ArrayList<NetworkedInventory>();
    private final Map<BlockCoord, List<NetworkedInventory>> invMap = new HashMap<BlockCoord, List<NetworkedInventory>>();
    final Map<BlockCoord, IItemConduit> conMap = new HashMap<BlockCoord, IItemConduit>();
    private boolean requiresSort = true;
    private boolean doingSend = false;
    private final InnerTickHandler tickHandler = new InnerTickHandler();
    static int MAX_SLOT_CHECK_PER_TICK = 64;

    public ItemConduitNetwork() {
        super(IItemConduit.class);
    }

    @Override
    public Class<IItemConduit> getBaseConduitType() {
        return IItemConduit.class;
    }

    @Override
    public void addConduit(IItemConduit con) {
        super.addConduit(con);
        this.conMap.put(con.getLocation(), con);
        TileEntity te = con.getBundle().getEntity();
        if (te != null) {
            for (ForgeDirection direction : con.getExternalConnections()) {
                IInventory extCon = con.getExternalInventory(direction);
                if (extCon == null) continue;
                this.inventoryAdded(con, direction, te.field_145851_c + direction.offsetX, te.field_145848_d + direction.offsetY, te.field_145849_e + direction.offsetZ, extCon);
            }
        }
    }

    public void inventoryAdded(IItemConduit itemConduit, ForgeDirection direction, int x, int y, int z, IInventory externalInventory) {
        BlockCoord bc = new BlockCoord(x, y, z);
        NetworkedInventory inv = new NetworkedInventory(this, externalInventory, itemConduit, direction, bc);
        this.inventories.add(inv);
        this.getOrCreate(bc).add(inv);
        this.requiresSort = true;
    }

    public NetworkedInventory getInventory(IItemConduit conduit, ForgeDirection dir) {
        for (NetworkedInventory inv : this.inventories) {
            if (inv.con != conduit || inv.conDir != dir) continue;
            return inv;
        }
        return null;
    }

    private List<NetworkedInventory> getOrCreate(BlockCoord bc) {
        List<NetworkedInventory> res = this.invMap.get(bc);
        if (res == null) {
            res = new ArrayList<NetworkedInventory>();
            this.invMap.put(bc, res);
        }
        return res;
    }

    public void inventoryRemoved(ItemConduit itemConduit, int x, int y, int z) {
        BlockCoord bc = new BlockCoord(x, y, z);
        List<NetworkedInventory> invs = this.getOrCreate(bc);
        NetworkedInventory remove = null;
        for (NetworkedInventory ni : invs) {
            if (!ni.con.getLocation().equals(itemConduit.getLocation())) continue;
            remove = ni;
            break;
        }
        if (remove != null) {
            invs.remove(remove);
            this.inventories.remove(remove);
            this.requiresSort = true;
        }
    }

    public void routesChanged() {
        this.requiresSort = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemStack sendItems(ItemConduit itemConduit, ItemStack item, ForgeDirection side) {
        if (this.doingSend) {
            return item;
        }
        if (item == null) {
            return item;
        }
        try {
            this.doingSend = true;
            BlockCoord loc = itemConduit.getLocation().getLocation(side);
            ItemStack result = item.func_77946_l();
            List<NetworkedInventory> invs = this.getOrCreate(loc);
            for (NetworkedInventory inv : invs) {
                if (!inv.con.getLocation().equals(itemConduit.getLocation())) continue;
                int numInserted = inv.insertIntoTargets(item.func_77946_l());
                if (numInserted >= item.field_77994_a) {
                    ItemStack itemStack = null;
                    return itemStack;
                }
                result.field_77994_a -= numInserted;
            }
            ItemStack itemStack = result;
            return itemStack;
        }
        finally {
            this.doingSend = false;
        }
    }

    public List<String> getTargetsForExtraction(BlockCoord extractFrom, IItemConduit con, ItemStack input) {
        ArrayList<String> result = new ArrayList<String>();
        List<NetworkedInventory> invs = this.getOrCreate(extractFrom);
        for (NetworkedInventory source : invs) {
            if (!source.con.getLocation().equals(con.getLocation()) || source == null || source.sendPriority == null) continue;
            for (NetworkedInventory.Target t : source.sendPriority) {
                IItemFilter f = t.inv.con.getOutputFilter(t.inv.conDir);
                if (input != null && f != null && !f.doesItemPassFilter(t.inv, input)) continue;
                String s = Lang.localize(t.inv.getInventory().func_145825_b(), false) + " " + t.inv.location + " Distance [" + t.distance + "] ";
                result.add(s);
            }
        }
        return result;
    }

    public List<String> getInputSourcesFor(IItemConduit con, ForgeDirection dir, ItemStack input) {
        ArrayList<String> result = new ArrayList<String>();
        for (NetworkedInventory inv : this.inventories) {
            if (!inv.hasTarget(con, dir)) continue;
            IItemFilter f = inv.con.getInputFilter(inv.conDir);
            if (input != null && f != null && !f.doesItemPassFilter(inv, input)) continue;
            result.add(Lang.localize(inv.getInventory().func_145825_b(), false) + " " + inv.location);
        }
        return result;
    }

    private boolean isRemote(ItemConduit itemConduit) {
        World world = itemConduit.getBundle().getEntity().func_145831_w();
        return world != null && world.field_72995_K;
    }

    @Override
    public void onUpdateEntity(IConduit conduit) {
        World world = conduit.getBundle().getEntity().func_145831_w();
        if (world == null) {
            return;
        }
        if (world.field_72995_K) {
            return;
        }
        long curTime = world.func_82737_E();
        if (curTime != this.timeAtLastApply) {
            this.timeAtLastApply = curTime;
            this.tickHandler.tick = world.func_82737_E();
            ConduitNetworkTickHandler.instance.addListener(this.tickHandler);
        }
    }

    private void doTick(long tick) {
        for (NetworkedInventory ni : this.inventories) {
            if (this.requiresSort) {
                ni.updateInsertOrder();
            }
            ni.onTick(tick);
        }
        this.requiresSort = false;
    }

    static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private class InnerTickHandler
    implements ConduitNetworkTickHandler.TickListener {
        long tick;

        private InnerTickHandler() {
        }

        @Override
        public void tickStart(TickEvent.ServerTickEvent evt) {
        }

        @Override
        public void tickEnd(TickEvent.ServerTickEvent evt) {
            ItemConduitNetwork.this.doTick(this.tick);
        }
    }
}

