/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui.item;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.gui.item.IItemFilterGui;
import crazypants.enderio.conduit.gui.item.PacketExistingItemFilterSnapshot;
import crazypants.enderio.conduit.item.IItemConduit;
import crazypants.enderio.conduit.item.filter.ExistingItemFilter;
import crazypants.enderio.conduit.packet.PacketItemConduitFilter;
import crazypants.enderio.gui.IGuiOverlay;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.gui.ToggleButtonEIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.gui.IGuiScreen;
import crazypants.render.RenderUtil;
import crazypants.util.Lang;
import crazypants.vecmath.Vector4f;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ExistingItemFilterGui
implements IItemFilterGui {
    private static final int ID_NBT = GuiExternalConnection.nextButtonId();
    private static final int ID_META = GuiExternalConnection.nextButtonId();
    private static final int ID_ORE_DICT = GuiExternalConnection.nextButtonId();
    private static final int ID_STICKY = GuiExternalConnection.nextButtonId();
    private static final int ID_SNAPSHOT = GuiExternalConnection.nextButtonId();
    private static final int ID_CLEAR = GuiExternalConnection.nextButtonId();
    private static final int ID_SHOW = GuiExternalConnection.nextButtonId();
    private static final int ID_MERGE = GuiExternalConnection.nextButtonId();
    private IItemConduit itemConduit;
    private GuiExternalConnection gui;
    private ToggleButtonEIO useMetaB;
    private ToggleButtonEIO useNbtB;
    private ToggleButtonEIO useOreDictB;
    private ToggleButtonEIO stickyB;
    private GuiButton snapshotB;
    private GuiButton clearB;
    private GuiButton showB;
    private GuiButton mergeB;
    private SnapshotOverlay snapshotOverlay;
    boolean isInput;
    private ExistingItemFilter filter;

    public ExistingItemFilterGui(GuiExternalConnection gui, IItemConduit itemConduit, boolean isInput) {
        int butLeft;
        this.gui = gui;
        this.itemConduit = itemConduit;
        this.isInput = isInput;
        this.filter = isInput ? (ExistingItemFilter)itemConduit.getInputFilter(gui.getDir()) : (ExistingItemFilter)itemConduit.getOutputFilter(gui.getDir());
        int x = butLeft = 37;
        int y = 68;
        this.useMetaB = new ToggleButtonEIO(gui, ID_META, x, y, IconEIO.FILTER_META_OFF, IconEIO.FILTER_META);
        this.useMetaB.setSelectedToolTip(Lang.localize("gui.conduit.item.matchMetaData"));
        this.useMetaB.setUnselectedToolTip(Lang.localize("gui.conduit.item.ignoreMetaData"));
        this.useMetaB.setPaintSelectedBorder(false);
        this.stickyB = new ToggleButtonEIO(gui, ID_STICKY, x += 20, y, IconEIO.FILTER_STICKY_OFF, IconEIO.FILTER_STICKY);
        String[] lines = Lang.localizeList("gui.conduit.item.stickyEnabled");
        this.stickyB.setSelectedToolTip(lines);
        this.stickyB.setUnselectedToolTip(Lang.localize("gui.conduit.item.stickyDisbaled"));
        this.stickyB.setPaintSelectedBorder(false);
        x = butLeft;
        this.useNbtB = new ToggleButtonEIO(gui, ID_NBT, x += 20, y += 20, IconEIO.FILTER_NBT_OFF, IconEIO.FILTER_NBT);
        this.useNbtB.setSelectedToolTip(Lang.localize("gui.conduit.item.matchNBT"));
        this.useNbtB.setUnselectedToolTip(Lang.localize("gui.conduit.item.ignoreNBT"));
        this.useNbtB.setPaintSelectedBorder(false);
        x = butLeft;
        this.useOreDictB = new ToggleButtonEIO(gui, ID_ORE_DICT, x, y, IconEIO.FILTER_ORE_DICT_OFF, IconEIO.FILTER_ORE_DICT);
        this.useOreDictB.setSelectedToolTip(Lang.localize("gui.conduit.item.oreDicEnabled"));
        this.useOreDictB.setUnselectedToolTip(Lang.localize("gui.conduit.item.oreDicDisabled"));
        this.useOreDictB.setPaintSelectedBorder(false);
        this.snapshotB = new GuiButton(ID_SNAPSHOT, 0, 0, 60, 20, Lang.localize("gui.conduit.button.snap"));
        this.mergeB = new GuiButton(ID_MERGE, 0, 0, 40, 20, Lang.localize("gui.conduit.button.merge"));
        this.clearB = new GuiButton(ID_CLEAR, 0, 0, 60, 20, Lang.localize("gui.conduit.button.clear"));
        this.showB = new GuiButton(ID_SHOW, 0, 0, 40, 20, Lang.localize("gui.conduit.button.show"));
        this.snapshotOverlay = new SnapshotOverlay();
        gui.addOverlay(this.snapshotOverlay);
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
    }

    @Override
    public void updateButtons() {
        ExistingItemFilter activeFilter = this.filter;
        this.useNbtB.onGuiInit();
        this.useNbtB.setSelected(activeFilter.isMatchNBT());
        this.useOreDictB.onGuiInit();
        this.useOreDictB.setSelected(activeFilter.isUseOreDict());
        if (!this.isInput) {
            this.stickyB.onGuiInit();
            this.stickyB.setSelected(activeFilter.isSticky());
        }
        this.useMetaB.onGuiInit();
        this.useMetaB.setSelected(activeFilter.isMatchMeta());
        int x0 = this.gui.getGuiLeft() + 80;
        int y0 = this.gui.getGuiTop() + 65;
        int x1 = x0 + 65;
        int y1 = y0 + 22;
        this.snapshotB.field_146128_h = x0;
        this.snapshotB.field_146129_i = y0;
        this.mergeB.field_146128_h = x1;
        this.mergeB.field_146129_i = y0;
        this.clearB.field_146128_h = x0;
        this.clearB.field_146129_i = y1;
        this.showB.field_146128_h = x1;
        this.showB.field_146129_i = y1;
        this.showB.field_146124_l = this.clearB.field_146124_l = this.filter.getSnapshot() != null;
        this.mergeB.field_146124_l = this.filter.getSnapshot() != null;
        this.gui.addButton(this.snapshotB);
        this.gui.addButton(this.clearB);
        this.gui.addButton(this.showB);
        this.gui.addButton(this.mergeB);
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        if (guiButton.field_146127_k == ID_META) {
            this.filter.setMatchMeta(this.useMetaB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_NBT) {
            this.filter.setMatchNBT(this.useNbtB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_STICKY) {
            this.filter.setSticky(this.stickyB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_ORE_DICT) {
            this.filter.setUseOreDict(this.useOreDictB.isSelected());
            this.sendFilterChange();
        } else if (guiButton.field_146127_k == ID_SNAPSHOT) {
            this.sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode.SET);
        } else if (guiButton.field_146127_k == ID_CLEAR) {
            this.sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode.CLEAR);
        } else if (guiButton.field_146127_k == ID_MERGE) {
            this.sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode.MERGE);
        } else if (guiButton.field_146127_k == ID_SHOW) {
            this.showSnapshotOverlay();
        }
    }

    private void showSnapshotOverlay() {
        this.snapshotOverlay.setVisible(true);
    }

    private void sendSnapshotPacket(PacketExistingItemFilterSnapshot.Opcode opcode) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketExistingItemFilterSnapshot(this.itemConduit, this.gui.getDir(), this.isInput, opcode));
    }

    private void sendFilterChange() {
        this.updateButtons();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketItemConduitFilter(this.itemConduit, this.gui.getDir()));
    }

    @Override
    public void deactivate() {
        this.useNbtB.detach();
        this.useMetaB.detach();
        this.useOreDictB.detach();
        this.stickyB.detach();
        this.gui.removeButton(this.snapshotB);
        this.gui.removeButton(this.clearB);
        this.gui.removeButton(this.showB);
        this.gui.removeButton(this.mergeB);
    }

    @Override
    public void renderCustomOptions(int top, float par1, int par2, int par3) {
    }

    class SnapshotOverlay
    implements IGuiOverlay {
        boolean visible;

        SnapshotOverlay() {
        }

        @Override
        public void init(IGuiScreen screen) {
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle(0, 0, ((ExistingItemFilterGui)ExistingItemFilterGui.this).gui.field_146294_l, ((ExistingItemFilterGui)ExistingItemFilterGui.this).gui.field_146295_m);
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTick) {
            RenderHelper.func_74520_c();
            GL11.glEnable((int)3042);
            RenderUtil.renderQuad2D(4.0, 4.0, 0.0, (double)(ExistingItemFilterGui.this.gui.getXSize() - 9), (double)(ExistingItemFilterGui.this.gui.getYSize() - 8), new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
            RenderUtil.renderQuad2D(6.0, 6.0, 0.0, (double)(ExistingItemFilterGui.this.gui.getXSize() - 13), (double)(ExistingItemFilterGui.this.gui.getYSize() - 12), new Vector4f(0.6, 0.6, 0.6, 1.0));
            Minecraft mc = Minecraft.func_71410_x();
            RenderItem itemRenderer = new RenderItem();
            GL11.glEnable((int)2929);
            List<ItemStack> snapshot = ExistingItemFilterGui.this.filter.getSnapshot();
            int x = 15;
            int y = 10;
            int count = 0;
            for (ItemStack st : snapshot) {
                if (st != null) {
                    itemRenderer.func_82406_b(mc.field_71466_p, mc.func_110434_K(), st, x, y);
                }
                x += 20;
                if (++count % 9 != 0) continue;
                x = 15;
                y += 20;
            }
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public boolean isVisible() {
            return this.visible;
        }

        @Override
        public boolean handleMouseInput(int x, int y, int b) {
            return true;
        }

        @Override
        public boolean isMouseInBounds(int mouseX, int mouseY) {
            return this.getBounds().contains(mouseX, mouseY);
        }
    }
}

