/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.gui.GuiExternalConnection;
import crazypants.enderio.conduit.packet.PacketConnectionMode;
import crazypants.enderio.gui.ITabPanel;
import crazypants.enderio.gui.IconButtonEIO;
import crazypants.enderio.gui.IconEIO;
import crazypants.enderio.network.PacketHandler;
import crazypants.render.ColorUtil;
import crazypants.util.Lang;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class BaseSettingsPanel
implements ITabPanel {
    static final int PREV_MODE_B = 327;
    static final int NEXT_MODE_B = 328;
    protected final IconEIO icon;
    protected final GuiExternalConnection gui;
    protected final IConduit con;
    protected final String typeName;
    protected IconButtonEIO leftArrow;
    protected IconButtonEIO rightArrow;
    protected String modeLabel;
    protected int left = 0;
    protected int top = 0;
    protected int width = 0;
    protected int height = 0;
    protected int gap = 5;
    protected int customTop = 0;

    protected BaseSettingsPanel(IconEIO icon, String typeName, GuiExternalConnection gui, IConduit con) {
        this.icon = icon;
        this.typeName = typeName;
        this.gui = gui;
        this.con = con;
        this.modeLabel = Lang.localize("gui.conduit.ioMode");
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int x = this.gap * 3 + fr.func_78256_a(this.modeLabel);
        int y = 8;
        this.leftArrow = new IconButtonEIO(gui, 327, x, y, IconEIO.LEFT_ARROW);
        this.leftArrow.setSize(8, 16);
        this.rightArrow = new IconButtonEIO(gui, 328, x += this.leftArrow.getWidth() + this.gap + this.getLongestModeStringWidth() + this.gap, y, IconEIO.RIGHT_ARROW);
        this.rightArrow.setSize(8, 16);
        this.customTop = this.top + this.gap * 5 + fr.field_78288_b * 2;
        this.customTop -= 16;
    }

    @Override
    public void onGuiInit(int left, int top, int width, int height) {
        this.left = left;
        this.top = top;
        this.width = width;
        this.height = height;
        this.leftArrow.onGuiInit();
        this.rightArrow.onGuiInit();
        FontRenderer fr = this.gui.getFontRenderer();
        this.connectionModeChanged(this.con.getConnectionMode(this.gui.getDir()));
        this.initCustomOptions();
    }

    protected void initCustomOptions() {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public void mouseClicked(int x, int y, int par3) {
    }

    @Override
    public void keyTyped(char par1, int par2) {
    }

    @Override
    public void updateScreen() {
    }

    @Override
    public IconEIO getIcon() {
        return this.icon;
    }

    @Override
    public void actionPerformed(GuiButton guiButton) {
        if (guiButton.field_146127_k == 327) {
            this.con.setConnectionMode(this.gui.getDir(), this.con.getPreviousConnectionMode(this.gui.getDir()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConnectionMode(this.con, this.gui.getDir()));
            this.connectionModeChanged(this.con.getConnectionMode(this.gui.getDir()));
        } else if (guiButton.field_146127_k == 328) {
            this.con.setConnectionMode(this.gui.getDir(), this.con.getNextConnectionMode(this.gui.getDir()));
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConnectionMode(this.con, this.gui.getDir()));
            this.connectionModeChanged(this.con.getConnectionMode(this.gui.getDir()));
        }
    }

    protected void connectionModeChanged(ConnectionMode conectionMode) {
    }

    @Override
    public void render(float par1, int par2, int par3) {
        FontRenderer fr = this.gui.getFontRenderer();
        int rgb = ColorUtil.getRGB(Color.darkGray);
        int x = this.left + (this.width - fr.func_78256_a(this.getTypeName())) / 2;
        x = this.left;
        int y = this.gui.getGuiTop() + 13;
        this.gui.getFontRenderer().func_78276_b(this.modeLabel, x, y, rgb);
        String modeString = this.con.getConnectionMode(this.gui.getDir()).getLocalisedName();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        IconEIO icon = new IconEIO(10, 60, 64, 20);
        icon.renderIcon((x += this.gap + this.leftArrow.getWidth() + fr.func_78256_a(this.modeLabel) + this.gap) - this.gap, y - fr.field_78288_b / 2 - 1, this.getLongestModeStringWidth() + this.gap * 2, this.leftArrow.getHeight(), 0.0, true);
        int move = (this.getLongestModeStringWidth() - fr.func_78256_a(modeString)) / 2;
        rgb = ColorUtil.getRGB(Color.white);
        this.gui.getFontRenderer().func_78276_b(modeString, x += move, y, rgb);
        this.renderCustomOptions(y + this.gap + fr.field_78288_b + this.gap, par1, par2, par3);
    }

    protected void renderCustomOptions(int top, float par1, int par2, int par3) {
    }

    private int getLongestModeStringWidth() {
        int maxWidth = 0;
        for (ConnectionMode mode : ConnectionMode.values()) {
            int width = this.gui.getFontRenderer().func_78256_a(mode.getLocalisedName());
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    protected String getTypeName() {
        return this.typeName;
    }
}

