/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.util.decorators;

import com.gildedgames.util.ui.common.Decorator;
import com.gildedgames.util.ui.common.Gui;
import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.data.rect.ModDim2D;
import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.data.rect.RectModifier;
import com.gildedgames.util.ui.graphics.Graphics2D;
import com.gildedgames.util.ui.input.InputProvider;
import com.gildedgames.util.ui.util.decorators.ScissorableGui;

public class RepeatableGui
extends GuiFrame
implements Decorator<GuiFrame> {
    protected ScissorableGui repeatedGui;

    public RepeatableGui(Rect repeatArea, Gui repeatedGui) {
        this.dim().set(repeatArea);
        this.repeatedGui = new ScissorableGui(repeatArea, repeatedGui);
    }

    @Override
    public void draw(Graphics2D graphics, InputProvider input) {
        this.repeatedGui.getScissoredArea().set(this.dim());
        this.repeatedGui.dim().clear(new RectModifier.ModifierType[0]);
        this.repeatedGui.dim().add(this, RectModifier.ModifierType.POS, new RectModifier.ModifierType[0]);
        this.repeatedGui.dim().mod().resetPos().flush();
        float textureHeight = this.repeatedGui.dim().height();
        float textureWidth = this.repeatedGui.dim().width();
        float heightCountNeeded = 0.0f;
        float widthCountNeeded = 0.0f;
        if (textureHeight != 0.0f) {
            heightCountNeeded = this.dim().height() / textureHeight;
        }
        if (textureWidth != 0.0f) {
            widthCountNeeded = this.dim().width() / textureWidth;
        }
        ModDim2D oldDim = this.repeatedGui.dim().clone();
        ModDim2D oldDimNoMod = oldDim.clone().clear(new RectModifier.ModifierType[0]);
        int heightAmount = 0;
        while ((float)heightAmount <= heightCountNeeded) {
            int widthAmount = 0;
            while ((float)widthAmount <= widthCountNeeded) {
                this.repeatedGui.draw(graphics, input);
                this.repeatedGui.dim().mod().addX(textureWidth).flush();
                ++widthAmount;
            }
            this.repeatedGui.dim().mod().x(oldDimNoMod.x()).addY(textureHeight).flush();
            ++heightAmount;
        }
        this.repeatedGui.dim().set(oldDim);
    }

    @Override
    public GuiFrame getDecoratedElement() {
        return this.repeatedGui;
    }
}

