/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.ui.graphics;

import com.gildedgames.util.ui.data.rect.Rect;
import com.gildedgames.util.ui.data.rect.RectHolder;
import com.gildedgames.util.ui.graphics.Sprite;
import com.gildedgames.util.ui.util.rect.RectCollection;
import java.util.ArrayList;
import java.util.List;

public interface UVBehavior {
    public boolean shouldRecalculateUVs(Sprite var1, RectHolder var2);

    public void recalculateUVs(Sprite var1, RectHolder var2);

    public List<UVDimPair> getDrawnUVsFor(Sprite var1, RectHolder var2);

    public static class UVDimPair {
        private final Sprite.UV uv;
        private final Rect dim;

        public UVDimPair(Sprite.UV uv, Rect dim) {
            this.uv = uv;
            this.dim = dim;
        }

        public Sprite.UV getUV() {
            return this.uv;
        }

        public Rect getRect() {
            return this.dim;
        }

        public static List<Rect> toDims(List<UVDimPair> pairs) {
            ArrayList<Rect> dims = new ArrayList<Rect>();
            for (UVDimPair pair : pairs) {
                dims.add(pair.getRect());
            }
            return dims;
        }

        public static List<RectHolder> toDimHolders(List<UVDimPair> pairs) {
            ArrayList<RectHolder> dims = new ArrayList<RectHolder>();
            for (UVDimPair pair : pairs) {
                dims.add(RectCollection.flush(pair.getRect()));
            }
            return dims;
        }
    }
}

