/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.player.common.networking.messages;

import com.gildedgames.util.core.UtilCore;
import com.gildedgames.util.player.PlayerCore;
import com.gildedgames.util.player.common.IPlayerHookPool;
import com.gildedgames.util.player.common.networking.messages.MessagePlayerHook;
import com.gildedgames.util.player.common.player.IPlayerHook;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;

public class MessagePlayerHookRequest
implements IMessage {
    private UUID uuid;
    private IPlayerHookPool<?> pool;

    public MessagePlayerHookRequest() {
    }

    public MessagePlayerHookRequest(IPlayerHookPool<?> pool, UUID uuid) {
        this.pool = pool;
        this.uuid = uuid;
    }

    public void fromBytes(ByteBuf buf) {
        this.pool = PlayerCore.locate().getPool(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.uuid = new UUID(buf.readLong(), buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.pool.getName());
        buf.writeLong(this.uuid.getMostSignificantBits());
        buf.writeLong(this.uuid.getLeastSignificantBits());
    }

    public static class Handler
    implements IMessageHandler<MessagePlayerHookRequest, IMessage> {
        public IMessage onMessage(MessagePlayerHookRequest message, MessageContext ctx) {
            if (ctx.side.isServer()) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                UtilCore.NETWORK.sendTo(new MessagePlayerHook((IPlayerHook)message.pool.get(message.uuid)), player);
            }
            return null;
        }
    }
}

