/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.player.common;

import com.gildedgames.util.core.UtilCore;
import com.gildedgames.util.player.common.IPlayerHookFactory;
import com.gildedgames.util.player.common.IPlayerHookPool;
import com.gildedgames.util.player.common.networking.messages.MessagePlayerHookRequest;
import com.gildedgames.util.player.common.player.IPlayerHook;
import com.gildedgames.util.player.common.player.PlayerProfile;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class PlayerHookPool<T extends IPlayerHook>
implements IPlayerHookPool<T> {
    private HashMap<UUID, T> playerMap = new HashMap();
    private ArrayList<UUID> sentRequests = new ArrayList();
    private final String name;
    private final IPlayerHookFactory<T> factory;
    private final Side side;

    public PlayerHookPool(String name, IPlayerHookFactory<T> factory, Side side) {
        this.name = name;
        this.factory = factory;
        this.side = side;
    }

    @Override
    public void clear() {
        this.playerMap = new HashMap();
        this.sentRequests = new ArrayList();
    }

    @Override
    public T get(EntityPlayer player) {
        return this.get(player.func_110124_au());
    }

    @Override
    public IPlayerHookFactory<T> getFactory() {
        return this.factory;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void add(T player) {
        this.playerMap.put(player.getProfile().getUUID(), player);
    }

    @Override
    public T get(UUID uuid) {
        IPlayerHook player = (IPlayerHook)this.playerMap.get(uuid);
        if (player == null) {
            if (this.side.isClient() && !this.sentRequests.contains(uuid)) {
                UtilCore.NETWORK.sendToServer(new MessagePlayerHookRequest(this, uuid));
                this.sentRequests.add(uuid);
            }
            PlayerProfile profile = new PlayerProfile();
            profile.setUUID(uuid);
            player = this.factory.create(profile, this);
            this.add(player);
        }
        return (T)player;
    }

    @Override
    public void setPlayerHooks(List<T> players) {
        this.clear();
        for (IPlayerHook player : players) {
            this.add(player);
        }
    }

    @Override
    public Collection<T> getPlayerHooks() {
        return this.playerMap.values();
    }

    @Override
    public boolean shouldSave() {
        return true;
    }
}

