/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.io_manager.util;

import com.gildedgames.util.core.io.ByteBufBridge;
import com.gildedgames.util.core.io.ByteBufFactory;
import com.gildedgames.util.io_manager.IOCore;
import com.gildedgames.util.io_manager.constructor.IConstructor;
import com.gildedgames.util.io_manager.factory.IOBridge;
import com.gildedgames.util.io_manager.factory.IOFactory;
import com.gildedgames.util.io_manager.io.IO;
import com.gildedgames.util.player.common.player.IPlayerProfile;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;

public class IOUtil {
    private static final ByteBufFactory bufFactory = new ByteBufFactory();

    public static <I, O> void setIOList(String key, List<? extends IO<I, O>> list, IOFactory<I, O> factory, O output) {
        IOBridge outputBridge = factory.createOutputBridge(output);
        outputBridge.setInteger(key + "listSize", list.size());
        for (int count = 0; count < list.size(); ++count) {
            IO<I, O> obj = list.get(count);
            IOCore.io().set(key + "IO" + count, output, factory, obj);
        }
    }

    public static <I, O> List<? extends IO<I, O>> getIOList(String key, IOFactory<I, O> factory, I input) {
        IOBridge inputBridge = factory.createInputBridge(input);
        int listSize = inputBridge.getInteger(key + "listSize");
        ArrayList list = new ArrayList(listSize);
        for (int count = 0; count < listSize; ++count) {
            Object obj = IOCore.io().get(key + "IO" + count, input, factory, new IConstructor[0]);
            list.add(obj);
        }
        return list;
    }

    public static <I, O> void setCollection(String key, Collection<? extends IO<IOBridge, IOBridge>> collection, IOBridge output) {
        output.setInteger(key + "collectionSize", collection.size());
        int count = 0;
        for (IO<IOBridge, IOBridge> iO : collection) {
            output.setIO(key + "IO" + count, iO);
            ++count;
        }
    }

    public static <T extends IO<IOBridge, IOBridge>> Collection<T> getCollection(String key, IOBridge input) {
        int listSize = input.getInteger(key + "collectionSize");
        ArrayList list = new ArrayList(listSize);
        for (int count = 0; count < listSize; ++count) {
            Object obj = input.getIO(key + "IO" + count);
            list.add(obj);
        }
        return list;
    }

    public static <I, O> void setArray(String key, IO<IOBridge, IOBridge>[] array, IOBridge output) {
        output.setInteger(key + "arraySize", array.length);
        int count = 0;
        for (IO<IOBridge, IOBridge> obj : array) {
            output.setIO(key + "IO" + count, obj);
            ++count;
        }
    }

    public static <T extends IO<IOBridge, IOBridge>> T[] getArray(String key, IOBridge input) {
        int listSize = input.getInteger(key + "arraySize");
        ArrayList list = new ArrayList(listSize);
        for (int count = 0; count < listSize; ++count) {
            Object obj = input.getIO(key + "IO" + count);
            list.add(obj);
        }
        return (IO[])list.toArray();
    }

    public static <I, O> void setCollection(String key, Collection<? extends IO<I, O>> collection, IOFactory<I, O> factory, O output) {
        IOBridge outputBridge = factory.createOutputBridge(output);
        outputBridge.setInteger(key + "collectionSize", collection.size());
        int count = 0;
        for (IO<I, O> obj : collection) {
            IOCore.io().set(key + "IO" + count, output, factory, obj);
            ++count;
        }
    }

    public static <I, O, T extends IO<I, O>> Collection<T> getCollection(String key, IOFactory<I, O> factory, I input) {
        IOBridge inputBridge = factory.createInputBridge(input);
        int listSize = inputBridge.getInteger(key + "collectionSize");
        ArrayList list = new ArrayList(listSize);
        for (int count = 0; count < listSize; ++count) {
            Object obj = IOCore.io().get(key + "IO" + count, input, factory, new IConstructor[0]);
            list.add(obj);
        }
        return list;
    }

    public static void setIOList(String key, List<? extends IO<IOBridge, IOBridge>> list, IOBridge output) {
        output.setInteger(key + "listSize", list.size());
        for (int count = 0; count < list.size(); ++count) {
            output.setIO(key + "IO" + count, list.get(count));
        }
    }

    public static <T extends IO<IOBridge, IOBridge>> List<T> getIOList(String key, IOBridge input) {
        int listSize = input.getInteger(key + "listSize");
        ArrayList list = new ArrayList(listSize);
        for (int count = 0; count < listSize; ++count) {
            Object obj = input.getIO(key + "IO" + count);
            list.add(obj);
        }
        return list;
    }

    public static <I, O> void setIOMap(String key, Map<? extends IO<I, O>, ? extends IO<I, O>> map, IOFactory<I, O> factory, O output) {
        IOBridge outputBridge = factory.createOutputBridge(output);
        outputBridge.setInteger(key + "mapSize", map.size());
        int count = 0;
        for (Map.Entry<IO<I, O>, IO<I, O>> entry : map.entrySet()) {
            IO<I, O> keyObj = entry.getKey();
            IO<I, O> valueObj = entry.getValue();
            IOCore.io().set(key + "IOkey" + count, output, factory, keyObj);
            IOCore.io().set(key + "IOvalue" + count, output, factory, valueObj);
            ++count;
        }
    }

    public static <I, O> Map<? extends IO<I, O>, ? extends IO<I, O>> getIOMap(String key, IOFactory<I, O> factory, I input) {
        IOBridge inputBridge = factory.createInputBridge(input);
        int size = inputBridge.getInteger(key + "mapSize");
        HashMap map = new HashMap(size);
        for (int count = 0; count < size; ++count) {
            Object keyObj = IOCore.io().get(key + "IOkey" + count, input, factory, new IConstructor[0]);
            Object valueObj = IOCore.io().get(key + "IOvalue" + count, input, factory, new IConstructor[0]);
            map.put(keyObj, valueObj);
        }
        return map;
    }

    public static File[] getFoldersInDirectory(File directory) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File[] files = directory.listFiles();
        ArrayList<File> fileList = new ArrayList<File>();
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                fileList.add(file);
            }
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public static List<File> getFilesWithExtension(File directory, List<String> extensions) {
        ArrayList<File> files = new ArrayList<File>();
        for (String string : extensions) {
            File[] fileArray = IOUtil.getFilesWithExtension(directory, string);
            if (fileArray == null) continue;
            files.addAll(Arrays.asList(fileArray));
        }
        return files;
    }

    public static File[] getFilesWithExtension(File directory, String extension) {
        if (!directory.exists()) {
            directory.mkdirs();
        }
        return directory.listFiles(new FilenameFilterExtension(extension));
    }

    public static void writeUUID(UUID uuid, ByteBuf buf) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUUID(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static void setUUID(IPlayerProfile profile, NBTTagCompound tag, String name) {
        IOUtil.setUUID(profile.getUUID(), tag, name);
    }

    public static void setUUID(UUID uuid, NBTTagCompound tag, String key) {
        tag.func_74772_a(key + "most", uuid.getMostSignificantBits());
        tag.func_74772_a(key + "least", uuid.getLeastSignificantBits());
    }

    public static void setUUID(UUID uuid, IOBridge bridge, String key) {
        bridge.setLong(key + "most", uuid.getMostSignificantBits());
        bridge.setLong(key + "least", uuid.getLeastSignificantBits());
    }

    public static void setUUID(IPlayerProfile profile, IOBridge bridge, String name) {
        IOUtil.setUUID(profile.getUUID(), bridge, name);
    }

    public static UUID getUUID(NBTTagCompound tag, String name) {
        return new UUID(tag.func_74763_f(name + "most"), tag.func_74763_f(name + "least"));
    }

    public static UUID getUUID(IOBridge tag, String name) {
        return new UUID(tag.getLong(name + "most"), tag.getLong(name + "least"));
    }

    public static <T extends IO<ByteBuf, ByteBuf>> T readIO(ByteBuf buf) {
        if (buf.readBoolean()) {
            return IOCore.io().get("", buf, bufFactory, new IConstructor[0]);
        }
        return null;
    }

    public static void writeIO(ByteBuf buf, IO<ByteBuf, ByteBuf> io) {
        buf.writeBoolean(io != null);
        if (io != null) {
            IOCore.io().set("", buf, bufFactory, io);
        }
    }

    public static void writeIOList(List<? extends IO<IOBridge, IOBridge>> list, ByteBuf buf) {
        IOUtil.setCollection("", list, ByteBufBridge.factory, new ByteBufBridge(buf));
    }

    public static <T extends IO<IOBridge, IOBridge>> List<T> readIOList(ByteBuf buf) {
        return (List)IOUtil.getCollection("", ByteBufBridge.factory, new ByteBufBridge(buf));
    }

    private static class FilenameFilterExtension
    implements FilenameFilter {
        public final String extension;

        public FilenameFilterExtension(String extension) {
            this.extension = extension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith("." + this.extension);
        }
    }
}

