/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.io_manager.util;

import com.gildedgames.util.io_manager.constructor.DefaultConstructor;
import com.gildedgames.util.io_manager.constructor.IConstructor;
import com.gildedgames.util.io_manager.exceptions.ClassMissingInitException;
import com.gildedgames.util.io_manager.factory.ISerializeBehaviour;
import com.gildedgames.util.io_manager.overhead.IORegistry;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class IORegistryDefault
implements IORegistry {
    private static final DefaultConstructor defaultConstructor = new DefaultConstructor();
    private final Map<Integer, Class<?>> IDToClassMapping = new HashMap();
    private final Map<Class<?>, Integer> classToIDMapping = new HashMap();
    private final Map<Class<?>, ISerializeBehaviour<?>> serializeBehaviors = new HashMap();

    @Override
    public void registerClass(Class<?> classToSerialize, int classID) {
        this.IDToClassMapping.put(classID, classToSerialize);
        this.classToIDMapping.put(classToSerialize, classID);
    }

    @Override
    public void registerBehavior(Class<?> classToSerialize, ISerializeBehaviour<?> serializeBehaviour) {
        this.serializeBehaviors.put(classToSerialize, serializeBehaviour);
    }

    @Override
    public <T> T create(Class<T> registeredClass, IConstructor ... classConstructors) {
        if (registeredClass == null) {
            return null;
        }
        Object instance = null;
        IConstructor constructor = defaultConstructor;
        for (IConstructor specialConstructor : classConstructors) {
            if (!specialConstructor.isApplicable(registeredClass)) continue;
            constructor = specialConstructor;
            break;
        }
        try {
            instance = constructor.construct(registeredClass);
            for (Class clazz : this.serializeBehaviors.keySet()) {
                if (!clazz.isInstance(instance)) continue;
                ISerializeBehaviour<?> behaviour = this.serializeBehaviors.get(clazz);
                behaviour.postCreate(instance);
            }
            return instance;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            throw new ClassMissingInitException(registeredClass);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return instance;
    }

    @Override
    public Object create(String registryID, int registeredClassID) {
        return this.create(registryID, registeredClassID, defaultConstructor);
    }

    @Override
    public Object create(String registryID, int registeredClassID, IConstructor ... classConstructors) {
        Class<?> clazz = this.getClass(registryID, registeredClassID);
        return this.create(clazz, classConstructors);
    }

    @Override
    public Class<?> getClass(String registryID, int registeredClassID) {
        return this.IDToClassMapping.get(registeredClassID);
    }

    @Override
    public int getID(Class<?> registeredClass) {
        if (!this.classToIDMapping.containsKey(registeredClass)) {
            throw new IllegalArgumentException("Object's class isn't registered! Class: " + registeredClass.getCanonicalName());
        }
        return this.classToIDMapping.get(registeredClass);
    }

    @Override
    public int getID(Object objectOfRegisteredClass) {
        return this.getID(objectOfRegisteredClass.getClass());
    }

    @Override
    public boolean isClassRegistered(Class<?> clazz) {
        return this.classToIDMapping.containsKey(clazz);
    }
}

