/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.util.core.gui.viewing;

import com.gildedgames.util.core.gui.viewing.MinecraftGuiWrapper;
import com.gildedgames.util.ui.UiCore;
import com.gildedgames.util.ui.UiServices;
import com.gildedgames.util.ui.common.GuiFrame;
import com.gildedgames.util.ui.common.GuiViewer;
import com.gildedgames.util.ui.data.TickInfo;
import com.gildedgames.util.ui.input.ButtonState;
import com.gildedgames.util.ui.input.InputProvider;
import com.gildedgames.util.ui.input.KeyboardInput;
import com.gildedgames.util.ui.input.KeyboardInputPool;
import com.gildedgames.util.ui.input.MouseButton;
import com.gildedgames.util.ui.input.MouseInput;
import com.gildedgames.util.ui.input.MouseInputPool;
import com.gildedgames.util.ui.input.MouseMotion;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class MinecraftGuiWrapperEvents
implements TickInfo {
    protected Minecraft mc = Minecraft.func_71410_x();
    protected int ticks;
    private double width;
    private double height;
    private double scaleFactor;
    private double touchValue;
    private double eventButton;
    private long lastMouseEvent;
    private boolean worldStarted;

    public void handleInput() {
        GuiViewer viewer;
        GuiFrame frame;
        if (Mouse.isCreated()) {
            for (UiServices.Overlay overlay : UiCore.locate().overlays()) {
                frame = overlay.getFrame();
                viewer = overlay.getViewer();
                this.handleMouseInput(frame, viewer);
            }
        }
        if (Keyboard.isCreated()) {
            for (UiServices.Overlay overlay : UiCore.locate().overlays()) {
                frame = overlay.getFrame();
                viewer = overlay.getViewer();
                this.handleKeyboardInput(frame, viewer);
            }
        }
    }

    public void handleMouseInput(GuiFrame frame, GuiViewer viewer) {
        double i = (double)Mouse.getEventX() * this.width / (double)this.mc.field_71443_c;
        double j = this.height - (double)Mouse.getEventY() * this.height / (double)this.mc.field_71440_d - 1.0;
        int button = Mouse.getEventButton();
        if (Mouse.getEventButtonState()) {
            if (this.mc.field_71474_y.field_85185_A) {
                double d = this.touchValue;
                this.touchValue = d + 1.0;
                if (d > 0.0) {
                    return;
                }
            }
            this.eventButton = button;
            this.lastMouseEvent = Minecraft.func_71386_F();
            MouseInputPool pool = new MouseInputPool(new MouseInput(MouseButton.fromIndex(button), ButtonState.PRESS), new MouseInput(MouseButton.fromIndex(button), ButtonState.PRESS));
            frame.onMouseInput(pool, viewer.getInputProvider());
        } else if (button != -1) {
            if (this.mc.field_71474_y.field_85185_A) {
                double d;
                this.touchValue -= 1.0;
                if (d > 0.0) {
                    return;
                }
            }
            this.eventButton = -1.0;
            MouseInputPool pool = new MouseInputPool(new MouseInput(MouseButton.fromIndex(button), ButtonState.RELEASE));
            frame.onMouseInput(pool, viewer.getInputProvider());
        } else if (this.eventButton != -1.0 && this.lastMouseEvent > 0L) {
            long l = Minecraft.func_71386_F() - this.lastMouseEvent;
            MouseInputPool pool = new MouseInputPool(new MouseInput(MouseButton.fromIndex(button), ButtonState.PRESS, MouseMotion.MOVING));
            frame.onMouseInput(pool, viewer.getInputProvider());
        }
        int scrollDifference = Mouse.getDWheel();
        if (scrollDifference != 0) {
            frame.onMouseScroll(scrollDifference, viewer.getInputProvider());
        }
    }

    public void handleKeyboardInput(GuiFrame frame, GuiViewer viewer) {
        if (Keyboard.getEventKeyState()) {
            KeyboardInputPool pool = new KeyboardInputPool(new KeyboardInput(Keyboard.getEventKey(), Keyboard.getEventCharacter(), ButtonState.PRESS));
            frame.onKeyboardInput(pool, viewer.getInputProvider());
        }
    }

    @SubscribeEvent
    public void tickStartClient(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++this.ticks;
            if (this.mc.field_71462_r instanceof MinecraftGuiWrapper) {
                MinecraftGuiWrapper viewer = (MinecraftGuiWrapper)this.mc.field_71462_r;
                viewer.tick(this);
            }
            for (UiServices.Overlay overlay : UiCore.locate().overlays()) {
                GuiFrame frame = overlay.getFrame();
                GuiViewer viewer = overlay.getViewer();
                UiServices.RenderOrder renderOrder = overlay.getRenderOrder();
                InputProvider input = viewer.getInputProvider();
                if (this.width != (double)input.getScreenWidth() || this.height != (double)input.getScreenHeight() || this.scaleFactor != (double)input.getScaleFactor()) {
                    viewer.getInputProvider().refreshResolution();
                    this.width = input.getScreenWidth();
                    this.height = input.getScreenHeight();
                    this.scaleFactor = input.getScaleFactor();
                    frame.onResolutionChange(input);
                }
                frame.tick(viewer.getTickInfo(), viewer.getInputProvider());
            }
            this.handleInput();
        }
    }

    private void renderOverlays(UiServices.RenderOrder desiredOrder) {
        if (!this.worldStarted) {
            this.worldStarted = true;
            UiCore.locate().createRegisteredOverlays();
        }
        for (UiServices.Overlay overlay : UiCore.locate().overlays()) {
            GuiFrame frame = overlay.getFrame();
            GuiViewer viewer = overlay.getViewer();
            UiServices.RenderOrder renderOrder = overlay.getRenderOrder();
            if (!renderOrder.equals((Object)desiredOrder)) continue;
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
            frame.draw(viewer.getGraphics(), viewer.getInputProvider());
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui instanceof GuiMainMenu) {
            this.worldStarted = false;
            UiCore.locate().destroyRegisteredOverlays();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            this.renderOverlays(UiServices.RenderOrder.PRE);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void renderGameOverlayPost(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            this.renderOverlays(UiServices.RenderOrder.POST);
        }
    }

    @Override
    public int getTotalTicks() {
        return this.ticks;
    }
}

