/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.util;

import java.util.UUID;
import main.ironbackpacks.util.Logger;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class NBTHelper {
    public static boolean hasUUID(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "MostSigUUID") && NBTHelper.hasTag(itemStack, "LeastSigUUID");
    }

    public static void setUUID(ItemStack itemStack) {
        NBTHelper.initNBTCompound(itemStack);
        if (!NBTHelper.hasUUID(itemStack)) {
            UUID itemUUID = UUID.randomUUID();
            NBTHelper.setLong(itemStack, "MostSigUUID", itemUUID.getMostSignificantBits());
            NBTHelper.setLong(itemStack, "LeastSigUUID", itemUUID.getLeastSignificantBits());
        }
    }

    public static UUID getUUID(ItemStack itemStack) {
        NBTHelper.initNBTCompound(itemStack);
        if (NBTHelper.hasUUID(itemStack)) {
            return new UUID(itemStack.func_77978_p().func_74763_f("MostSigUUID"), itemStack.func_77978_p().func_74763_f("LeastSigUUID"));
        }
        return null;
    }

    private static void setLong(ItemStack itemStack, String tag, Long value) {
        NBTHelper.initNBTCompound(itemStack);
        itemStack.field_77990_d.func_74772_a(tag, value.longValue());
    }

    private static boolean hasTag(ItemStack itemStack, String tag) {
        return itemStack != null && itemStack.func_77942_o() && itemStack.field_77990_d.func_74764_b(tag);
    }

    private static void initNBTCompound(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            Logger.info("Resetting NBT tag");
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }
}

