/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.util;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import main.ironbackpacks.IronBackpacks;
import main.ironbackpacks.entity.EntityBackpack;
import main.ironbackpacks.items.backpacks.IBackpack;
import main.ironbackpacks.items.backpacks.ItemBackpack;
import main.ironbackpacks.network.ClientPackMessage;
import main.ironbackpacks.network.NetworkingHandler;
import main.ironbackpacks.util.IronBackpacksConstants;
import main.ironbackpacks.util.NBTHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class IronBackpacksHelper {
    public static ItemStack getBackpack(EntityPlayer player) {
        ItemStack backpack = null;
        ItemStack proxyPack = IronBackpacks.proxy.getCurrBackpack(player);
        backpack = proxyPack != null ? proxyPack : (IronBackpacks.proxy.getEquippedBackpack(player) != null ? IronBackpacks.proxy.getEquippedBackpack(player) : IronBackpacksHelper.getBackpackFromPlayersInventory(player));
        if (!player.field_70170_p.field_72995_K && backpack != null) {
            NBTHelper.setUUID(backpack);
        }
        return backpack;
    }

    public static ItemStack getBackpackFromPlayersInventory(EntityPlayer player) {
        ItemStack backpack = null;
        if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IBackpack) {
            backpack = player.func_70694_bm();
        } else {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof IBackpack)) continue;
                backpack = player.field_71071_by.func_70301_a(i);
            }
        }
        if (!player.field_70170_p.field_72995_K && backpack != null) {
            NBTHelper.setUUID(backpack);
        }
        return backpack;
    }

    public static ItemStack getEquippedBackpack(EntityPlayer player) {
        ItemStack backpack = null;
        ItemStack equippedPack = IronBackpacks.proxy.getEquippedBackpack(player);
        if (equippedPack != null) {
            backpack = equippedPack;
        }
        return backpack;
    }

    public static int[] getUpgradesAppliedFromNBT(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        ArrayList<Integer> upgradesArrayList = new ArrayList<Integer>();
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("Upgrades")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Upgrades", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                byte hasUpgrade = stackTag.func_74771_c("Upgrade");
                if (hasUpgrade == 0) continue;
                upgradesArrayList.add(Integer.valueOf(hasUpgrade));
            }
        }
        int[] ret = new int[upgradesArrayList.size()];
        int i = 0;
        for (Integer e : upgradesArrayList) {
            ret[i++] = e;
        }
        return ret;
    }

    public static int getUpgradePointsUsed(int[] upgrades) {
        int counter = 0;
        for (int upgrade : upgrades) {
            counter += IronBackpacksConstants.Upgrades.UPGRADE_POINTS[upgrade];
        }
        return counter;
    }

    public static int getTotalUpgradePointsFromNBT(ItemStack stack) {
        ItemBackpack backpack = (ItemBackpack)stack.func_77973_b();
        int upgradeCount = backpack.getUpgradeSlots();
        int extraPoints = IronBackpacksHelper.getAdditionalUpgradesUpgradeCount(stack);
        return upgradeCount + extraPoints;
    }

    public static int getAdditionalUpgradesUpgradeCount(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("AdditionalPoints")) {
            return nbtTagCompound.func_74759_k("AdditionalPoints")[0];
        }
        return 0;
    }

    public static int getAdditionalUpgradesTimesApplied(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("AdditionalPoints")) {
            return nbtTagCompound.func_74759_k("AdditionalPoints")[1];
        }
        return 0;
    }

    public static void equipBackpackFromKeybinding(EntityPlayer player) {
        ItemStack backpack = IronBackpacks.proxy.getEquippedBackpack(player);
        if (backpack != null) {
            boolean hasEmptySlot = false;
            for (int i = 0; i < player.field_71071_by.func_70302_i_() - 4; ++i) {
                if (player.field_71071_by.func_70301_a(i) != null) continue;
                hasEmptySlot = true;
            }
            if (hasEmptySlot) {
                player.field_71071_by.func_70441_a(backpack);
                IronBackpacks.proxy.updateEquippedBackpack(player, null);
                NetworkingHandler.network.sendTo((IMessage)new ClientPackMessage(null), (EntityPlayerMP)player);
                EntityBackpack.backpacksSpawnedMap.get(player).func_70106_y();
            }
        } else if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof IBackpack) {
            ItemStack backpackStack = player.func_70694_bm();
            NBTHelper.setUUID(backpackStack);
            IronBackpacks.proxy.updateEquippedBackpack(player, backpackStack);
            NetworkingHandler.network.sendTo((IMessage)new ClientPackMessage(backpackStack), (EntityPlayerMP)player);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            IronBackpacksHelper.spawnEntityBackpack(backpackStack, player);
        }
    }

    public static void spawnEntityBackpack(ItemStack backpack, EntityPlayer player) {
        EntityBackpack entityBackpack = new EntityBackpack(player.field_70170_p, player, ((ItemBackpack)backpack.func_77973_b()).getGuiId());
        entityBackpack.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v - 0.5, player.field_70125_A, player.field_70177_z);
        player.field_70170_p.func_72838_d((Entity)entityBackpack);
        EntityBackpack.backpacksSpawnedMap.put(player, entityBackpack);
    }

    public static boolean areItemStacksTheSame(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStack.func_77989_b((ItemStack)itemStack1, (ItemStack)itemStack2) && ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2);
    }

    public static boolean areItemsEqualForStacking(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1.func_77973_b().equals(itemStack2.func_77973_b()) && ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2) && itemStack1.func_77960_j() == itemStack2.func_77960_j();
    }

    public static boolean areItemsEqualAndStackable(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1.func_77985_e() && itemStack1.field_77994_a < itemStack1.func_77976_d() && IronBackpacksHelper.areItemsEqualForStacking(itemStack1, itemStack2);
    }
}

