/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.items.backpacks;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import main.ironbackpacks.IronBackpacks;
import main.ironbackpacks.container.backpack.ContainerBackpack;
import main.ironbackpacks.container.backpack.InventoryBackpack;
import main.ironbackpacks.handlers.ConfigHandler;
import main.ironbackpacks.items.backpacks.BackpackTypes;
import main.ironbackpacks.items.backpacks.IBackpack;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.util.IronBackpacksConstants;
import main.ironbackpacks.util.IronBackpacksHelper;
import main.ironbackpacks.util.NBTHelper;
import main.ironbackpacks.util.TextUtils;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import vazkii.botania.api.item.IBlockProvider;

@Optional.Interface(iface="vazkii.botania.api.item.IBlockProvider", modid="Botania")
public class ItemBackpack
extends Item
implements IBackpack,
IBlockProvider {
    private boolean openAltGui = true;
    private final int id;
    private final int size;
    private final int rowLength;
    private final int upgradePoints;
    private final String fancyName;

    public ItemBackpack(int id, int size, int rowLength, String texture, String fancyName, int upgradePoints) {
        this.func_77637_a(IronBackpacks.creativeTab);
        this.func_111206_d("ironbackpacks:" + texture);
        this.func_77655_b("ironbackpacks:" + fancyName);
        this.func_77625_d(1);
        this.setNoRepair();
        this.id = id;
        this.size = size;
        this.rowLength = rowLength;
        this.upgradePoints = upgradePoints;
        this.fancyName = fancyName;
    }

    public ItemBackpack(BackpackTypes type) {
        this(type.getId(), type.getSize(), type.getRowLength(), type.getTexture(), type.getName(), type.getUpgradePoints());
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return UpgradeMethods.hasDamageBarUpgrade(IronBackpacksHelper.getUpgradesAppliedFromNBT(stack));
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return this.getFullness(stack);
    }

    public boolean onItemUseFirst(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (!player.func_70093_af()) {
                return false;
            }
            int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(itemstack);
            boolean hasDepthUpgrade = UpgradeMethods.hasDepthUpgrade(upgrades);
            if (UpgradeMethods.hasQuickDepositUpgrade(upgrades)) {
                boolean bl = this.openAltGui = !UpgradeMethods.transferFromBackpackToInventory(player, itemstack, world, x, y, z, false);
                if (!hasDepthUpgrade) {
                    return !this.openAltGui;
                }
            } else if (UpgradeMethods.hasQuickDepositPreciseUpgrade(upgrades)) {
                boolean bl = this.openAltGui = !UpgradeMethods.transferFromBackpackToInventory(player, itemstack, world, x, y, z, true);
                if (!hasDepthUpgrade) {
                    return !this.openAltGui;
                }
            }
            if (hasDepthUpgrade) {
                ItemBackpack itemBackpack = (ItemBackpack)itemstack.func_77973_b();
                ContainerBackpack container = new ContainerBackpack(player, new InventoryBackpack(player, itemstack, BackpackTypes.values()[itemBackpack.getId()]), BackpackTypes.values()[itemBackpack.getId()]);
                for (int j = 0; j < container.getInventoryBackpack().func_70302_i_(); ++j) {
                    boolean openAltGuiDepth;
                    ItemStack nestedBackpack = container.getInventoryBackpack().func_70301_a(j);
                    if (nestedBackpack == null || nestedBackpack.func_77973_b() == null || !(nestedBackpack.func_77973_b() instanceof IBackpack)) continue;
                    int[] nestedUpgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(nestedBackpack);
                    if (UpgradeMethods.hasQuickDepositUpgrade(nestedUpgrades)) {
                        boolean bl = openAltGuiDepth = !UpgradeMethods.transferFromBackpackToInventory(player, nestedBackpack, world, x, y, z, false);
                        if (openAltGuiDepth) continue;
                        this.openAltGui = false;
                        continue;
                    }
                    if (!UpgradeMethods.hasQuickDepositPreciseUpgrade(nestedUpgrades)) continue;
                    boolean bl = openAltGuiDepth = !UpgradeMethods.transferFromBackpackToInventory(player, nestedBackpack, world, x, y, z, true);
                    if (openAltGuiDepth) continue;
                    this.openAltGui = false;
                }
                return !this.openAltGui;
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            IronBackpacks.proxy.updateCurrBackpack(player, itemStack);
            return itemStack;
        }
        NBTHelper.setUUID(itemStack);
        IronBackpacks.proxy.updateCurrBackpack(player, itemStack);
        if (!player.func_70093_af()) {
            player.openGui((Object)IronBackpacks.instance, this.getGuiId(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return itemStack;
        }
        if (this.openAltGui) {
            player.openGui((Object)IronBackpacks.instance, this.getGuiId() * -1 - 1, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        } else {
            this.openAltGui = true;
        }
        return itemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(stack);
        int totalUpgradePoints = IronBackpacksHelper.getTotalUpgradePointsFromNBT(stack);
        if (Keyboard.isKeyDown((int)42)) {
            int tierUpgradeCount;
            int upgradesUsed = 0;
            for (int upgrade : upgrades) {
                list.add(IronBackpacksConstants.Upgrades.LOCALIZED_NAMES[upgrade]);
                upgradesUsed += IronBackpacksConstants.Upgrades.UPGRADE_POINTS[upgrade];
            }
            if (upgrades.length > 0) {
                list.add("");
            }
            list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.used", upgradesUsed, totalUpgradePoints));
            list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.used.alt", UpgradeMethods.getAltGuiUpgradesUsed(upgrades), IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED));
            if (ConfigHandler.renamingUpgradeRequired) {
                list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.rename", IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED));
            }
            if ((tierUpgradeCount = ConfigHandler.additionalUpgradesLimit + this.getGuiId()) > 0) {
                int used = IronBackpacksHelper.getAdditionalUpgradesTimesApplied(stack) * ConfigHandler.additionalUpgradesIncrease;
                int have = tierUpgradeCount * ConfigHandler.additionalUpgradesIncrease;
                list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.used.tier", used, have));
            }
        } else if (totalUpgradePoints > 0) {
            list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.shift", new Object[0]));
        }
        if (advanced && NBTHelper.hasUUID(stack)) {
            list.add(TextUtils.localize("tooltip.ironbackpacks.uuid", NBTHelper.getUUID(stack)));
        }
    }

    @Override
    public double getFullness(ItemStack stack) {
        NBTTagCompound nbtTagCompound;
        int total = 0;
        int full = 0;
        if (stack != null && (nbtTagCompound = stack.func_77978_p()) != null && nbtTagCompound.func_74764_b("Items")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
            ItemStack[] inventory = new ItemStack[BackpackTypes.values()[this.getGuiId()].getSize()];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                byte slot = stackTag.func_74771_c("Slot");
                if (i < 0 || i > inventory.length) continue;
                inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
            }
            for (ItemStack tempStack : inventory) {
                if (tempStack != null) {
                    full += tempStack.field_77994_a;
                    total += tempStack.func_77976_d();
                    continue;
                }
                total += 64;
            }
        }
        return 1.0 - (double)full / (double)total;
    }

    @Override
    public int getUpgradeSlots() {
        return this.upgradePoints;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getRowLength() {
        return this.rowLength;
    }

    @Override
    public String getFancyName() {
        return this.fancyName;
    }

    @Override
    public int getGuiId() {
        return this.getId() - 1;
    }

    @Optional.Method(modid="Botania")
    public boolean provideBlock(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta, boolean doIt) {
        InventoryBackpack invBackpack = this.makeInv(IronBackpacks.proxy.getCurrBackpack(player), player);
        int amount = invBackpack.hasStackInInv(block, meta);
        if (amount > 0) {
            if (doIt) {
                invBackpack.removeOneItem(block, meta);
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="Botania")
    public int getBlockCount(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta) {
        InventoryBackpack invBackpack = this.makeInv(IronBackpacks.proxy.getCurrBackpack(player), player);
        int amount = invBackpack.hasStackInInv(block, meta);
        return amount;
    }

    private InventoryBackpack makeInv(ItemStack stack, EntityPlayer player) {
        BackpackTypes type = BackpackTypes.values()[this.getGuiId()];
        return new InventoryBackpack(player, stack, type);
    }
}

