/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import main.ironbackpacks.IronBackpacks;
import main.ironbackpacks.entity.EntityBackpack;
import main.ironbackpacks.handlers.ConfigHandler;
import main.ironbackpacks.network.ClientPackMessage;
import main.ironbackpacks.network.NetworkingHandler;
import main.ironbackpacks.util.IronBackpacksHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FMLEventHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderTickStart(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.func_71410_x().field_71441_e != null) {
            this.preRenderTick(Minecraft.func_71410_x(), (World)Minecraft.func_71410_x().field_71441_e, event.renderTickTime);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void preRenderTick(Minecraft mc, World world, float renderTick) {
        EntityBackpack.updateBackpacks(world);
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ItemStack backpack = IronBackpacks.proxy.getEquippedBackpack(event.player);
        if (!EntityBackpack.backpacksSpawnedMap.containsKey(event.player) && backpack != null) {
            NetworkingHandler.network.sendTo((IMessage)new ClientPackMessage(backpack), (EntityPlayerMP)event.player);
            IronBackpacks.proxy.updateEquippedBackpack(event.player, backpack);
            if (!ConfigHandler.disableRendering) {
                IronBackpacksHelper.spawnEntityBackpack(backpack, event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ItemStack backpack = IronBackpacks.proxy.getEquippedBackpack(event.player);
        if (!EntityBackpack.backpacksSpawnedMap.containsKey(event.player) && backpack != null) {
            NetworkingHandler.network.sendTo((IMessage)new ClientPackMessage(backpack), (EntityPlayerMP)event.player);
            IronBackpacks.proxy.updateEquippedBackpack(event.player, backpack);
            if (!ConfigHandler.disableRendering) {
                IronBackpacksHelper.spawnEntityBackpack(backpack, event.player);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerDimChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        ItemStack backpack = IronBackpacks.proxy.getEquippedBackpack(event.player);
        if (backpack != null) {
            if (EntityBackpack.backpacksSpawnedMap.containsKey(event.player) && EntityBackpack.backpacksSpawnedMap.get(event.player) != null) {
                EntityBackpack.backpacksSpawnedMap.get(event.player).func_70106_y();
            }
            NetworkingHandler.network.sendTo((IMessage)new ClientPackMessage(backpack), (EntityPlayerMP)event.player);
            IronBackpacks.proxy.updateEquippedBackpack(event.player, backpack);
            if (!ConfigHandler.disableRendering) {
                IronBackpacksHelper.spawnEntityBackpack(backpack, event.player);
            }
        }
    }
}

