/*
 * Decompiled with CFR 0.152.
 */
package main.ironbackpacks.crafting;

import main.ironbackpacks.handlers.ConfigHandler;
import main.ironbackpacks.items.backpacks.IBackpack;
import main.ironbackpacks.items.backpacks.ItemBackpack;
import main.ironbackpacks.items.upgrades.ItemUpgradeBase;
import main.ironbackpacks.items.upgrades.UpgradeMethods;
import main.ironbackpacks.util.IronBackpacksConstants;
import main.ironbackpacks.util.IronBackpacksHelper;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class BackpackCraftWithUpgradeRecipe
extends ShapelessOreRecipe {
    private final ItemStack recipeOutput;

    public BackpackCraftWithUpgradeRecipe(ItemStack recipeOutput, Object ... items) {
        super(recipeOutput, items);
        this.recipeOutput = recipeOutput;
    }

    public ItemStack func_77572_b(InventoryCrafting inventoryCrafting) {
        NBTTagCompound nbtTagCompound;
        ItemStack backpack = BackpackCraftWithUpgradeRecipe.getFirstBackpack(inventoryCrafting);
        ItemStack result = backpack.func_77946_l();
        int[] upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(result);
        int totalUpgradePoints = IronBackpacksHelper.getTotalUpgradePointsFromNBT(result);
        ItemStack upgradeToApply = BackpackCraftWithUpgradeRecipe.getFirstUpgrade(inventoryCrafting);
        ItemUpgradeBase upgradeToApplyBase = null;
        if (upgradeToApply != null) {
            upgradeToApplyBase = (ItemUpgradeBase)upgradeToApply.func_77973_b();
        }
        if ((nbtTagCompound = result.func_77978_p()) == null) {
            nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74782_a("Items", (NBTBase)new NBTTagList());
            result.func_77982_d(nbtTagCompound);
        }
        boolean upgradeFound = false;
        NBTTagList tagList = new NBTTagList();
        if (totalUpgradePoints != 0 && upgradeToApplyBase != null) {
            if (upgrades.length == 0) {
                if (upgradeToApplyBase.getId() == 10) {
                    upgradeFound = this.applyAdditional(nbtTagCompound, result);
                } else if (IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradeCost() <= totalUpgradePoints) {
                    if (IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.contains(upgradeToApplyBase.getId())) {
                        nbtTagCompound.func_74782_a("Added", (NBTBase)new NBTTagInt(IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.indexOf(upgradeToApplyBase.getId())));
                    }
                    NBTTagCompound nBTTagCompound = new NBTTagCompound();
                    nBTTagCompound.func_74774_a("Upgrade", (byte)upgradeToApplyBase.getId());
                    tagList.func_74742_a((NBTBase)nBTTagCompound);
                    upgradeFound = true;
                }
            } else {
                if (upgradeToApplyBase.getId() == 10) {
                    upgradeFound = this.applyAdditional(nbtTagCompound, result);
                }
                for (int upgrade : upgrades) {
                    if (!upgradeFound && this.shouldRemove(upgradeToApplyBase, upgrade)) {
                        upgradeFound = true;
                        if (!IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.contains(upgradeToApplyBase.getId())) continue;
                        nbtTagCompound.func_74782_a("Removed", (NBTBase)new NBTTagInt(IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.indexOf(upgradeToApplyBase.getId())));
                        continue;
                    }
                    NBTTagCompound tagCompound = new NBTTagCompound();
                    tagCompound.func_74774_a("Upgrade", (byte)upgrade);
                    tagList.func_74742_a((NBTBase)tagCompound);
                }
                if (!upgradeFound && upgradeToApplyBase.getId() != 10 && this.canApplyUpgrade(upgradeToApplyBase, upgrades, totalUpgradePoints)) {
                    if (IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.contains(upgradeToApplyBase.getId())) {
                        nbtTagCompound.func_74782_a("Added", (NBTBase)new NBTTagInt(IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.indexOf(upgradeToApplyBase.getId())));
                    }
                    NBTTagCompound nBTTagCompound = new NBTTagCompound();
                    nBTTagCompound.func_74774_a("Upgrade", (byte)upgradeToApplyBase.getId());
                    tagList.func_74742_a((NBTBase)nBTTagCompound);
                    upgradeFound = true;
                }
            }
        } else if (upgradeToApplyBase != null && upgradeToApplyBase.getId() == 10) {
            upgradeFound = this.applyAdditional(nbtTagCompound, result);
        }
        nbtTagCompound.func_74782_a("Upgrades", (NBTBase)tagList);
        if (upgradeFound) {
            return result;
        }
        return null;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    private static ItemStack getFirstBackpack(InventoryCrafting inventoryCrafting) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = inventoryCrafting.func_70463_b(j, i);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof IBackpack)) continue;
                return itemstack;
            }
        }
        return null;
    }

    private static ItemStack getFirstUpgrade(InventoryCrafting inventoryCrafting) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ItemStack itemstack = inventoryCrafting.func_70463_b(j, i);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof ItemUpgradeBase)) continue;
                return itemstack;
            }
        }
        return null;
    }

    private boolean canApplyUpgrade(ItemUpgradeBase upgradeToApplyBase, int[] upgrades, int totalUpgradePoints) {
        if (IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADE_IDS.contains(upgradeToApplyBase.getId())) {
            if (UpgradeMethods.getAltGuiUpgradesUsed(upgrades) + 1 <= IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED) {
                return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradeCost() <= totalUpgradePoints;
            }
            return false;
        }
        if (upgradeToApplyBase.getId() == 15 || upgradeToApplyBase.getId() == 2) {
            if (upgradeToApplyBase.getId() == 15) {
                for (int upgrade : upgrades) {
                    if (upgrade != 2) continue;
                    return false;
                }
                return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradeCost() <= totalUpgradePoints;
            }
            for (int upgrade : upgrades) {
                if (upgrade != 15) continue;
                return false;
            }
            return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradeCost() <= totalUpgradePoints;
        }
        if (upgradeToApplyBase.getId() == 18 || upgradeToApplyBase.getId() == 13) {
            if (upgradeToApplyBase.getId() == 18) {
                for (int upgrade : upgrades) {
                    if (upgrade != 13) continue;
                    return false;
                }
                return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradeCost() <= totalUpgradePoints;
            }
            for (int upgrade : upgrades) {
                if (upgrade != 18) continue;
                return false;
            }
            return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradeCost() <= totalUpgradePoints;
        }
        if (upgradeToApplyBase.getId() == 16) {
            for (int upgrade : upgrades) {
                if (upgrade != 2 && upgrade != 15) continue;
                return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradeCost() <= totalUpgradePoints;
            }
            return false;
        }
        return IronBackpacksHelper.getUpgradePointsUsed(upgrades) + upgradeToApplyBase.getUpgradeCost() <= totalUpgradePoints;
    }

    private boolean applyAdditional(NBTTagCompound nbtTagCompound, ItemStack backpack) {
        ItemBackpack backpackBase = (ItemBackpack)backpack.func_77973_b();
        if (backpackBase == null) {
            return false;
        }
        if (nbtTagCompound.func_74764_b("AdditionalPoints")) {
            int[] oldValuesArray = nbtTagCompound.func_74759_k("AdditionalPoints");
            if (oldValuesArray[1] < ConfigHandler.additionalUpgradesLimit + backpackBase.getGuiId()) {
                oldValuesArray[1] = oldValuesArray[1] + 1;
                nbtTagCompound.func_74782_a("AdditionalPoints", (NBTBase)new NBTTagIntArray(new int[]{ConfigHandler.additionalUpgradesIncrease + oldValuesArray[0], oldValuesArray[1]}));
                return true;
            }
        } else if (ConfigHandler.additionalUpgradesLimit + backpackBase.getGuiId() > 0) {
            nbtTagCompound.func_74782_a("AdditionalPoints", (NBTBase)new NBTTagIntArray(new int[]{ConfigHandler.additionalUpgradesIncrease, 1}));
            return true;
        }
        return false;
    }

    private boolean shouldRemove(ItemUpgradeBase upgradeToApplyBase, int currUpgrade) {
        return upgradeToApplyBase.getId() == currUpgrade;
    }
}

