/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.network;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import jds.bibliocraft.gui.GuiAtlasMap;
import jds.bibliocraft.gui.GuiAtlasWaypointTransfer;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ClientPacketHandler {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        FMLProxyPacket packet = event.packet;
        if (packet != null) {
            if (packet.channel().equals("BiblioAStand")) {
                this.handlePlayerArmorUpdate(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioDrillText")) {
                this.handPlayerDrillTextUpdate(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioAtlas")) {
                this.handPlayerAtlasUpdate(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioAtlasSWP")) {
                this.handleAtlasSwap(packet.payload(), (EntityPlayer)player);
            }
            if (packet.channel().equals("BiblioAtlasTGUI")) {
                this.handleAtlasTransferGUI(packet.payload(), (EntityPlayer)player);
            }
        }
    }

    private void handleAtlasTransferGUI(ByteBuf packet, EntityPlayer player) {
        int z;
        int y;
        ItemStack atlas = ByteBufUtils.readItemStack((ByteBuf)packet);
        int x = packet.readInt();
        TileEntityMapFrame tile = (TileEntityMapFrame)player.field_70170_p.func_147438_o(x, y = packet.readInt(), z = packet.readInt());
        if (tile != null) {
            this.openWaypointTransferGUI(player.field_70170_p, player, atlas, tile);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void openWaypointTransferGUI(World world, EntityPlayer player, ItemStack stack, TileEntityMapFrame tile) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAtlasWaypointTransfer(world, player, stack, tile));
    }

    private void handleAtlasSwap(ByteBuf packet, EntityPlayer player) {
        player.field_70125_A = 50.0f;
        ItemStack atlas = ByteBufUtils.readItemStack((ByteBuf)packet);
        this.openMapGUI(player, atlas);
    }

    @SideOnly(value=Side.CLIENT)
    public void openMapGUI(EntityPlayer player, ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAtlasMap(player.field_70170_p, player, stack));
    }

    private void handPlayerAtlasUpdate(ByteBuf packet, EntityPlayer player) {
        ItemStack atlas = ByteBufUtils.readItemStack((ByteBuf)packet);
        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, atlas);
    }

    private void handlePlayerArmorUpdate(ByteBuf packet, EntityPlayer player) {
        ItemStack armor = null;
        int armorslot = -1;
        armor = ByteBufUtils.readItemStack((ByteBuf)packet);
        armorslot = packet.readInt();
        if (armorslot != -1) {
            player.field_71071_by.field_70460_b[armorslot] = armor;
        }
    }

    private void handPlayerDrillTextUpdate(ByteBuf packet, EntityPlayer player) {
        String displayText = ByteBufUtils.readUTF8String((ByteBuf)packet);
        ItemStack playerhand = player.func_70694_bm();
        if (playerhand != null && playerhand.func_77973_b() instanceof ItemDrill) {
            ItemDrill drill = (ItemDrill)playerhand.func_77973_b();
            drill.updateFromPacket(displayText);
        }
    }
}

