/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.gui;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Random;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.gui.GuiBiblioTextField;
import jds.bibliocraft.gui.GuiButtonAddSubtract;
import jds.bibliocraft.gui.GuiButtonAtlasControls;
import jds.bibliocraft.items.ItemWaypointCompass;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiAtlasMap
extends GuiScreen {
    private static int guiWidth = 256;
    private static int guiHeight = 256;
    private ItemStack atlasStack;
    ScaledResolution scaledresolution;
    private GuiButtonAtlasControls bSelect;
    private GuiButtonAtlasControls bEdit;
    private GuiButtonAtlasControls bAdd;
    private GuiButtonAtlasControls bAddToCompass1;
    private GuiButtonAtlasControls bAddToCompass2;
    private GuiButtonAtlasControls bAddToCompass3;
    private GuiButtonAtlasControls bAddToCompass4;
    private GuiButtonAtlasControls bAddToCompass5;
    private GuiButtonAtlasControls bAddToCompass6;
    private GuiButtonAtlasControls bAtlasMode;
    private GuiButtonAtlasControls bInventoryMode;
    private GuiButtonAtlasControls bModeSelect;
    private GuiButtonAtlasControls bModeCopyTo;
    private GuiButtonAtlasControls bModeCopyFrom;
    private GuiButtonAtlasControls bModeCopyPinsTo;
    private GuiButtonAtlasControls bModeCopyPinsFrom;
    private ArrayList xPin;
    private ArrayList zPin;
    private ArrayList pinStrings;
    private ArrayList pinColors;
    private int mapXCenter;
    private int mapZCenter;
    private int mapScale;
    private int mouseMode = 1;
    private int compassMode = 1;
    private EntityPlayer player;
    private World world;
    private InventoryBasic inventory = null;
    private ItemStack currentMapStack = null;
    private boolean hasSelectedPin = false;
    private float selectedPinX = -1.0f;
    private float selectedPinY = -1.0f;
    private float selectedCompasX = -1.0f;
    private float selectedCompasY = -1.0f;
    private int clickedPin = -1;
    private int currentPin = -1;
    private boolean hoveringPin = false;
    private Random rando;
    private ArrayList compasses;
    private ItemStack[] compassStacks;
    private int[] compassSlots = new int[]{0, 0, 0, 0, 0, 0};
    private GuiBiblioTextField editPinName;
    private GuiButton editAccept;
    private GuiButton editDelete;
    private boolean editMenuToggle = false;
    private int editColor = 0;
    private GuiButtonAddSubtract editColorPos;
    private GuiButtonAddSubtract editColorNeg;
    private boolean swapGUI = false;
    private int animationTracker = 0;
    private int currentSelectedCompass = -1;

    public GuiAtlasMap(World worldy, EntityPlayer playa, ItemStack map) {
        this.world = worldy;
        this.atlasStack = map;
        this.player = playa;
        this.xPin = new ArrayList();
        this.zPin = new ArrayList();
        this.pinColors = new ArrayList();
        this.pinStrings = new ArrayList();
        this.compasses = new ArrayList();
        this.rando = new Random();
        NBTTagCompound tags = map.func_77978_p();
        if (tags != null) {
            ItemStack invStack;
            int i;
            tags.func_74768_a("lastGUImode", 1);
            this.atlasStack.func_77982_d(tags);
            if (tags.func_74764_b("selectedPinX")) {
                this.selectedPinX = tags.func_74760_g("selectedPinX");
                this.selectedPinY = tags.func_74760_g("selectedPinY");
            }
            int mapSlot = tags.func_74762_e("mapSlot");
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", true, 48);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack2 = ItemStack.func_77949_a((NBTTagCompound)tag);
                atlasInventory.func_70299_a((int)slot, invStack2);
            }
            this.inventory = atlasInventory;
            for (i = 0; i < 6; ++i) {
                ItemStack compTest = atlasInventory.func_70301_a(i);
                if (compTest == null || !(compTest.func_77973_b() instanceof ItemWaypointCompass)) continue;
                this.compasses.add(compTest);
                this.compassSlots[i] = 1;
            }
            this.compassStacks = new ItemStack[0];
            if (this.compasses.size() > 0) {
                this.compassStacks = new ItemStack[this.compasses.size()];
                for (i = 0; i < this.compasses.size(); ++i) {
                    this.compassStacks[i] = (ItemStack)this.compasses.get(i);
                }
            }
            if (tags.func_74764_b("savedCompass")) {
                boolean matchedCompass = false;
                this.currentSelectedCompass = -1;
                int savedX = tags.func_74762_e("compassX");
                int savedZ = tags.func_74762_e("compassZ");
                for (int i2 = 0; i2 < this.compassStacks.length; ++i2) {
                    NBTTagCompound compassTags;
                    ItemStack testCompass = this.compassStacks[i2];
                    if (testCompass == null || (compassTags = testCompass.func_77978_p()) == null || compassTags.func_74762_e("XCoord") != savedX || compassTags.func_74762_e("ZCoord") != savedZ) continue;
                    this.currentSelectedCompass = i2;
                }
            }
            if (mapSlot >= 0 && (invStack = atlasInventory.func_70301_a(mapSlot)) != null) {
                this.currentMapStack = invStack;
                if (tags.func_74764_b("maps")) {
                    NBTTagList mapTags = tags.func_150295_c("maps", 10);
                    for (int i3 = 0; i3 < mapTags.func_74745_c(); ++i3) {
                        NBTTagCompound newTags = mapTags.func_150305_b(i3);
                        if (!newTags.func_74764_b("mapName") || !newTags.func_74779_i("mapName").contentEquals("Map_" + invStack.func_77960_j())) continue;
                        this.mapXCenter = newTags.func_74762_e("xCenter");
                        this.mapZCenter = newTags.func_74762_e("zCenter");
                        this.mapScale = newTags.func_74762_e("mapScale") + 1;
                        if (!newTags.func_74764_b("xMapWaypoints") || !newTags.func_74764_b("yMapWaypoints") || !newTags.func_74764_b("MapWaypointNames") || !newTags.func_74764_b("MapWaypointColors")) break;
                        NBTTagList mapXPins = newTags.func_150295_c("xMapWaypoints", 5);
                        this.xPin.clear();
                        for (int n = 0; n < mapXPins.func_74745_c(); ++n) {
                            float xpindata = mapXPins.func_150308_e(n);
                            this.xPin.add(Float.valueOf(xpindata));
                        }
                        NBTTagList mapYPins = newTags.func_150295_c("yMapWaypoints", 5);
                        this.zPin.clear();
                        for (int n = 0; n < mapYPins.func_74745_c(); ++n) {
                            float ypindata = mapYPins.func_150308_e(n);
                            this.zPin.add(Float.valueOf(ypindata));
                        }
                        NBTTagList mapPinNames = newTags.func_150295_c("MapWaypointNames", 8);
                        this.pinStrings.clear();
                        for (int n = 0; n < mapPinNames.func_74745_c(); ++n) {
                            String name = mapPinNames.func_150307_f(n);
                            this.pinStrings.add(name);
                        }
                        NBTTagList mapPinColors = newTags.func_150295_c("MapWaypointColors", 5);
                        this.pinColors.clear();
                        for (int n = 0; n < mapPinColors.func_74745_c(); ++n) {
                            float color = mapPinColors.func_150308_e(n);
                            this.pinColors.add(Float.valueOf(color));
                        }
                        break;
                    }
                }
            }
        }
    }

    private void updateCompassInventory() {
        int m = 0;
        for (int n = 0; n < 6; ++n) {
            ItemStack invStack;
            if (this.compassSlots[n] != 1 || (invStack = this.inventory.func_70301_a(n)) == null || !(invStack.func_77973_b() instanceof ItemWaypointCompass) || m >= this.compassStacks.length) continue;
            this.inventory.func_70299_a(n, this.compassStacks[m]);
            ++m;
        }
        NBTTagCompound tags = this.atlasStack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
        }
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        tags.func_74782_a("Inventory", (NBTBase)itemList);
        this.atlasStack.func_77982_d(tags);
    }

    private void updateCompassCoords(boolean writeString, int compassNumber, float mapposx, float mapposz) {
        if (compassNumber < this.compassStacks.length) {
            NBTTagCompound tags = this.compassStacks[compassNumber].func_77978_p();
            if (tags == null) {
                tags = new NBTTagCompound();
                tags.func_74778_a("WaypointName", "");
            }
            if (tags != null) {
                int mapSize = 128 * (int)Math.pow(2.0, this.mapScale - 1);
                float fx = 0.0f;
                float fz = 0.0f;
                if (writeString) {
                    fx = ((Float)this.xPin.get(this.clickedPin)).floatValue();
                    fz = ((Float)this.zPin.get(this.clickedPin)).floatValue();
                } else {
                    fx = mapposx;
                    fz = mapposz;
                }
                int xpos = this.mapXCenter - mapSize / 2 + (int)(fx * (float)mapSize);
                int ypos = this.mapZCenter - mapSize / 2 + (int)(fz * (float)mapSize);
                tags.func_74768_a("XCoord", xpos);
                tags.func_74768_a("ZCoord", ypos);
                if (writeString) {
                    String txt = (String)this.pinStrings.get(this.clickedPin);
                    tags.func_74778_a("WaypointName", txt);
                }
                this.compassStacks[compassNumber].func_77982_d(tags);
                this.updateCompassInventory();
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int w = (this.field_146294_l - guiWidth) / 2;
        int h = (this.field_146295_m - guiHeight) / 2;
        double heighAdjust = 0.0898876404494382 * (double)(this.field_146295_m - 20);
        double widthAdjust = 0.5 * (-0.75 + (double)this.field_146294_l) - 0.375 * (double)this.field_146295_m;
        double scaler = 0.0058976 * (double)this.field_146297_k.field_71440_d;
        this.scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        int scale = this.scaledresolution.func_78325_e();
        if (scale == 3) {
            scaler += 0.08;
        }
        double scaledMapWidth = scaler * (128.0 * (1.0 / (double)scale));
        double widthAdjust2 = widthAdjust + scaledMapWidth;
        double heightAdjust2 = heighAdjust + scaledMapWidth;
        this.field_146292_n.clear();
        this.bSelect = new GuiButtonAtlasControls(1, (int)widthAdjust - 18, (int)heighAdjust + 10, 1);
        this.field_146292_n.add(this.bSelect);
        this.bEdit = new GuiButtonAtlasControls(2, (int)widthAdjust - 18, (int)heighAdjust + 30, 2);
        this.field_146292_n.add(this.bEdit);
        this.bAdd = new GuiButtonAtlasControls(3, (int)widthAdjust - 18, (int)heighAdjust + 50, 3);
        this.field_146292_n.add(this.bAdd);
        if (this.compassStacks.length > 0) {
            this.bAddToCompass1 = new GuiButtonAtlasControls(4, (int)widthAdjust - 18, (int)heighAdjust + 82, 4);
            this.field_146292_n.add(this.bAddToCompass1);
        }
        if (this.compassStacks.length > 1) {
            this.bAddToCompass2 = new GuiButtonAtlasControls(5, (int)widthAdjust - 18, (int)heighAdjust + 102, 4);
            this.field_146292_n.add(this.bAddToCompass2);
        }
        if (this.compassStacks.length > 2) {
            this.bAddToCompass3 = new GuiButtonAtlasControls(6, (int)widthAdjust - 18, (int)heighAdjust + 122, 4);
            this.field_146292_n.add(this.bAddToCompass3);
        }
        if (this.compassStacks.length > 3) {
            this.bAddToCompass4 = new GuiButtonAtlasControls(7, (int)widthAdjust - 18, (int)heighAdjust + 142, 4);
            this.field_146292_n.add(this.bAddToCompass4);
        }
        if (this.compassStacks.length > 4) {
            this.bAddToCompass5 = new GuiButtonAtlasControls(8, (int)widthAdjust - 18, (int)heighAdjust + 162, 4);
            this.field_146292_n.add(this.bAddToCompass5);
        }
        if (this.compassStacks.length > 5) {
            this.bAddToCompass6 = new GuiButtonAtlasControls(9, (int)widthAdjust - 18, (int)heighAdjust + 182, 4);
            this.field_146292_n.add(this.bAddToCompass6);
        }
        this.editColorNeg = new GuiButtonAddSubtract(20, this.field_146294_l / 2 - 20, this.field_146295_m / 2 + 4, 1, 1.0f);
        this.field_146292_n.add(this.editColorNeg);
        this.editColorPos = new GuiButtonAddSubtract(21, this.field_146294_l / 2 + 8, this.field_146295_m / 2 + 4, 0, 1.0f);
        this.field_146292_n.add(this.editColorPos);
        this.editAccept = new GuiButton(22, this.field_146294_l / 2 + 30, this.field_146295_m / 2 + 4, 40, 20, "Ok");
        this.field_146292_n.add(this.editAccept);
        this.editDelete = new GuiButton(23, this.field_146294_l / 2 - 70, this.field_146295_m / 2 + 4, 40, 20, "Delete");
        this.field_146292_n.add(this.editDelete);
        this.editPinName = new GuiBiblioTextField(this.field_146289_q, this.field_146294_l / 2 - 84, this.field_146295_m / 2 - 16, 222, 12);
        this.editPinName.setEnableBackgroundDrawing(false);
        this.editPinName.setTextColor(0x404040);
        this.editPinName.setMaxStringLength(42);
        heighAdjust = 0.0898876404494382 * (double)(this.field_146295_m - 600);
        widthAdjust = 0.5 * (-0.75 + (double)this.field_146294_l) - 0.375 * (double)this.field_146295_m;
        widthAdjust2 = widthAdjust + scaledMapWidth;
        heightAdjust2 = heighAdjust + scaledMapWidth;
        this.bAtlasMode = new GuiButtonAtlasControls(10, (int)widthAdjust2 + 1, (int)heightAdjust2, 5);
        this.field_146292_n.add(this.bAtlasMode);
        this.bAtlasMode.mouseMode = 10;
        this.bInventoryMode = new GuiButtonAtlasControls(11, (int)widthAdjust2 + 1, (int)heightAdjust2 + 20, 6);
        this.field_146292_n.add(this.bInventoryMode);
        this.bSelect.mouseMode = 1;
        this.bAtlasMode.field_146124_l = false;
    }

    protected void func_146284_a(GuiButton click) {
        if (click.field_146127_k >= 1 && click.field_146127_k <= 9) {
            this.bSelect.mouseMode = this.mouseMode = click.field_146127_k;
            this.bEdit.mouseMode = this.mouseMode;
            this.bAdd.mouseMode = this.mouseMode;
            if (click.field_146127_k >= 4 && click.field_146127_k <= 9) {
                this.setCompassHighlight(click.field_146127_k - 4);
            } else {
                this.selectedCompasX = -1.0f;
                this.selectedCompasY = -1.0f;
            }
            if (this.compassStacks.length > 0) {
                this.bAddToCompass1.mouseMode = this.mouseMode;
            }
            if (this.compassStacks.length > 1) {
                this.bAddToCompass2.mouseMode = this.mouseMode;
            }
            if (this.compassStacks.length > 2) {
                this.bAddToCompass3.mouseMode = this.mouseMode;
            }
            if (this.compassStacks.length > 3) {
                this.bAddToCompass4.mouseMode = this.mouseMode;
            }
            if (this.compassStacks.length > 4) {
                this.bAddToCompass5.mouseMode = this.mouseMode;
            }
            if (this.compassStacks.length > 5) {
                this.bAddToCompass6.mouseMode = this.mouseMode;
            }
        }
        switch (click.field_146127_k) {
            case 4: {
                if (this.mouseMode == 4) break;
                break;
            }
            case 11: {
                this.swapGUI = true;
                this.sendPacket();
                break;
            }
            case 20: {
                this.editColor = this.editColor > 0 ? --this.editColor : 15;
                this.editColorNeg.pressed = true;
                break;
            }
            case 21: {
                this.editColor = this.editColor < 15 ? ++this.editColor : 0;
                this.editColorPos.pressed = true;
                break;
            }
            case 22: {
                this.pinColors.set(this.currentPin, Float.valueOf(this.editColor));
                this.pinStrings.set(this.currentPin, this.editPinName.getText());
                this.updateNBTPinData();
                this.editMenuToggle = false;
                break;
            }
            case 23: {
                if (this.currentPin <= 0 || this.currentPin >= this.xPin.size()) break;
                this.xPin.remove(this.currentPin);
                this.zPin.remove(this.currentPin);
                this.pinColors.remove(this.currentPin);
                this.pinStrings.remove(this.currentPin);
                this.updateNBTPinData();
                this.editMenuToggle = false;
            }
        }
    }

    private void setCompassHighlight(int compNum) {
        if (compNum < this.compassStacks.length) {
            NBTTagCompound compTags = this.compassStacks[compNum].func_77978_p();
            if (compTags == null) {
                // empty if block
            }
            if (compTags != null) {
                this.selectedCompasX = compTags.func_74762_e("XCoord");
                this.selectedCompasY = compTags.func_74762_e("ZCoord");
                int invNum = -1;
                for (int i = 0; i < 6; ++i) {
                    NBTTagCompound tagTest;
                    ItemStack compTester = this.inventory.func_70301_a(i);
                    if (compTester == null || !(compTester.func_77973_b() instanceof ItemWaypointCompass) || (tagTest = compTester.func_77978_p()) == null || (float)tagTest.func_74762_e("XCoord") != this.selectedCompasX || (float)tagTest.func_74762_e("ZCoord") != this.selectedCompasY) continue;
                    invNum = i;
                }
                this.currentSelectedCompass = compNum;
                NBTTagCompound atlasTags = this.atlasStack.func_77978_p();
                if (atlasTags != null) {
                    atlasTags.func_74768_a("compassX", (int)this.selectedCompasX);
                    atlasTags.func_74768_a("compassZ", (int)this.selectedCompasY);
                    atlasTags.func_74768_a("savedCompass", invNum);
                    this.atlasStack.func_77982_d(atlasTags);
                }
            }
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (!this.swapGUI) {
            this.sendPacket();
        }
    }

    private void sendPacket() {
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.atlasStack);
        if (this.swapGUI) {
            BiblioCraft.ch_BiblioAtlasGUIswap.sendToServer(new FMLProxyPacket(buffer, "BiblioAtlasSWP"));
        } else {
            BiblioCraft.ch_BiblioClipboard.sendToServer(new FMLProxyPacket(buffer, "BiblioClipboard"));
        }
    }

    protected void func_73864_a(int mousex, int mousey, int click) {
        boolean iswithinmap;
        int w = (this.field_146294_l - guiWidth) / 2;
        int h = (this.field_146295_m - guiHeight) / 2;
        double heighAdjust = 0.0898876404494382 * (double)(this.field_146295_m - 20);
        double widthAdjust = 0.5 * (-0.75 + (double)this.field_146294_l) - 0.375 * (double)this.field_146295_m;
        double scaler = 0.0058976 * (double)this.field_146297_k.field_71440_d;
        this.scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        int scale = this.scaledresolution.func_78325_e();
        if (scale == 3) {
            scaler += 0.08;
        }
        double scaledMapWidth = scaler * (128.0 * (1.0 / (double)scale));
        double widthAdjust2 = widthAdjust + scaledMapWidth;
        double heightAdjust2 = heighAdjust + scaledMapWidth;
        float mapPosX = (float)(((double)mousex - widthAdjust) * (1.0 / scaledMapWidth));
        float mapPosZ = (float)(((double)mousey - heighAdjust) * (1.0 / scaledMapWidth));
        int mapSize = 128 * (int)Math.pow(2.0, this.mapScale - 1);
        int halfMapSize = mapSize / 2;
        boolean bl = iswithinmap = (double)mousex >= widthAdjust && (double)mousex <= widthAdjust2 && (double)mousey >= heighAdjust && (double)mousey <= heightAdjust2;
        if (iswithinmap && !this.editMenuToggle) {
            if (this.mouseMode == 1) {
                if (this.hoveringPin && this.currentPin != -1 && this.currentPin < this.xPin.size()) {
                    if (this.selectedPinX == (float)(this.mapXCenter - halfMapSize) + ((Float)this.xPin.get(this.currentPin)).floatValue() * (float)mapSize && this.selectedPinY == (float)(this.mapZCenter - halfMapSize) + ((Float)this.zPin.get(this.currentPin)).floatValue() * (float)mapSize) {
                        this.selectedPinX = -1.0f;
                        this.selectedPinY = -1.0f;
                    } else {
                        this.selectedPinX = (float)(this.mapXCenter - halfMapSize) + ((Float)this.xPin.get(this.currentPin)).floatValue() * (float)mapSize;
                        this.selectedPinY = (float)(this.mapZCenter - halfMapSize) + ((Float)this.zPin.get(this.currentPin)).floatValue() * (float)mapSize;
                    }
                    this.updateSelectedPinData();
                } else if (GuiAtlasMap.func_146271_m()) {
                    if (this.selectedPinX == (float)(this.mapXCenter - halfMapSize) + mapPosX * (float)mapSize && this.selectedPinY == (float)(this.mapZCenter - halfMapSize) + mapPosZ * (float)mapSize) {
                        this.selectedPinX = -1.0f;
                        this.selectedPinY = -1.0f;
                    } else {
                        this.selectedPinX = (float)(this.mapXCenter - halfMapSize) + mapPosX * (float)mapSize;
                        this.selectedPinY = (float)(this.mapZCenter - halfMapSize) + mapPosZ * (float)mapSize;
                    }
                    this.updateSelectedPinData();
                }
            }
            if (this.mouseMode == 2) {
                int randomColor = this.rando.nextInt(16);
                String newName = "Waypoint " + this.xPin.size();
                this.xPin.add(Float.valueOf(mapPosX));
                this.zPin.add(Float.valueOf(mapPosZ));
                this.pinColors.add(Float.valueOf(randomColor));
                this.pinStrings.add(newName);
                this.updateNBTPinData();
                if (!this.func_146272_n()) {
                    this.currentPin = this.xPin.size() - 1;
                    this.editColor = randomColor;
                    this.editPinName.setText(newName);
                    this.editMenuToggle = true;
                }
            }
            if (this.mouseMode == 3 && this.hoveringPin && this.currentPin != -1 && this.currentPin < this.xPin.size()) {
                if (GuiAtlasMap.func_146272_n()) {
                    this.xPin.remove(this.currentPin);
                    this.zPin.remove(this.currentPin);
                    this.pinColors.remove(this.currentPin);
                    this.pinStrings.remove(this.currentPin);
                    this.updateNBTPinData();
                } else {
                    float currColor = ((Float)this.pinColors.get(this.currentPin)).floatValue();
                    this.editColor = (int)currColor;
                    this.editPinName.setText((String)this.pinStrings.get(this.currentPin));
                    this.editMenuToggle = true;
                }
            }
            if (this.mouseMode >= 4 && this.mouseMode <= 9) {
                if (this.hoveringPin && this.currentPin != -1 && this.currentPin < this.xPin.size()) {
                    this.clickedPin = this.currentPin;
                    this.updateCompassCoords(true, this.mouseMode - 4, mapPosX, mapPosZ);
                    this.clickedPin = -1;
                    this.setCompassHighlight(this.mouseMode - 4);
                } else if (GuiAtlasMap.func_146271_m()) {
                    this.updateCompassCoords(false, this.mouseMode - 4, mapPosX, mapPosZ);
                    this.setCompassHighlight(this.mouseMode - 4);
                }
            }
        }
        super.func_73864_a(mousex, mousey, click);
        if (this.editMenuToggle) {
            this.editPinName.mouseClicked(mousex, mousey, click);
        }
    }

    private void updateSelectedPinData() {
        NBTTagCompound tags = this.atlasStack.func_77978_p();
        if (tags != null) {
            tags.func_74776_a("selectedPinX", this.selectedPinX);
            tags.func_74776_a("selectedPinY", this.selectedPinY);
            this.atlasStack.func_77982_d(tags);
        }
    }

    public void updateNBTPinData() {
        NBTTagCompound tags = this.atlasStack.func_77978_p();
        if (tags != null && this.currentMapStack != null && tags.func_74764_b("maps")) {
            NBTTagList mapTags = tags.func_150295_c("maps", 10);
            NBTTagList newTags = new NBTTagList();
            for (int i = 0; i < mapTags.func_74745_c(); ++i) {
                NBTTagCompound map = mapTags.func_150305_b(i);
                if (map.func_74764_b("mapName") && map.func_74779_i("mapName").contentEquals("Map_" + this.currentMapStack.func_77960_j())) {
                    NBTTagList mapXPins = new NBTTagList();
                    for (int n = 0; n < this.xPin.size(); ++n) {
                        mapXPins.func_74742_a((NBTBase)new NBTTagFloat(((Float)this.xPin.get(n)).floatValue()));
                    }
                    map.func_74782_a("xMapWaypoints", (NBTBase)mapXPins);
                    NBTTagList mapYPins = new NBTTagList();
                    for (int n = 0; n < this.zPin.size(); ++n) {
                        mapYPins.func_74742_a((NBTBase)new NBTTagFloat(((Float)this.zPin.get(n)).floatValue()));
                    }
                    map.func_74782_a("yMapWaypoints", (NBTBase)mapYPins);
                    NBTTagList mapPinNames = new NBTTagList();
                    for (int n = 0; n < this.pinStrings.size(); ++n) {
                        mapPinNames.func_74742_a((NBTBase)new NBTTagString((String)this.pinStrings.get(n)));
                    }
                    map.func_74782_a("MapWaypointNames", (NBTBase)mapPinNames);
                    NBTTagList mapPinColors = new NBTTagList();
                    for (int n = 0; n < this.pinColors.size(); ++n) {
                        mapPinColors.func_74742_a((NBTBase)new NBTTagFloat(((Float)this.pinColors.get(n)).floatValue()));
                    }
                    map.func_74782_a("MapWaypointColors", (NBTBase)mapPinColors);
                }
                newTags.func_74742_a((NBTBase)map);
            }
            tags.func_74782_a("maps", (NBTBase)newTags);
            this.atlasStack.func_77982_d(tags);
            this.player.field_71071_by.func_70299_a(this.player.field_71071_by.field_70461_c, this.atlasStack);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    public void func_146276_q_() {
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73869_a(char par1, int par2) {
        if (this.editMenuToggle) {
            if (!this.editPinName.textboxKeyTyped(par1, par2)) {
                super.func_73869_a(par1, par2);
            }
        } else {
            super.func_73869_a(par1, par2);
        }
    }

    public void func_73863_a(int mousex, int mousey, float f) {
        double pinHighlightY;
        double pinHighlightX;
        int w = (this.field_146294_l - guiWidth) / 2;
        int h = (this.field_146295_m - guiHeight) / 2;
        this.bSelect.func_146112_a(this.field_146297_k, 0, 0);
        this.bEdit.func_146112_a(this.field_146297_k, 0, 0);
        this.bAdd.func_146112_a(this.field_146297_k, 0, 0);
        if (this.compassStacks.length > 0) {
            this.bAddToCompass1.func_146112_a(this.field_146297_k, 0, 0);
        }
        if (this.compassStacks.length > 1) {
            this.bAddToCompass2.func_146112_a(this.field_146297_k, 0, 0);
        }
        if (this.compassStacks.length > 2) {
            this.bAddToCompass3.func_146112_a(this.field_146297_k, 0, 0);
        }
        if (this.compassStacks.length > 3) {
            this.bAddToCompass4.func_146112_a(this.field_146297_k, 0, 0);
        }
        if (this.compassStacks.length > 4) {
            this.bAddToCompass5.func_146112_a(this.field_146297_k, 0, 0);
        }
        if (this.compassStacks.length > 5) {
            this.bAddToCompass6.func_146112_a(this.field_146297_k, 0, 0);
        }
        this.bAtlasMode.func_146112_a(this.field_146297_k, 0, 0);
        this.bInventoryMode.func_146112_a(this.field_146297_k, 0, 0);
        this.scaledresolution = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        int scale = this.scaledresolution.func_78325_e();
        double heighAdjust = 0.0898876404494382 * (double)(this.field_146295_m - 20);
        double widthAdjust = 0.5 * (-0.75 + (double)this.field_146294_l) - 0.375 * (double)this.field_146295_m;
        double scaler = 0.0058976 * (double)this.field_146297_k.field_71440_d;
        if (scale == 3) {
            scaler += 0.08;
        }
        double antiscale = 1.0 / scaler;
        double scaledMapWidth = scaler * (128.0 * (1.0 / (double)scale));
        double widthAdjust2 = widthAdjust + scaledMapWidth;
        double heightAdjust2 = heighAdjust + scaledMapWidth;
        int mapSize = 128 * (int)Math.pow(2.0, this.mapScale - 1);
        int halfMapSize = mapSize / 2;
        if (this.editMenuToggle) {
            this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.ATLASGUIBUTTONS);
            this.func_73729_b(this.field_146294_l / 2 - 100, this.field_146295_m / 2 + -42, 0, 100, 200, 71);
            this.field_146297_k.func_110434_K().func_110577_a(this.getColorTexture(this.editColor));
            this.func_73729_b(this.field_146294_l / 2 - 6, this.field_146295_m / 2 + 3, 0, 0, 12, 13);
            this.editAccept.field_146124_l = true;
            this.editAccept.field_146125_m = true;
            this.editColorPos.field_146125_m = true;
            this.editColorPos.field_146124_l = true;
            this.editColorNeg.field_146125_m = true;
            this.editColorNeg.field_146124_l = true;
            this.editDelete.field_146124_l = true;
            this.editDelete.field_146125_m = true;
            this.editAccept.func_146112_a(this.field_146297_k, 0, 0);
            this.editColorPos.func_146112_a(this.field_146297_k, 0, 0);
            this.editColorNeg.func_146112_a(this.field_146297_k, 0, 0);
            this.editDelete.func_146112_a(this.field_146297_k, 0, 0);
            this.editPinName.drawTextBox();
            this.bInventoryMode.field_146124_l = false;
            this.bAdd.field_146124_l = false;
            this.bSelect.field_146124_l = false;
            this.bEdit.field_146124_l = false;
        } else {
            this.editAccept.field_146124_l = false;
            this.editAccept.field_146125_m = false;
            this.editDelete.field_146124_l = false;
            this.editDelete.field_146125_m = false;
            this.editColorPos.field_146125_m = false;
            this.editColorPos.field_146124_l = false;
            this.editColorNeg.field_146125_m = false;
            this.editColorNeg.field_146124_l = false;
            this.bInventoryMode.field_146124_l = true;
            this.bAdd.field_146124_l = true;
            this.bSelect.field_146124_l = true;
            this.bEdit.field_146124_l = true;
        }
        super.func_73863_a(mousex, mousey, f);
        this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.ATLASGUIBUTTONS);
        this.animationTracker = this.animationTracker >= 180 ? 0 : ++this.animationTracker;
        if (this.selectedPinX != -1.0f && this.selectedPinY != -1.0f) {
            pinHighlightX = (double)(this.selectedPinX - (float)this.mapXCenter) + (double)mapSize / 2.0;
            pinHighlightX /= (double)mapSize;
            pinHighlightX = pinHighlightX * scaledMapWidth + widthAdjust;
            pinHighlightY = (double)(this.selectedPinY - (float)this.mapZCenter) + (double)mapSize / 2.0;
            pinHighlightY /= (double)mapSize;
            pinHighlightY = pinHighlightY * scaledMapWidth + heighAdjust;
            if (this.selectedPinY >= (float)(this.mapZCenter + halfMapSize)) {
                pinHighlightY = scaledMapWidth + heighAdjust;
            } else if (this.selectedPinY <= (float)(this.mapZCenter - halfMapSize)) {
                pinHighlightY = heighAdjust;
            }
            if (this.selectedPinX >= (float)(this.mapXCenter + halfMapSize)) {
                pinHighlightX = scaledMapWidth + widthAdjust;
            } else if (this.selectedPinX <= (float)(this.mapXCenter - halfMapSize)) {
                pinHighlightX = widthAdjust;
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)pinHighlightX, (double)pinHighlightY, (double)0.0);
            GL11.glRotatef((float)(2 * this.animationTracker), (float)0.0f, (float)0.0f, (float)1.0f);
            this.func_73729_b(-4, -4, 10, 80, 8, 8);
            GL11.glPopMatrix();
        }
        if (this.selectedCompasX != -1.0f && this.selectedCompasY != -1.0f) {
            pinHighlightX = (double)(this.selectedCompasX - (float)this.mapXCenter) + (double)mapSize / 2.0;
            pinHighlightX /= (double)mapSize;
            pinHighlightX = pinHighlightX * scaledMapWidth + widthAdjust;
            pinHighlightY = (double)(this.selectedCompasY - (float)this.mapZCenter) + (double)mapSize / 2.0;
            pinHighlightY /= (double)mapSize;
            pinHighlightY = pinHighlightY * scaledMapWidth + heighAdjust;
            if (this.selectedCompasY >= (float)(this.mapZCenter + halfMapSize)) {
                pinHighlightY = scaledMapWidth + heighAdjust;
            } else if (this.selectedCompasY <= (float)(this.mapZCenter - halfMapSize)) {
                pinHighlightY = heighAdjust;
            }
            if (this.selectedCompasX >= (float)(this.mapXCenter + halfMapSize)) {
                pinHighlightX = scaledMapWidth + widthAdjust;
            } else if (this.selectedCompasX <= (float)(this.mapXCenter - halfMapSize)) {
                pinHighlightX = widthAdjust;
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)pinHighlightX, (double)pinHighlightY, (double)0.0);
            GL11.glRotatef((float)(2 * this.animationTracker), (float)0.0f, (float)0.0f, (float)1.0f);
            this.func_73729_b(-4, -4, 0, 80, 8, 8);
            GL11.glPopMatrix();
        }
        if (this.currentSelectedCompass < this.compassStacks.length && this.currentSelectedCompass >= 0) {
            this.func_73729_b((int)widthAdjust - 10, (int)heighAdjust + 82 + 20 * this.currentSelectedCompass, 20, 80, 10, 8);
        }
        if (!this.editMenuToggle) {
            this.currentPin = -1;
        }
        this.hoveringPin = false;
        if ((double)mousex >= widthAdjust && (double)mousex <= widthAdjust2 && (double)mousey >= heighAdjust && (double)mousey <= heightAdjust2 && !this.editMenuToggle) {
            switch (this.mouseMode) {
                case 2: {
                    this.func_73729_b(mousex - 4, mousey - 12, 20, 60, 18, 18);
                    break;
                }
                case 3: {
                    this.func_73729_b(mousex - 1, mousey - 15, 40, 60, 18, 18);
                }
            }
            if (this.mouseMode >= 4 && this.mouseMode <= 9) {
                this.func_73729_b(mousex, mousey, 60, 60, 18, 18);
            }
            boolean foundPin = false;
            float mapPosX = (float)(((double)mousex - widthAdjust) * (1.0 / scaledMapWidth));
            float mapPosZ = (float)(((double)mousey - heighAdjust) * (1.0 / scaledMapWidth));
            for (int n = 0; n < this.xPin.size(); ++n) {
                float pinx = ((Float)this.xPin.get(n)).floatValue();
                float pinz = ((Float)this.zPin.get(n)).floatValue();
                if (!(mapPosX - 0.01f <= pinx) || !(mapPosX + 0.01f >= pinx) || !(mapPosZ - 0.01f <= pinz) || !(mapPosZ + 0.01f >= pinz)) continue;
                foundPin = true;
                String mapName = (String)this.pinStrings.get(n);
                int xpos = this.mapXCenter - mapSize / 2 + (int)(pinx * (float)mapSize);
                int ypos = this.mapZCenter - mapSize / 2 + (int)(pinz * (float)mapSize);
                ArrayList<String> lst = new ArrayList<String>();
                lst.add(mapName);
                lst.add("X = " + xpos);
                lst.add("Z = " + ypos);
                this.drawHoveringText(lst, mousex, mousey + 15, this.field_146289_q);
                this.currentPin = n;
                this.hoveringPin = true;
            }
            if (!foundPin) {
                if (this.func_146271_m()) {
                    int xpos = this.mapXCenter - mapSize / 2 + (int)(mapPosX * (float)mapSize);
                    int ypos = this.mapZCenter - mapSize / 2 + (int)(mapPosZ * (float)mapSize);
                    ArrayList<String> lst = new ArrayList<String>();
                    lst.add("X = " + xpos);
                    lst.add("Z = " + ypos);
                    this.drawHoveringText(lst, mousex, mousey + 15, this.field_146289_q);
                }
            }
        }
        if (GuiAtlasMap.func_146271_m()) {
            if (mousex >= this.bSelect.field_146128_h && mousex < this.bSelect.field_146128_h + this.bSelect.field_146120_f && mousey >= this.bSelect.field_146129_i && mousey < this.bSelect.field_146129_i + this.bSelect.field_146121_g) {
                ArrayList<String> lst = new ArrayList<String>();
                lst.add(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gui.atlas.select.tt1"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.select.tt2"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.select.tt3"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.select.tt4"));
                lst.add(" ");
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.select.tt5"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.select.tt6"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.select.tt7"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.select.tt8"));
                this.drawHoveringText(lst, mousex, mousey + 15, this.field_146289_q);
            }
            if (mousex >= this.bAdd.field_146128_h && mousex < this.bAdd.field_146128_h + this.bAdd.field_146120_f && mousey >= this.bAdd.field_146129_i && mousey < this.bAdd.field_146129_i + this.bAdd.field_146121_g) {
                ArrayList<String> lst = new ArrayList<String>();
                lst.add(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gui.atlas.edit.tt1"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.edit.tt2"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.edit.tt3"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.edit.tt4"));
                lst.add(" ");
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.edit.tt5"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.edit.tt6"));
                this.drawHoveringText(lst, mousex, mousey + 15, this.field_146289_q);
            }
            if (mousex >= this.bEdit.field_146128_h && mousex < this.bEdit.field_146128_h + this.bEdit.field_146120_f && mousey >= this.bEdit.field_146129_i && mousey < this.bEdit.field_146129_i + this.bEdit.field_146121_g) {
                ArrayList<String> lst = new ArrayList<String>();
                lst.add(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gui.atlas.add.tt1"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.add.tt2"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.add.tt3"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.add.tt4"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.add.tt5"));
                lst.add(" ");
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.add.tt6"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.add.tt7"));
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.add.tt8"));
                this.drawHoveringText(lst, mousex, mousey + 15, this.field_146289_q);
            }
            if (mousex >= this.bInventoryMode.field_146128_h && mousex < this.bInventoryMode.field_146128_h + this.bInventoryMode.field_146120_f && mousey >= this.bInventoryMode.field_146129_i && mousey < this.bInventoryMode.field_146129_i + this.bInventoryMode.field_146121_g) {
                ArrayList<String> lst = new ArrayList<String>();
                lst.add(StatCollector.func_74838_a((String)"gui.atlas.switchtoinv"));
                this.drawHoveringText(lst, mousex, mousey + 15, this.field_146289_q);
            }
        }
        if (this.compassStacks.length > 0) {
            this.showCompassData(mousex, mousey, this.bAddToCompass1, 0);
        }
        if (this.compassStacks.length > 1) {
            this.showCompassData(mousex, mousey, this.bAddToCompass2, 1);
        }
        if (this.compassStacks.length > 2) {
            this.showCompassData(mousex, mousey, this.bAddToCompass3, 2);
        }
        if (this.compassStacks.length > 3) {
            this.showCompassData(mousex, mousey, this.bAddToCompass4, 3);
        }
        if (this.compassStacks.length > 4) {
            this.showCompassData(mousex, mousey, this.bAddToCompass5, 4);
        }
        if (this.compassStacks.length > 5) {
            this.showCompassData(mousex, mousey, this.bAddToCompass6, 5);
        }
    }

    private boolean isPositionOnCurrentMap(int mapSize, int mapCenterX, int mapCenterZ) {
        return false;
    }

    private void showCompassData(int mousex, int mousey, GuiButtonAtlasControls control, int stacknum) {
        if (this.editMenuToggle) {
            control.field_146124_l = false;
        } else {
            NBTTagCompound cTags;
            control.field_146124_l = true;
            if (mousex >= control.field_146128_h && mousex < control.field_146128_h + control.field_146120_f && mousey >= control.field_146129_i && mousey < control.field_146129_i + control.field_146121_g && (cTags = this.compassStacks[stacknum].func_77978_p()) != null) {
                ArrayList<String> lst = new ArrayList<String>();
                lst.add("" + cTags.func_74779_i("WaypointName"));
                lst.add("X = " + cTags.func_74762_e("XCoord"));
                lst.add("Z = " + cTags.func_74762_e("ZCoord"));
                this.drawHoveringText(lst, mousex, mousey + 15, this.field_146289_q);
            }
        }
    }

    public void drawTexturedRect(double xstart, double ystart, int xoffset, int yoffset, int xRectSize, int yRectSize) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(xstart + 0.0, ystart + (double)yRectSize, (double)this.field_73735_i, (double)((float)(xoffset + 0) * f), (double)((float)(yoffset + yRectSize) * f1));
        tessellator.func_78374_a(xstart + (double)xRectSize, ystart + (double)yRectSize, (double)this.field_73735_i, (double)((float)(xoffset + xRectSize) * f), (double)((float)(yoffset + yRectSize) * f1));
        tessellator.func_78374_a(xstart + (double)xRectSize, ystart + 0.0, (double)this.field_73735_i, (double)((float)(xoffset + xRectSize) * f), (double)((float)(yoffset + 0) * f1));
        tessellator.func_78374_a(xstart + 0.0, ystart + 0.0, (double)this.field_73735_i, (double)((float)(xoffset + 0) * f), (double)((float)(yoffset + 0) * f1));
        tessellator.func_78381_a();
    }

    public ResourceLocation getColorTexture(float color) {
        int colorint = (int)color;
        switch (colorint) {
            case 0: {
                return CommonProxy.BLACKWOOL;
            }
            case 1: {
                return CommonProxy.REDWOOL;
            }
            case 2: {
                return CommonProxy.GREENWOOL;
            }
            case 3: {
                return CommonProxy.LIMEWOOL;
            }
            case 4: {
                return CommonProxy.BROWNWOOL;
            }
            case 5: {
                return CommonProxy.BLUEWOOL;
            }
            case 6: {
                return CommonProxy.CYANWOOL;
            }
            case 7: {
                return CommonProxy.LBLUEWOOL;
            }
            case 8: {
                return CommonProxy.PURPLEWOOL;
            }
            case 9: {
                return CommonProxy.MAGENTAWOOL;
            }
            case 10: {
                return CommonProxy.PINKWOOL;
            }
            case 11: {
                return CommonProxy.YELOOWWOOL;
            }
            case 12: {
                return CommonProxy.ORANGEWOOL;
            }
            case 13: {
                return CommonProxy.GRAYWOOL;
            }
            case 14: {
                return CommonProxy.LGRAYWOOL;
            }
            case 15: {
                return CommonProxy.WHITEWOOL;
            }
        }
        return CommonProxy.REDWOOL;
    }
}

