/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import jds.bibliocraft.ClientProxy;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.rendering.EntityCandleFX;
import jds.bibliocraft.tileentities.TileEntityLantern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockLantern
extends BlockContainer {
    public int styleType = 0;
    public int glassColor = -1;

    public BlockLantern() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149672_a(Block.field_149777_j);
        this.func_149676_a(0.3f, 0.0f, 0.3f, 0.7f, 0.7f, 0.7f);
        this.func_149715_a(1.0f);
        this.func_149647_a(BlockLoader.biblioLightsTab);
    }

    public int getLightValue(IBlockAccess world, int i, int j, int k) {
        return 15;
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("gold_block");
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs tab, List subItems) {
        for (int x = 0; x <= 15; ++x) {
            subItems.add(new ItemStack((Block)this, 1, x));
        }
    }

    public int getBlockSide(int side, int meta) {
        int j1 = meta & 3;
        int b0 = 0;
        switch (side) {
            case 0: 
            case 1: {
                b0 = 0;
                break;
            }
            case 2: 
            case 3: {
                b0 = 8;
                break;
            }
            case 4: 
            case 5: {
                b0 = 4;
            }
        }
        return j1 | b0;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase player, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ++angle;
        angle %= 4;
        int angle2 = MathHelper.func_76128_c((double)((double)(player.field_70125_A * 3.0f / 180.0f) + 0.5)) & 3;
        ++angle2;
        angle2 %= 4;
        TileEntityLantern lanternTile = (TileEntityLantern)world.func_147438_o(i, j, k);
        lanternTile.setMetal(0);
        if (lanternTile != null) {
            lanternTile.setAngle(angle);
            if (angle2 == 0) {
                lanternTile.setStyle(this.styleType);
            } else if (angle2 == 1) {
                lanternTile.setStyle(this.styleType);
            } else {
                lanternTile.setStyle(this.styleType);
            }
        }
    }

    public int func_149660_a(World world, int i, int j, int k, int side, float hitX, float hitY, float hitZ, int meta) {
        this.styleType = side == 0 ? 2 : (side == 1 ? 0 : 1);
        return meta;
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.lanternRenderID;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int face, float hitx, float hity, float hitz) {
        if (!world.field_72995_K) {
            ItemStack playerhand = player.func_70694_bm();
            TileEntityLantern tile = (TileEntityLantern)world.func_147438_o(i, j, k);
            if (tile != null) {
                if (playerhand != null) {
                    int dyeColor;
                    if (playerhand.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150397_co)) {
                        tile.setGlassColor(playerhand.func_77960_j() + 1);
                        if (playerhand.field_77994_a > 1) {
                            --playerhand.field_77994_a;
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        }
                        return true;
                    }
                    if (playerhand.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150410_aZ)) {
                        tile.setGlassColor(0);
                        if (playerhand.field_77994_a > 1) {
                            --playerhand.field_77994_a;
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        }
                        return true;
                    }
                    if (playerhand.func_77973_b() instanceof ItemDye && (dyeColor = this.getLampColorFromMeta(playerhand.func_77960_j())) != world.func_72805_g(i, j, k)) {
                        int angle = tile.getAngle();
                        int metal = tile.getMetal();
                        int style = tile.getStyle();
                        int glassColor = tile.getGlassColor();
                        world.func_72921_c(i, j, k, dyeColor, 3);
                        tile.setData(angle, style, metal, glassColor);
                        if (playerhand.field_77994_a > 1) {
                            --playerhand.field_77994_a;
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                        }
                        return true;
                    }
                }
                System.out.println(tile.getIsLightOff());
                tile.setIsLightOff(!tile.getIsLightOff());
            }
        }
        return false;
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int par6) {
        super.func_149749_a(world, i, j, k, par5, par6);
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int something) {
        try {
            return new TileEntityLantern();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int i, int j, int k, Random par5Random) {
        TileEntityLantern lamp;
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile != null && tile instanceof TileEntityLantern && !(lamp = (TileEntityLantern)tile).getIsLightOff()) {
            Minecraft mc = Minecraft.func_71410_x();
            EntityCandleFX candleFlame = new EntityCandleFX(world, (double)i + 0.5, (double)j + 0.3, (double)k + 0.5, 0.0, 0.001, 0.0);
            mc.field_71452_i.func_78873_a((EntityFX)candleFlame);
        }
    }

    private int getLampColorFromMeta(int meta) {
        switch (meta) {
            case 0: {
                return 3;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 12;
            }
            case 6: {
                return 9;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 14;
            }
            case 10: {
                return 7;
            }
            case 11: {
                return 6;
            }
            case 12: {
                return 10;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 5;
            }
            case 15: {
                return 0;
            }
        }
        return 0;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityLantern) {
            TileEntityLantern te = (TileEntityLantern)tile;
            int angle = te.getAngle();
            switch (axis) {
                case NORTH: {
                    te.setAngle(1);
                    break;
                }
                case EAST: {
                    te.setAngle(2);
                    break;
                }
                case SOUTH: {
                    te.setAngle(3);
                    break;
                }
                case WEST: {
                    te.setAngle(0);
                    break;
                }
                case DOWN: {
                    if (angle <= 0) {
                        te.setAngle(3);
                        break;
                    }
                    te.setAngle(angle - 1);
                    break;
                }
                case UP: {
                    if (angle >= 3) {
                        te.setAngle(0);
                        break;
                    }
                    te.setAngle(angle + 1);
                    break;
                }
                case UNKNOWN: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }
}

