/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import baubles.api.BaublesApi;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.SetFlyPKT;
import moze_intel.projecte.network.packets.StepHeightPKT;
import moze_intel.projecte.network.packets.SwingItemPKT;
import moze_intel.projecte.utils.ReflectionHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class PlayerHelper {
    public static boolean checkedPlaceBlock(EntityPlayerMP player, int x, int y, int z, Block toPlace, int toPlaceMeta) {
        if (!PlayerHelper.hasEditPermission(player, x, y, z)) {
            return false;
        }
        World world = player.field_70170_p;
        BlockSnapshot before = BlockSnapshot.getBlockSnapshot((World)world, (int)x, (int)y, (int)z);
        world.func_147449_b(x, y, z, toPlace);
        world.func_72921_c(x, y, z, toPlaceMeta, 3);
        BlockEvent.PlaceEvent evt = new BlockEvent.PlaceEvent(before, Blocks.field_150350_a, (EntityPlayer)player);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (evt.isCanceled()) {
            world.restoringBlockSnapshots = true;
            before.restore(true, false);
            world.restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }

    public static boolean checkedReplaceBlock(EntityPlayerMP player, int x, int y, int z, Block toPlace, int toPlaceMeta) {
        return PlayerHelper.hasBreakPermission(player, x, y, z) && PlayerHelper.checkedPlaceBlock(player, x, y, z, toPlace, toPlaceMeta);
    }

    public static ItemStack findFirstItem(EntityPlayer player, ItemPE consumeFrom) {
        for (ItemStack s : player.field_71071_by.field_70462_a) {
            if (s == null || s.func_77973_b() != consumeFrom) continue;
            return s;
        }
        return null;
    }

    public static IInventory getBaubles(EntityPlayer player) {
        if (!Loader.isModLoaded((String)"Baubles")) {
            return null;
        }
        return BaublesApi.getBaubles((EntityPlayer)player);
    }

    public static Vec3 getBlockLookingAt(EntityPlayer player, double maxDistance) {
        Pair<Vec3, Vec3> vecs = PlayerHelper.getLookVec(player, maxDistance);
        MovingObjectPosition mop = player.field_70170_p.func_72933_a((Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)mop.field_72310_e);
            return Vec3.func_72443_a((double)((double)mop.field_72311_b + (double)dir.offsetX * 1.1), (double)((double)mop.field_72312_c + (double)dir.offsetY * 1.1), (double)((double)mop.field_72309_d + (double)dir.offsetZ * 1.1));
        }
        return null;
    }

    public static Pair<Vec3, Vec3> getLookVec(EntityPlayer player, double maxDistance) {
        Vec3 look = player.func_70676_i(1.0f);
        Vec3 playerPos = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + (double)(player.func_70047_e() - player.getDefaultEyeHeight())), (double)player.field_70161_v);
        Vec3 src = playerPos.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3 dest = src.func_72441_c(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance);
        return ImmutablePair.of((Object)src, (Object)dest);
    }

    public static boolean hasBreakPermission(EntityPlayerMP player, int x, int y, int z) {
        return PlayerHelper.hasEditPermission(player, x, y, z) && !ForgeHooks.onBlockBreakEvent((World)player.field_70170_p, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z).isCanceled();
    }

    public static boolean hasEditPermission(EntityPlayerMP player, int x, int y, int z) {
        return player.func_82247_a(x, y, z, player.field_70170_p.func_72805_g(x, y, z), null) && !MinecraftServer.func_71276_C().func_96290_a(player.field_70170_p, x, y, z, (EntityPlayer)player);
    }

    public static void setPlayerFireImmunity(EntityPlayer player, boolean value) {
        ReflectionHelper.setEntityFireImmunity((Entity)player, value);
    }

    public static void setPlayerWalkSpeed(EntityPlayer player, float value) {
        ReflectionHelper.setPlayerCapabilityWalkspeed(player.field_71075_bZ, value);
    }

    public static void swingItem(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            PacketHandler.sendTo(new SwingItemPKT(), (EntityPlayerMP)player);
        }
    }

    public static void updateClientServerFlight(EntityPlayerMP player, boolean state) {
        PacketHandler.sendTo(new SetFlyPKT(state), player);
        player.field_71075_bZ.field_75101_c = state;
        if (!state) {
            player.field_71075_bZ.field_75100_b = false;
        }
    }

    public static void updateClientServerStepHeight(EntityPlayerMP player, float value) {
        player.field_70138_W = value;
        PacketHandler.sendTo(new StepHeightPKT(value), player);
    }
}

