/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.manual;

import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import moze_intel.projecte.gameObjs.gui.GUIManual;
import moze_intel.projecte.manual.ImagePage;
import moze_intel.projecte.manual.ItemPage;
import moze_intel.projecte.manual.PageCategory;
import moze_intel.projecte.manual.TextPage;
import moze_intel.projecte.utils.CollectionHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractPage {
    protected final PageCategory category;
    protected AbstractPage parent = null;
    protected List<AbstractPage> subPages = Lists.newArrayList();
    private boolean indexed = true;

    protected AbstractPage(PageCategory category) {
        this.category = category;
    }

    public boolean shouldAppearInIndex() {
        return this.indexed;
    }

    public AbstractPage setIndexed(boolean flag) {
        this.indexed = flag;
        return this;
    }

    public abstract String getBodyText();

    public abstract String getHeaderText();

    public void addSubPage(AbstractPage page) {
        if (this.parent != null) {
            throw new UnsupportedOperationException("Cannot nest pages deeper than 1 level!");
        }
        page.parent = this;
        this.subPages.add(page);
    }

    public static AbstractPage createItemPage(ItemStack stack, PageCategory category) {
        String body = StatCollector.func_74838_a((String)("pe.manual." + stack.func_77977_a().substring(5)));
        List<List<String>> parts = CollectionHelper.splitToLength(GUIManual.splitBody(body), 16);
        ItemPage ret = new ItemPage(stack.func_77946_l(), category, StringUtils.join((Iterable)parts.get(0), (String)""));
        for (int i = 1; i < parts.size(); ++i) {
            ret.addSubPage(new ItemPage(stack.func_77946_l(), category, StringUtils.join((Iterable)parts.get(i), (String)"")).setIndexed(false));
        }
        return ret;
    }

    public static AbstractPage createTextPages(String identifier, PageCategory category) {
        String body = StatCollector.func_74838_a((String)("pe.manual." + identifier));
        List<List<String>> parts = CollectionHelper.splitToLength(GUIManual.splitBody(body), 16);
        TextPage ret = new TextPage(identifier, category, StringUtils.join((Iterable)parts.get(0), (String)""));
        for (int i = 1; i < parts.size(); ++i) {
            ret.addSubPage(new TextPage(identifier, category, StringUtils.join((Iterable)parts.get(i), (String)"")).setIndexed(false));
        }
        return ret;
    }

    public static AbstractPage createImagePage(String header, ResourceLocation imageLocation, PageCategory category) {
        return new ImagePage(header, imageLocation, category);
    }
}

