/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.rings;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import java.util.List;
import moze_intel.projecte.api.item.IAlchBagItem;
import moze_intel.projecte.api.item.IAlchChestItem;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.gameObjs.entity.EntityLootBall;
import moze_intel.projecte.gameObjs.items.rings.RingToggle;
import moze_intel.projecte.gameObjs.tiles.AlchChestTile;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class BlackHoleBand
extends RingToggle
implements IAlchBagItem,
IAlchChestItem,
IBauble,
IPedestalItem {
    public BlackHoleBand() {
        super("black_hole");
        this.setNoRepair();
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            this.changeMode(player, stack);
        }
        return stack;
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (stack.func_77960_j() != 1 || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        AxisAlignedBB bBox = player.field_70121_D.func_72314_b(7.0, 7.0, 7.0);
        List itemList = world.func_72872_a(EntityItem.class, bBox);
        for (EntityItem item : itemList) {
            if (!ItemHelper.hasSpace(player.field_71071_by.field_70462_a, item.func_92059_d())) continue;
            WorldHelper.gravitateEntityTowards((Entity)item, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
        List ballList = world.func_72872_a(EntityLootBall.class, bBox);
        for (EntityLootBall ball : ballList) {
            WorldHelper.gravitateEntityTowards(ball, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        }
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.RING;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(World world, int x, int y, int z) {
        DMPedestalTile tile = (DMPedestalTile)world.func_147438_o(x, y, z);
        if (tile != null) {
            List list = world.func_72872_a(EntityItem.class, tile.getEffectBounds());
            for (EntityItem item : list) {
                WorldHelper.gravitateEntityTowards((Entity)item, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
                if (world.field_72995_K || !(item.func_70092_e((double)x + 0.5, (double)y + 0.5, (double)z + 0.5) < 1.21) || item.field_70128_L) continue;
                this.suckDumpItem(item, tile);
            }
        }
    }

    private void suckDumpItem(EntityItem item, DMPedestalTile tile) {
        List<TileEntity> list = WorldHelper.getAdjacentTileEntities(tile.func_145831_w(), tile);
        for (TileEntity tileEntity : list) {
            if (!(tileEntity instanceof IInventory)) continue;
            IInventory inv = (IInventory)tileEntity;
            ItemStack result = ItemHelper.pushStackInInv(inv, item.func_92059_d());
            if (result != null) {
                item.func_92058_a(result);
                continue;
            }
            item.func_70106_y();
            break;
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        return Lists.newArrayList((Object[])new String[]{EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.bhb.pedestal1"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.bhb.pedestal2")});
    }

    @Override
    public void updateInAlchChest(World world, int x, int y, int z, ItemStack stack) {
        AlchChestTile tile = (AlchChestTile)world.func_147438_o(x, y, z);
        if (stack.func_77960_j() == 1) {
            AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(tile.field_145851_c - 5), (double)(tile.field_145848_d - 5), (double)(tile.field_145849_e - 5), (double)(tile.field_145851_c + 5), (double)(tile.field_145848_d + 5), (double)(tile.field_145849_e + 5));
            double centeredX = (double)tile.field_145851_c + 0.5;
            double centeredY = (double)tile.field_145848_d + 0.5;
            double centeredZ = (double)tile.field_145849_e + 0.5;
            for (Object e : tile.func_145831_w().func_72872_a(EntityItem.class, aabb)) {
                WorldHelper.gravitateEntityTowards((Entity)e, centeredX, centeredY, centeredZ);
                if (e.field_70170_p.field_72995_K || e.field_70128_L || !(e.func_70092_e(centeredX, centeredY, centeredZ) < 1.21)) continue;
                ItemStack result = ItemHelper.pushStackInInv(tile, e.func_92059_d());
                if (result != null) {
                    e.func_92058_a(result);
                    continue;
                }
                e.func_70106_y();
            }
            for (Object e : tile.func_145831_w().func_72872_a(EntityLootBall.class, aabb)) {
                WorldHelper.gravitateEntityTowards((Entity)e, centeredX, centeredY, centeredZ);
                if (e.field_70170_p.field_72995_K || e.field_70128_L || !(e.func_70092_e(centeredX, centeredY, centeredZ) < 1.21)) continue;
                ItemHelper.pushLootBallInInv(tile, (EntityLootBall)((Object)e));
            }
        }
    }

    @Override
    public boolean updateInAlchBag(ItemStack[] inv, EntityPlayer player, ItemStack stack) {
        if (stack.func_77960_j() == 1) {
            for (Object e : player.field_70170_p.func_72872_a(EntityItem.class, player.field_70121_D.func_72314_b(5.0, 5.0, 5.0))) {
                WorldHelper.gravitateEntityTowards((Entity)e, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
            for (Object e : player.field_70170_p.func_72872_a(EntityLootBall.class, player.field_70121_D.func_72314_b(5.0, 5.0, 5.0))) {
                WorldHelper.gravitateEntityTowards((Entity)e, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
        }
        return false;
    }
}

