/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.google.common.collect.Lists;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.api.item.IPedestalItem;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.entity.EntityWaterProjectile;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.gameObjs.tiles.DMPedestalTile;
import moze_intel.projecte.utils.ClientKeyHelper;
import moze_intel.projecte.utils.FluidHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCauldron;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class EvertideAmulet
extends ItemPE
implements IProjectileShooter,
IBauble,
IPedestalItem,
IFluidContainerItem {
    public EvertideAmulet() {
        this.func_77655_b("evertide_amulet");
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77642_a(this);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int sideHit, float f1, float f2, float f3) {
        if (!world.field_72995_K && PlayerHelper.hasEditPermission((EntityPlayerMP)player, x, y, z)) {
            IFluidHandler tank;
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof IFluidHandler && FluidHelper.canFillTank(tank = (IFluidHandler)tile, FluidRegistry.WATER, sideHit)) {
                FluidHelper.fillTank(tank, FluidRegistry.WATER, sideHit, 1000);
                return true;
            }
            Block block = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            if (block == Blocks.field_150383_bp && meta < 3) {
                ((BlockCauldron)block).func_150024_a(world, x, y, z, meta + 1);
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int k;
        int j;
        int i;
        MovingObjectPosition mop;
        if (!world.field_72995_K && (mop = this.func_77621_a(world, player, false)) != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && !(world.func_147438_o(i = mop.field_72311_b, j = mop.field_72312_c, k = mop.field_72309_d) instanceof IFluidHandler)) {
            switch (mop.field_72310_e) {
                case 0: {
                    --j;
                    break;
                }
                case 1: {
                    ++j;
                    break;
                }
                case 2: {
                    --k;
                    break;
                }
                case 3: {
                    ++k;
                    break;
                }
                case 4: {
                    --i;
                    break;
                }
                case 5: {
                    ++i;
                    break;
                }
            }
            if (world.func_147437_c(i, j, k)) {
                world.func_72956_a((Entity)player, "projecte:item.pewatermagic", 1.0f, 1.0f);
                this.placeWater(world, player, i, j, k);
                PlayerHelper.swingItem(player);
            }
        }
        return stack;
    }

    private void placeWater(World world, EntityPlayer player, int i, int j, int k) {
        if (world.field_73011_w.field_76575_d) {
            world.func_72908_a((double)((float)i + 0.5f), (double)((float)j + 0.5f), (double)((float)k + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                world.func_72869_a("largesmoke", (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            PlayerHelper.checkedPlaceBlock((EntityPlayerMP)player, i, j, k, (Block)Blocks.field_150358_i, 0);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int invSlot, boolean par5) {
        int z;
        int y;
        if (invSlot > 8 || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        int x = (int)Math.floor(player.field_70165_t);
        if ((world.func_147439_a(x, (y = (int)(player.field_70163_u - player.func_70033_W())) - 1, z = (int)Math.floor(player.field_70161_v)) == Blocks.field_150355_j || world.func_147439_a(x, y - 1, z) == Blocks.field_150358_i) && world.func_147439_a(x, y, z) == Blocks.field_150350_a) {
            if (!player.func_70093_af()) {
                player.field_70181_x = 0.0;
                player.field_70143_R = 0.0f;
                player.field_70122_E = true;
            }
            if (!world.field_72995_K && player.field_71075_bZ.func_75094_b() < 0.25f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.25f);
            }
        } else if (!world.field_72995_K) {
            if (player.func_70090_H()) {
                player.func_70050_g(300);
            }
            if (player.field_71075_bZ.func_75094_b() != 0.1f) {
                PlayerHelper.setPlayerWalkSpeed(player, 0.1f);
            }
        }
    }

    @Override
    public boolean shootProjectile(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        if (!world.field_73011_w.field_76575_d) {
            world.func_72956_a((Entity)player, "projecte:item.pewatermagic", 1.0f, 1.0f);
            world.func_72838_d((Entity)new EntityWaterProjectile(world, player));
            return true;
        }
        return false;
    }

    public FluidStack getFluid(ItemStack container) {
        return new FluidStack(FluidRegistry.WATER, 1000);
    }

    public int getCapacity(ItemStack container) {
        return 1000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        return new FluidStack(FluidRegistry.WATER, 1000);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(this.getTexture("rings", "evertide_amulet"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        list.add(String.format(StatCollector.func_74838_a((String)"pe.evertide.tooltip1"), ClientKeyHelper.getKeyName(PEKeybind.FIRE_PROJECTILE)));
        list.add(StatCollector.func_74838_a((String)"pe.evertide.tooltip2"));
        list.add(StatCollector.func_74838_a((String)"pe.evertide.tooltip3"));
        list.add(StatCollector.func_74838_a((String)"pe.evertide.tooltip4"));
    }

    @Optional.Method(modid="Baubles")
    public BaubleType getBaubleType(ItemStack itemstack) {
        return BaubleType.AMULET;
    }

    @Optional.Method(modid="Baubles")
    public void onWornTick(ItemStack stack, EntityLivingBase player) {
        this.func_77663_a(stack, player.field_70170_p, (Entity)player, 0, false);
    }

    @Optional.Method(modid="Baubles")
    public void onEquipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public void onUnequipped(ItemStack itemstack, EntityLivingBase player) {
    }

    @Optional.Method(modid="Baubles")
    public boolean canEquip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Optional.Method(modid="Baubles")
    public boolean canUnequip(ItemStack itemstack, EntityLivingBase player) {
        return true;
    }

    @Override
    public void updateInPedestal(World world, int x, int y, int z) {
        if (!world.field_72995_K && ProjectEConfig.evertidePedCooldown != -1) {
            DMPedestalTile tile = (DMPedestalTile)world.func_147438_o(x, y, z);
            if (tile.getActivityCooldown() == 0) {
                int i = (300 + world.field_73012_v.nextInt(600)) * 20;
                world.func_72912_H().func_76080_g(i);
                world.func_72912_H().func_76090_f(i);
                world.func_72912_H().func_76084_b(true);
                tile.setActivityCooldown(ProjectEConfig.evertidePedCooldown);
            } else {
                tile.decrementActivityCooldown();
            }
        }
    }

    @Override
    public List<String> getPedestalDescription() {
        ArrayList list = Lists.newArrayList();
        if (ProjectEConfig.evertidePedCooldown != -1) {
            list.add(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"pe.evertide.pedestal1"));
            list.add(EnumChatFormatting.BLUE + String.format(StatCollector.func_74838_a((String)"pe.evertide.pedestal2"), MathUtils.tickToSecFormatted(ProjectEConfig.evertidePedCooldown)));
        }
        return list;
    }
}

