/*
 * Decompiled with CFR 0.152.
 */
package shadersmod.uniform;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.optifine.entity.model.anim.ConstantFloat;
import net.optifine.entity.model.anim.IExpression;
import net.optifine.entity.model.anim.IExpressionResolver;
import shadersmod.common.SMCLog;
import shadersmod.uniform.ShaderParameterBool;
import shadersmod.uniform.ShaderParameterFloat;

public class ShaderExpressionResolver
implements IExpressionResolver {
    private Map<String, IExpression> mapExpressions = new HashMap<String, IExpression>();

    public ShaderExpressionResolver(Map<String, IExpression> map) {
        this.registerExpressions();
        Set<String> keys = map.keySet();
        for (String name : keys) {
            IExpression expr = map.get(name);
            this.registerExpression(name, expr);
        }
    }

    private void registerExpressions() {
        ShaderParameterFloat[] spfs = ShaderParameterFloat.values();
        for (int i2 = 0; i2 < spfs.length; ++i2) {
            ShaderParameterFloat spf = spfs[i2];
            this.mapExpressions.put(spf.getName(), spf);
        }
        ShaderParameterBool[] spbs = ShaderParameterBool.values();
        for (int i3 = 0; i3 < spbs.length; ++i3) {
            ShaderParameterBool spb = spbs[i3];
            this.mapExpressions.put(spb.getName(), spb);
        }
        ahu[] biomeList = ahu.n();
        for (int i4 = 0; i4 < biomeList.length; ++i4) {
            ahu biome = biomeList[i4];
            if (biome == null) continue;
            String name = biome.af.trim();
            name = "BIOME_" + name.toUpperCase().replace(' ', '_');
            int id = biome.ay;
            ConstantFloat expr = new ConstantFloat(id);
            this.registerExpression(name, expr);
        }
    }

    public boolean registerExpression(String name, IExpression expr) {
        if (this.mapExpressions.containsKey(name)) {
            SMCLog.warning("Expression already defined: " + name);
            return false;
        }
        this.mapExpressions.put(name, expr);
        return true;
    }

    @Override
    public IExpression getExpression(String name) {
        return this.mapExpressions.get(name);
    }

    public boolean hasExpression(String name) {
        return this.mapExpressions.containsKey(name);
    }
}

