/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;

public class WrDisplayListAllocator {
    private List<WrDisplayListBlock> listBlocks = new ArrayList<WrDisplayListBlock>();
    private WrDisplayListBlock currentBlock = null;
    private int blockIndex = -1;

    public int allocateDisplayLists(int len) {
        if (len <= 0 || len > 16384) {
            throw new IllegalArgumentException("Invalid display list length: " + len);
        }
        if (this.currentBlock == null || !this.currentBlock.canAllocate(len)) {
            if (this.blockIndex + 1 < this.listBlocks.size()) {
                ++this.blockIndex;
                this.currentBlock = this.listBlocks.get(this.blockIndex);
            } else {
                this.currentBlock = new WrDisplayListBlock();
                this.blockIndex = this.listBlocks.size();
                this.listBlocks.add(this.currentBlock);
            }
            if (!this.currentBlock.canAllocate(len)) {
                throw new IllegalArgumentException("Can not allocate: " + len);
            }
        }
        return this.currentBlock.allocate(len);
    }

    public void resetAllocatedLists() {
        this.currentBlock = null;
        this.blockIndex = -1;
        for (int i2 = 0; i2 < this.listBlocks.size(); ++i2) {
            WrDisplayListBlock block = this.listBlocks.get(i2);
            block.reset();
        }
    }

    public void deleteDisplayLists() {
        for (int i2 = 0; i2 < this.listBlocks.size(); ++i2) {
            WrDisplayListBlock block = this.listBlocks.get(i2);
            block.deleteDisplayLists();
        }
        this.listBlocks.clear();
        this.currentBlock = null;
        this.blockIndex = -1;
    }
}

