/*
 * Decompiled with CFR 0.152.
 */
public class RandomMobsRule {
    private bqx baseResLoc = null;
    private int index;
    private int[] skins = null;
    private bqx[] resourceLocations = null;
    private int[] weights = null;
    private ahu[] biomes = null;
    private RangeListInt heights = null;
    private NbtTagValue nbtName = null;
    public int[] sumWeights = null;
    public int sumAllWeights = 1;
    private VillagerProfession[] professions = null;

    public RandomMobsRule(bqx baseResLoc, int index, int[] skins, int[] weights, ahu[] biomes, RangeListInt heights, NbtTagValue nbtName, VillagerProfession[] professions) {
        this.baseResLoc = baseResLoc;
        this.index = index;
        this.skins = skins;
        this.weights = weights;
        this.biomes = biomes;
        this.heights = heights;
        this.nbtName = nbtName;
        this.professions = professions;
    }

    public boolean isValid(String path) {
        if (this.skins == null || this.skins.length == 0) {
            Config.warn("Invalid skins for rule: " + this.index);
            return false;
        }
        if (this.resourceLocations != null) {
            return true;
        }
        this.resourceLocations = new bqx[this.skins.length];
        bqx locMcp = RandomMobs.getMcpatcherLocation(this.baseResLoc);
        if (locMcp == null) {
            Config.warn("Invalid path: " + this.baseResLoc.a());
            return false;
        }
        for (int i2 = 0; i2 < this.resourceLocations.length; ++i2) {
            int index = this.skins[i2];
            if (index <= 1) {
                this.resourceLocations[i2] = this.baseResLoc;
                continue;
            }
            bqx locNew = RandomMobs.getLocationIndexed(locMcp, index);
            if (locNew == null) {
                Config.warn("Invalid path: " + this.baseResLoc.a());
                return false;
            }
            if (!Config.hasResource(locNew)) {
                Config.warn("Texture not found: " + locNew.a());
                return false;
            }
            this.resourceLocations[i2] = locNew;
        }
        if (this.weights != null) {
            if (this.weights.length > this.resourceLocations.length) {
                Config.warn("More weights defined than skins, trimming weights: " + path);
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, weights2.length);
                this.weights = weights2;
            }
            if (this.weights.length < this.resourceLocations.length) {
                Config.warn("Less weights defined than skins, expanding weights: " + path);
                int[] weights2 = new int[this.resourceLocations.length];
                System.arraycopy(this.weights, 0, weights2, 0, this.weights.length);
                int avgWeight = MathUtils.getAverage(this.weights);
                for (int i3 = this.weights.length; i3 < weights2.length; ++i3) {
                    weights2[i3] = avgWeight;
                }
                this.weights = weights2;
            }
            this.sumWeights = new int[this.weights.length];
            int sum = 0;
            for (int i4 = 0; i4 < this.weights.length; ++i4) {
                if (this.weights[i4] < 0) {
                    Config.warn("Invalid weight: " + this.weights[i4]);
                    return false;
                }
                this.sumWeights[i4] = sum += this.weights[i4];
            }
            this.sumAllWeights = sum;
            if (this.sumAllWeights <= 0) {
                Config.warn("Invalid sum of all weights: " + sum);
                this.sumAllWeights = 1;
            }
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            Config.warn("Invalid professions or careers: " + path);
            return false;
        }
        return true;
    }

    public boolean matches(sw el) {
        if (this.biomes != null) {
            ahu spawnBiome = el.spawnBiome;
            boolean matchBiome = false;
            for (int i2 = 0; i2 < this.biomes.length; ++i2) {
                ahu biome = this.biomes[i2];
                if (biome != spawnBiome) continue;
                matchBiome = true;
                break;
            }
            if (!matchBiome) {
                return false;
            }
        }
        if (this.heights != null && el.spawnPosition != null) {
            return this.heights.isInRange(el.spawnPosition.getY());
        }
        if (this.nbtName != null) {
            String name;
            String string = name = el.bH() ? el.bG() : null;
            if (!this.nbtName.matchesValue(name)) {
                return false;
            }
        }
        if (this.professions != null && el instanceof yv) {
            yv entityVillager = (yv)el;
            int profInt = entityVillager.bZ();
            int careerInt = 0;
            if (profInt < 0 || careerInt < 0) {
                return false;
            }
            boolean matchProfession = false;
            for (int i3 = 0; i3 < this.professions.length; ++i3) {
                VillagerProfession prof = this.professions[i3];
                if (!prof.matches(profInt, careerInt)) continue;
                matchProfession = true;
                break;
            }
            if (!matchProfession) {
                return false;
            }
        }
        return true;
    }

    public bqx getTextureLocation(bqx loc, int randomId) {
        if (this.resourceLocations == null || this.resourceLocations.length == 0) {
            return loc;
        }
        int index = 0;
        if (this.weights == null) {
            index = randomId % this.resourceLocations.length;
        } else {
            int randWeight = randomId % this.sumAllWeights;
            for (int i2 = 0; i2 < this.sumWeights.length; ++i2) {
                if (this.sumWeights[i2] <= randWeight) continue;
                index = i2;
                break;
            }
        }
        return this.resourceLocations[index];
    }
}

