/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

public class NbtTagValue {
    private String[] parents = null;
    private String name = null;
    private boolean negative = false;
    private int type = 0;
    private String value = null;
    private int valueFormat = 0;
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PATTERN = 1;
    private static final int TYPE_IPATTERN = 2;
    private static final int TYPE_REGEX = 3;
    private static final int TYPE_IREGEX = 4;
    private static final String PREFIX_PATTERN = "pattern:";
    private static final String PREFIX_IPATTERN = "ipattern:";
    private static final String PREFIX_REGEX = "regex:";
    private static final String PREFIX_IREGEX = "iregex:";
    private static final int FORMAT_DEFAULT = 0;
    private static final int FORMAT_HEX_COLOR = 1;
    private static final String PREFIX_HEX_COLOR = "#";
    private static final Pattern PATTERN_HEX_COLOR = Pattern.compile("^#[0-9a-f]{6}+$");

    public NbtTagValue(String tag, String value) {
        String[] names = Config.tokenize(tag, ".");
        this.parents = Arrays.copyOfRange(names, 0, names.length - 1);
        this.name = names[names.length - 1];
        if (value.startsWith("!")) {
            this.negative = true;
            value = value.substring(1);
        }
        if (value.startsWith(PREFIX_PATTERN)) {
            this.type = 1;
            value = value.substring(PREFIX_PATTERN.length());
        } else if (value.startsWith(PREFIX_IPATTERN)) {
            this.type = 2;
            value = value.substring(PREFIX_IPATTERN.length()).toLowerCase();
        } else if (value.startsWith(PREFIX_REGEX)) {
            this.type = 3;
            value = value.substring(PREFIX_REGEX.length());
        } else if (value.startsWith(PREFIX_IREGEX)) {
            this.type = 4;
            value = value.substring(PREFIX_IREGEX.length()).toLowerCase();
        } else {
            this.type = 0;
        }
        value = StringEscapeUtils.unescapeJava((String)value);
        if (this.type == 0 && PATTERN_HEX_COLOR.matcher(value).matches()) {
            this.valueFormat = 1;
        }
        this.value = value;
    }

    public boolean matches(dh nbt) {
        if (this.negative) {
            return !this.matchesCompound(nbt);
        }
        return this.matchesCompound(nbt);
    }

    public boolean matchesCompound(dh nbt) {
        if (nbt == null) {
            return false;
        }
        dh tagBase = nbt;
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            String tag = this.parents[i2];
            if ((tagBase = NbtTagValue.getChildTag((dy)tagBase, tag)) != null) continue;
            return false;
        }
        if (this.name.equals("*")) {
            return this.matchesAnyChild((dy)tagBase);
        }
        if ((tagBase = NbtTagValue.getChildTag((dy)tagBase, this.name)) == null) {
            return false;
        }
        return this.matchesBase((dy)tagBase);
    }

    private boolean matchesAnyChild(dy tagBase) {
        if (tagBase instanceof dh) {
            dh tagCompound = (dh)tagBase;
            Set nbtKeySet = tagCompound.c();
            for (String key : nbtKeySet) {
                dy nbtBase = tagCompound.a(key);
                if (!this.matchesBase(nbtBase)) continue;
                return true;
            }
        }
        if (tagBase instanceof dq) {
            dq tagList = (dq)tagBase;
            int count = tagList.c();
            for (int i2 = 0; i2 < count; ++i2) {
                dh nbtBase = tagList.b(i2);
                if (!this.matchesBase((dy)nbtBase)) continue;
                return true;
            }
        }
        return false;
    }

    private static dy getChildTag(dy tagBase, String tag) {
        if (tagBase instanceof dh) {
            dh tagCompound = (dh)tagBase;
            return tagCompound.a(tag);
        }
        if (tagBase instanceof dq) {
            dq tagList = (dq)tagBase;
            if (tag.equals("count")) {
                return new dp(tagList.c());
            }
            int index = Config.parseInt(tag, -1);
            if (index < 0) {
                return null;
            }
            return tagList.b(index);
        }
        return null;
    }

    public boolean matchesBase(dy nbtBase) {
        if (nbtBase == null) {
            return false;
        }
        String nbtValue = NbtTagValue.getNbtString(nbtBase, this.valueFormat);
        return this.matchesValue(nbtValue);
    }

    public boolean matchesValue(String nbtValue) {
        if (nbtValue == null) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return nbtValue.equals(this.value);
            }
            case 1: {
                return this.matchesPattern(nbtValue, this.value);
            }
            case 2: {
                return this.matchesPattern(nbtValue.toLowerCase(), this.value);
            }
            case 3: {
                return this.matchesRegex(nbtValue, this.value);
            }
            case 4: {
                return this.matchesRegex(nbtValue.toLowerCase(), this.value);
            }
        }
        throw new IllegalArgumentException("Unknown NbtTagValue type: " + this.type);
    }

    private boolean matchesPattern(String str, String pattern) {
        return StrUtils.equalsMask(str, pattern, '*', '?');
    }

    private boolean matchesRegex(String str, String regex) {
        return str.matches(regex);
    }

    private static String getNbtString(dy nbtBase, int format) {
        if (nbtBase == null) {
            return null;
        }
        if (nbtBase instanceof dx) {
            dx nbtString = (dx)nbtBase;
            return nbtString.a_();
        }
        if (nbtBase instanceof dp) {
            dp i2 = (dp)nbtBase;
            if (format == 1) {
                return PREFIX_HEX_COLOR + StrUtils.fillLeft(Integer.toHexString(i2.d()), 6, '0');
            }
            return Integer.toString(i2.d());
        }
        if (nbtBase instanceof dg) {
            dg b2 = (dg)nbtBase;
            return Byte.toString(b2.f());
        }
        if (nbtBase instanceof dw) {
            dw s2 = (dw)nbtBase;
            return Short.toString(s2.e());
        }
        if (nbtBase instanceof dr) {
            dr l = (dr)nbtBase;
            return Long.toString(l.c());
        }
        if (nbtBase instanceof dm) {
            dm f2 = (dm)nbtBase;
            return Float.toString(f2.h());
        }
        if (nbtBase instanceof dk) {
            dk d2 = (dk)nbtBase;
            return Double.toString(d2.g());
        }
        return nbtBase.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            String parent = this.parents[i2];
            if (i2 > 0) {
                sb.append(".");
            }
            sb.append(parent);
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        sb.append(this.name);
        sb.append(" = ");
        sb.append(this.value);
        return sb.toString();
    }
}

