/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CustomItems {
    private static CustomItemProperties[][] itemProperties = null;
    private static Map mapPotionIds = null;

    public static void updateIcons(bpz textureMap) {
        itemProperties = null;
        if (!Config.isCustomItems()) {
            return;
        }
        bra[] rps = Config.getResourcePacks();
        for (int i2 = rps.length - 1; i2 >= 0; --i2) {
            bra rp = rps[i2];
            CustomItems.updateIcons(textureMap, rp);
        }
        CustomItems.updateIcons(textureMap, Config.getDefaultResourcePack());
    }

    public static void updateIcons(bpz textureMap, bra rp) {
        Object[] names = CustomItems.collectFiles(rp, "mcpatcher/cit/", ".properties");
        Map mapAutoProperties = CustomItems.makeAutoImageProperties(rp);
        if (mapAutoProperties.size() > 0) {
            Set keySetAuto = mapAutoProperties.keySet();
            Object[] keysAuto = keySetAuto.toArray(new String[keySetAuto.size()]);
            names = (String[])Config.addObjectsToArray(names, keysAuto);
        }
        Arrays.sort(names);
        List itemList = CustomItems.makePropertyList(itemProperties);
        for (int i2 = 0; i2 < names.length; ++i2) {
            Object name = names[i2];
            Config.dbg("CustomItems: " + (String)name);
            try {
                CustomItemProperties cip = null;
                if (mapAutoProperties.containsKey(name)) {
                    cip = (CustomItemProperties)mapAutoProperties.get(name);
                }
                if (cip == null) {
                    bqx locFile = new bqx((String)name);
                    InputStream in = rp.a(locFile);
                    if (in == null) {
                        Config.warn("CustomItems file not found: " + (String)name);
                        continue;
                    }
                    Properties props = new Properties();
                    props.load(in);
                    cip = new CustomItemProperties(props, (String)name);
                }
                if (!cip.isValid((String)name)) continue;
                cip.updateIcons(textureMap);
                CustomItems.addToItemList(cip, itemList);
                continue;
            }
            catch (FileNotFoundException e2) {
                Config.warn("CustomItems file not found: " + (String)name);
                continue;
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        itemProperties = CustomItems.propertyListToArray(itemList);
    }

    private static Map makeAutoImageProperties(bra rp) {
        HashMap map = new HashMap();
        map.putAll(CustomItems.makePotionImageProperties(rp, false));
        map.putAll(CustomItems.makePotionImageProperties(rp, true));
        return map;
    }

    private static Map makePotionImageProperties(bra rp, boolean splash) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        String prefix = "mcpatcher/cit/potion/";
        prefix = splash ? prefix + "splash/" : prefix + "normal/";
        String suffix = ".png";
        String[] names = CustomItems.collectFiles(rp, prefix, suffix);
        for (int i2 = 0; i2 < names.length; ++i2) {
            String path = names[i2];
            String name = path;
            if (!name.startsWith(prefix) || !name.endsWith(suffix)) {
                Config.warn("Invalid potion name: " + name);
                continue;
            }
            Properties props = CustomItems.makePotionProperties(name = name.substring(prefix.length(), name.length() - suffix.length()), splash, path);
            if (props == null) continue;
            String pathProp = path.substring(0, path.length() - suffix.length()) + ".properties";
            CustomItemProperties cip = new CustomItemProperties(props, pathProp);
            map.put(pathProp, cip);
        }
        return map;
    }

    private static Properties makePotionProperties(String name, boolean splash, String path) {
        if (name.equals("empty") && !splash) {
            int itemId = adb.b((adb)ade.bo);
            Properties props = new Properties();
            props.put("type", "item");
            props.put("items", "" + itemId);
            return props;
        }
        int potionItemId = adb.b((adb)ade.bn);
        int[] damages = (int[])CustomItems.getMapPotionIds().get(name);
        if (damages == null) {
            Config.warn("Potion not found for image: " + path);
            return null;
        }
        StringBuffer bufDamage = new StringBuffer();
        for (int i2 = 0; i2 < damages.length; ++i2) {
            int damage = damages[i2];
            if (splash) {
                damage |= 0x4000;
            }
            if (i2 > 0) {
                bufDamage.append(" ");
            }
            bufDamage.append(damage);
        }
        int damageMask = 16447;
        Properties props = new Properties();
        props.put("type", "item");
        props.put("items", "" + potionItemId);
        props.put("damage", "" + bufDamage.toString());
        props.put("damageMask", "" + damageMask);
        return props;
    }

    private static Map getMapPotionIds() {
        if (mapPotionIds == null) {
            mapPotionIds = new LinkedHashMap();
            mapPotionIds.put("water", new int[]{0});
            mapPotionIds.put("awkward", new int[]{16});
            mapPotionIds.put("thick", new int[]{32});
            mapPotionIds.put("potent", new int[]{48});
            mapPotionIds.put("regeneration", CustomItems.getPotionIds(1));
            mapPotionIds.put("moveSpeed", CustomItems.getPotionIds(2));
            mapPotionIds.put("fireResistance", CustomItems.getPotionIds(3));
            mapPotionIds.put("poison", CustomItems.getPotionIds(4));
            mapPotionIds.put("heal", CustomItems.getPotionIds(5));
            mapPotionIds.put("nightVision", CustomItems.getPotionIds(6));
            mapPotionIds.put("clear", CustomItems.getPotionIds(7));
            mapPotionIds.put("bungling", CustomItems.getPotionIds(23));
            mapPotionIds.put("charming", CustomItems.getPotionIds(39));
            mapPotionIds.put("rank", CustomItems.getPotionIds(55));
            mapPotionIds.put("weakness", CustomItems.getPotionIds(8));
            mapPotionIds.put("damageBoost", CustomItems.getPotionIds(9));
            mapPotionIds.put("moveSlowdown", CustomItems.getPotionIds(10));
            mapPotionIds.put("diffuse", CustomItems.getPotionIds(11));
            mapPotionIds.put("smooth", CustomItems.getPotionIds(27));
            mapPotionIds.put("refined", CustomItems.getPotionIds(43));
            mapPotionIds.put("acrid", CustomItems.getPotionIds(59));
            mapPotionIds.put("harm", CustomItems.getPotionIds(12));
            mapPotionIds.put("waterBreathing", CustomItems.getPotionIds(13));
            mapPotionIds.put("invisibility", CustomItems.getPotionIds(14));
            mapPotionIds.put("thin", CustomItems.getPotionIds(15));
            mapPotionIds.put("debonair", CustomItems.getPotionIds(31));
            mapPotionIds.put("sparkling", CustomItems.getPotionIds(47));
            mapPotionIds.put("stinky", CustomItems.getPotionIds(63));
        }
        return mapPotionIds;
    }

    private static int[] getPotionIds(int baseId) {
        return new int[]{baseId, baseId + 16, baseId + 32, baseId + 48};
    }

    private static int getPotionNameDamage(String name) {
        String fullName = "potion." + name;
        rv[] effectPotions = rv.a;
        for (int i2 = 0; i2 < effectPotions.length; ++i2) {
            String potionName;
            rv potion = effectPotions[i2];
            if (potion == null || !fullName.equals(potionName = potion.a())) continue;
            return potion.c();
        }
        return -1;
    }

    private static List makePropertyList(CustomItemProperties[][] propsArr) {
        ArrayList<ArrayList<CustomItemProperties>> list = new ArrayList<ArrayList<CustomItemProperties>>();
        if (propsArr != null) {
            for (int i2 = 0; i2 < propsArr.length; ++i2) {
                CustomItemProperties[] props = propsArr[i2];
                ArrayList<CustomItemProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<CustomItemProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static String[] collectFiles(bra rp, String prefix, String suffix) {
        if (rp instanceof bqp) {
            return CustomItems.collectFilesDefault(rp);
        }
        if (!(rp instanceof bqn)) {
            return new String[0];
        }
        bqn arp = (bqn)rp;
        File tpFile = ResourceUtils.getResourcePackFile(arp);
        if (tpFile == null) {
            return new String[0];
        }
        if (tpFile.isDirectory()) {
            return CustomItems.collectFilesFolder(tpFile, "", prefix, suffix);
        }
        if (tpFile.isFile()) {
            return CustomItems.collectFilesZIP(tpFile, prefix, suffix);
        }
        return new String[0];
    }

    private static String[] collectFilesDefault(bra rp) {
        return new String[0];
    }

    private static String[] collectFilesFolder(File tpFile, String basePath, String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        File[] files = tpFile.listFiles();
        if (files == null) {
            return new String[0];
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file = files[i2];
            if (file.isFile()) {
                String name = basePath + file.getName();
                if (!name.startsWith(prefixAssets) || !(name = name.substring(prefixAssets.length())).startsWith(prefix) || !name.endsWith(suffix)) continue;
                list.add(name);
                continue;
            }
            if (!file.isDirectory()) continue;
            String dirPath = basePath + file.getName() + "/";
            String[] names = CustomItems.collectFilesFolder(file, dirPath, prefix, suffix);
            for (int n = 0; n < names.length; ++n) {
                String name = names[n];
                list.add(name);
            }
        }
        String[] names = list.toArray(new String[list.size()]);
        return names;
    }

    private static String[] collectFilesZIP(File tpFile, String prefix, String suffix) {
        ArrayList<String> list = new ArrayList<String>();
        String prefixAssets = "assets/minecraft/";
        try {
            ZipFile zf2 = new ZipFile(tpFile);
            Enumeration<? extends ZipEntry> en = zf2.entries();
            while (en.hasMoreElements()) {
                ZipEntry ze = en.nextElement();
                String name = ze.getName();
                if (!name.startsWith(prefixAssets) || !(name = name.substring(prefixAssets.length())).startsWith(prefix) || !name.endsWith(suffix)) continue;
                list.add(name);
            }
            zf2.close();
            String[] names = list.toArray(new String[list.size()]);
            return names;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return new String[0];
        }
    }

    private static CustomItemProperties[][] propertyListToArray(List list) {
        CustomItemProperties[][] propArr = new CustomItemProperties[list.size()][];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List subList = (List)list.get(i2);
            if (subList == null) continue;
            CustomItemProperties[] subArr = subList.toArray(new CustomItemProperties[subList.size()]);
            Arrays.sort(subArr, new CustomItemsComparator());
            propArr[i2] = subArr;
        }
        return propArr;
    }

    private static void addToItemList(CustomItemProperties cp, List itemList) {
        if (cp.items == null) {
            return;
        }
        for (int i2 = 0; i2 < cp.items.length; ++i2) {
            int itemId = cp.items[i2];
            if (itemId <= 0) {
                Config.warn("Invalid item ID: " + itemId);
                continue;
            }
            CustomItems.addToList(cp, itemList, itemId);
        }
    }

    private static void addToList(CustomItemProperties cp, List list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        ArrayList<CustomItemProperties> subList = (ArrayList<CustomItemProperties>)list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomItemProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    public static rf getCustomItemTexture(add itemStack, rf icon) {
        CustomItemProperties[] cips;
        if (itemProperties == null) {
            return icon;
        }
        if (itemStack == null) {
            return icon;
        }
        adb item = itemStack.b();
        int itemId = adb.b((adb)item);
        if (itemId >= 0 && itemId < itemProperties.length && (cips = itemProperties[itemId]) != null) {
            for (int i2 = 0; i2 < cips.length; ++i2) {
                CustomItemProperties cip = cips[i2];
                rf iconNew = CustomItems.getCustomItemTexture(cip, itemStack, icon);
                if (iconNew == null) continue;
                return iconNew;
            }
        }
        return icon;
    }

    public static rf getCustomPotionTexture(adp item, int damage) {
        CustomItemProperties[] cips;
        if (itemProperties == null) {
            return null;
        }
        int itemId = adb.b((adb)item);
        if (itemId >= 0 && itemId < itemProperties.length && (cips = itemProperties[itemId]) != null) {
            for (int i2 = 0; i2 < cips.length; ++i2) {
                CustomItemProperties cip = cips[i2];
                rf iconNew = CustomItems.getCustomPotionTexture(cip, item, damage);
                if (iconNew == null) continue;
                return iconNew;
            }
        }
        return null;
    }

    private static rf getCustomPotionTexture(CustomItemProperties cip, adp item, int damage) {
        if (cip.damage != null) {
            if (cip.damageMask != 0) {
                damage &= cip.damageMask;
            }
            if (!cip.damage.isInRange(damage)) {
                return null;
            }
        }
        return cip.textureIcon;
    }

    private static rf getCustomItemTexture(CustomItemProperties cip, add itemStack, rf icon) {
        int i2;
        adb item = itemStack.b();
        if (cip.damage != null) {
            int damage = itemStack.k();
            if (cip.damageMask != 0) {
                damage &= cip.damageMask;
            }
            int damageMax = item.o();
            if (cip.damagePercent) {
                damage = (int)((double)(damage * 100) / (double)damageMax);
            }
            if (!cip.damage.isInRange(damage)) {
                return null;
            }
        }
        if (cip.stackSize != null && !cip.stackSize.isInRange(itemStack.b)) {
            return null;
        }
        if (cip.enchantmentIds != null) {
            int[] ids = CustomItems.getEnchantmentIds(itemStack);
            boolean idMatch = false;
            for (i2 = 0; i2 < ids.length; ++i2) {
                int id = ids[i2];
                if (!cip.enchantmentIds.isInRange(id)) continue;
                idMatch = true;
                break;
            }
            if (!idMatch) {
                return null;
            }
        }
        if (cip.enchantmentLevels != null) {
            int[] levels = CustomItems.getEnchantmentLevels(itemStack);
            boolean levelMatch = false;
            for (i2 = 0; i2 < levels.length; ++i2) {
                int level = levels[i2];
                if (!cip.enchantmentLevels.isInRange(level)) continue;
                levelMatch = true;
                break;
            }
            if (!levelMatch) {
                return null;
            }
        }
        if (cip.nbtTagValues != null) {
            // empty if block
        }
        return cip.textureIcon;
    }

    private static int[] getEnchantmentIds(add itemStack) {
        Map map = afv.a((add)itemStack);
        Set keySet = map.keySet();
        int[] ids = new int[keySet.size()];
        int index = 0;
        for (Integer id : keySet) {
            ids[index] = id;
            ++index;
        }
        return ids;
    }

    private static int[] getEnchantmentLevels(add itemStack) {
        Map map = afv.a((add)itemStack);
        Collection values = map.values();
        int[] levels = new int[values.size()];
        int index = 0;
        for (Integer level : values) {
            levels[index] = level;
            ++index;
        }
        return levels;
    }

    public static bqx getLocationItemGlint(add par2ItemStack, bqx resItemGlint) {
        return resItemGlint;
    }
}

