/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class CustomItemProperties {
    public String name = null;
    public String basePath = null;
    public int type = 1;
    public int[] items = null;
    public String texture = null;
    public Map mapTextures = null;
    public RangeListInt damage = null;
    public boolean damagePercent = false;
    public int damageMask = 0;
    public RangeListInt stackSize = null;
    public RangeListInt enchantmentIds = null;
    public RangeListInt enchantmentLevels = null;
    public NbtTagValue[] nbtTagValues = null;
    public int blend = 1;
    public int speed = 0;
    public int rotation = 0;
    public int layer = 0;
    public int duration = 1;
    public int weight = 0;
    public rf textureIcon = null;
    public Map mapTextureIcons = null;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_ITEM = 1;
    public static final int TYPE_ENCHANTMENT = 2;
    public static final int TYPE_ARMOR = 3;

    public CustomItemProperties(Properties props, String path) {
        this.name = CustomItemProperties.parseName(path);
        this.basePath = CustomItemProperties.parseBasePath(path);
        this.type = this.parseType(props.getProperty("type"));
        this.items = this.parseItems(props.getProperty("items"), props.getProperty("matchItems"));
        this.texture = CustomItemProperties.parseTexture(props.getProperty("texture"), props.getProperty("tile"), props.getProperty("source"), path, this.basePath);
        this.mapTextures = CustomItemProperties.parseTextures(props, this.basePath);
        String damageStr = props.getProperty("damage");
        if (damageStr != null) {
            this.damagePercent = damageStr.contains("%");
            damageStr.replace("%", "");
            this.damage = this.parseRangeListInt(damageStr);
            this.damageMask = this.parseInt(props.getProperty("damageMask"), 0);
        }
        this.stackSize = this.parseRangeListInt(props.getProperty("stackSize"));
        this.enchantmentIds = this.parseRangeListInt(props.getProperty("enchantmentIDs"));
        this.enchantmentLevels = this.parseRangeListInt(props.getProperty("enchantmentLevels"));
        this.nbtTagValues = this.parseNbtTagValues(props);
        this.blend = Blender.parseBlend(props.getProperty("blend"));
        this.speed = this.parseInt(props.getProperty("speed"), 0);
        this.rotation = this.parseInt(props.getProperty("rotation"), 0);
        this.layer = this.parseInt(props.getProperty("layer"), 0);
        this.weight = this.parseInt(props.getProperty("weight"), 0);
        this.duration = this.parseInt(props.getProperty("duration"), 1);
    }

    private static String parseName(String path) {
        int pos2;
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        return str;
    }

    private static String parseBasePath(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return "";
        }
        return path.substring(0, pos);
    }

    private int parseType(String str) {
        if (str == null) {
            return 1;
        }
        if (str.equals("item")) {
            return 1;
        }
        if (str.equals("enchantment")) {
            return 2;
        }
        if (str.equals("armor")) {
            return 3;
        }
        Config.warn("Unknown method: " + str);
        return 0;
    }

    private int[] parseItems(String str, String str2) {
        if (str == null) {
            str = str2;
        }
        if (str == null) {
            return null;
        }
        str = str.trim();
        TreeSet<Integer> setItemIds = new TreeSet<Integer>();
        String[] tokens = Config.tokenize(str, " ");
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            Object itemObj;
            String[] parts;
            String token = tokens[i2];
            int val = Config.parseInt(token, -1);
            if (val >= 0) {
                setItemIds.add(new Integer(val));
                continue;
            }
            if (token.contains("-") && (parts = Config.tokenize(token, "-")).length == 2) {
                int val1 = Config.parseInt(parts[0], -1);
                int val2 = Config.parseInt(parts[1], -1);
                if (val1 >= 0 && val2 >= 0) {
                    int min = Math.min(val1, val2);
                    int max = Math.max(val1, val2);
                    for (int x = min; x <= max; ++x) {
                        setItemIds.add(new Integer(x));
                    }
                    continue;
                }
            }
            if (!((itemObj = adb.e.a(token)) instanceof adb)) {
                Config.dbg("Item not found: " + token);
                continue;
            }
            adb item = (adb)itemObj;
            int id = adb.b((adb)item);
            if (id < 0) {
                Config.dbg("Item not found: " + token);
                continue;
            }
            setItemIds.add(new Integer(id));
        }
        Integer[] integers = setItemIds.toArray(new Integer[setItemIds.size()]);
        int[] ints = new int[integers.length];
        for (int i3 = 0; i3 < ints.length; ++i3) {
            ints[i3] = integers[i3];
        }
        return ints;
    }

    private static String parseTexture(String texStr, String texStr2, String texStr3, String path, String basePath) {
        int pos2;
        if (texStr == null) {
            texStr = texStr2;
        }
        if (texStr == null) {
            texStr = texStr3;
        }
        if (texStr != null) {
            String png = ".png";
            if (texStr.endsWith(png)) {
                texStr = texStr.substring(0, texStr.length() - png.length());
            }
            texStr = CustomItemProperties.fixTextureName(texStr, basePath);
            return texStr;
        }
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        str = CustomItemProperties.fixTextureName(str, basePath);
        return str;
    }

    private static Map parseTextures(Properties props, String basePath) {
        String prefix = "texture.";
        Map mapProps = CustomItemProperties.getMatchingProperties(props, prefix);
        if (mapProps.size() <= 0) {
            return null;
        }
        Set keySet = mapProps.keySet();
        LinkedHashMap<String, String> mapTex = new LinkedHashMap<String, String>();
        for (String key : keySet) {
            String val = (String)mapProps.get(key);
            val = CustomItemProperties.fixTextureName(val, basePath);
            if (key.startsWith(prefix)) {
                key = key.substring(prefix.length());
            }
            mapTex.put(key, val);
        }
        return mapTex;
    }

    private static String fixTextureName(String iconName, String basePath) {
        String pathBlocks;
        if (!((iconName = TextureUtils.fixResourcePath(iconName, basePath)).startsWith(basePath) || iconName.startsWith("textures/") || iconName.startsWith("mcpatcher/"))) {
            iconName = basePath + "/" + iconName;
        }
        if (iconName.endsWith(".png")) {
            iconName = iconName.substring(0, iconName.length() - 4);
        }
        if (iconName.startsWith(pathBlocks = "textures/blocks/")) {
            iconName = iconName.substring(pathBlocks.length());
        }
        if (iconName.startsWith("/")) {
            iconName = iconName.substring(1);
        }
        return iconName;
    }

    private int parseInt(String str, int defVal) {
        if (str == null) {
            return defVal;
        }
        int val = Config.parseInt(str = str.trim(), Integer.MIN_VALUE);
        if (val == Integer.MIN_VALUE) {
            Config.warn("Invalid integer: " + str);
            return defVal;
        }
        return val;
    }

    private RangeListInt parseRangeListInt(String str) {
        if (str == null) {
            return null;
        }
        String[] tokens = Config.tokenize(str, " ");
        RangeListInt rangeList = new RangeListInt();
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            RangeInt range = this.parseRangeInt(token);
            if (range == null) {
                Config.warn("Invalid range list: " + str);
                return null;
            }
            rangeList.addRange(range);
        }
        return rangeList;
    }

    private RangeInt parseRangeInt(String str) {
        if (str == null) {
            return null;
        }
        int countMinus = (str = str.trim()).length() - str.replace("-", "").length();
        if (countMinus > 1) {
            Config.warn("Invalid range: " + str);
            return null;
        }
        String[] tokens = Config.tokenize(str, "- ");
        int[] vals = new int[tokens.length];
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            String token = tokens[i2];
            int val = Config.parseInt(token, -1);
            if (val < 0) {
                Config.warn("Invalid range: " + str);
                return null;
            }
            vals[i2] = val;
        }
        if (vals.length == 1) {
            int val = vals[0];
            if (str.startsWith("-")) {
                return new RangeInt(-1, val);
            }
            if (str.endsWith("-")) {
                return new RangeInt(val, -1);
            }
            return new RangeInt(val, val);
        }
        if (vals.length == 2) {
            int min = Math.min(vals[0], vals[1]);
            int max = Math.max(vals[0], vals[1]);
            return new RangeInt(min, max);
        }
        Config.warn("Invalid range: " + str);
        return null;
    }

    private NbtTagValue[] parseNbtTagValues(Properties props) {
        Map mapNbt = CustomItemProperties.getMatchingProperties(props, "nbt.");
        if (mapNbt.size() <= 0) {
            return null;
        }
        ArrayList<NbtTagValue> listNbts = new ArrayList<NbtTagValue>();
        Set keySet = mapNbt.keySet();
        for (String key : keySet) {
            String val = (String)mapNbt.get(key);
            NbtTagValue nbt = new NbtTagValue(key, val);
            listNbts.add(nbt);
        }
        NbtTagValue[] nbts = listNbts.toArray(new NbtTagValue[listNbts.size()]);
        return nbts;
    }

    private static Map getMatchingProperties(Properties props, String keyPrefix) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Set<Object> keySet = props.keySet();
        for (String string : keySet) {
            String val = props.getProperty(string);
            if (!string.startsWith(keyPrefix)) continue;
            map.put(string, val);
        }
        return map;
    }

    public boolean isValid(String path) {
        if (this.name == null || this.name.length() <= 0) {
            Config.warn("No name found: " + path);
            return false;
        }
        if (this.basePath == null) {
            Config.warn("No base path found: " + path);
            return false;
        }
        if (this.type == 0) {
            Config.warn("No type defined: " + path);
            return false;
        }
        if ((this.type == 1 || this.type == 3) && this.items == null) {
            Config.warn("No items defined: " + path);
            return false;
        }
        if (this.texture == null && this.mapTextures == null) {
            Config.warn("No texture specified: " + path);
            return false;
        }
        return true;
    }

    public void updateIcons(bpz textureMap) {
        if (this.texture != null) {
            this.textureIcon = CustomItemProperties.registerIcon(this.texture, textureMap);
        }
        if (this.mapTextures != null) {
            this.mapTextureIcons = new LinkedHashMap();
            Set keySet = this.mapTextures.keySet();
            for (String key : keySet) {
                String val = (String)this.mapTextures.get(key);
                rf icon = CustomItemProperties.registerIcon(val, textureMap);
                this.mapTextureIcons.put(key, icon);
            }
        }
    }

    private static rf registerIcon(String tileName, bpz textureMap) {
        String fileName;
        bqx loc;
        boolean exists;
        if (tileName == null) {
            return null;
        }
        String iconName = tileName;
        String fullName = iconName;
        if (!fullName.contains("/")) {
            fullName = "textures/blocks/" + fullName;
        }
        if (!(exists = Config.hasResource(loc = new bqx(fileName = fullName + ".png")))) {
            Config.warn("File not found: " + fileName);
        }
        rf icon = textureMap.a(iconName);
        return icon;
    }
}

