/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.filters.AggregateFilter;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.robotics.ai.AIRobotGotoStationToLoad;
import buildcraft.robotics.ai.AIRobotLoad;
import buildcraft.robotics.statements.ActionRobotFilterTool;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class AIRobotFetchAndEquipItemStack
extends AIRobot {
    private IStackFilter filter;
    private int delay = 0;

    public AIRobotFetchAndEquipItemStack(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotFetchAndEquipItemStack(EntityRobotBase iRobot, IStackFilter iFilter) {
        this(iRobot);
        this.filter = new AggregateFilter(ActionRobotFilterTool.getGateFilter(iRobot.getLinkedStation()), iFilter);
    }

    @Override
    public void start() {
        this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, this.filter, 1));
    }

    @Override
    public void update() {
        if (this.robot.getDockingStation() == null) {
            this.setSuccess(false);
            this.terminate();
        }
        if (this.delay++ > 40) {
            if (this.equipItemStack()) {
                this.terminate();
            } else {
                this.delay = 0;
                this.startDelegateAI(new AIRobotGotoStationToLoad(this.robot, this.filter, 1));
            }
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationToLoad) {
            if (this.filter == null) {
                this.abort();
                return;
            }
            if (!ai.success()) {
                this.setSuccess(false);
                this.terminate();
            }
        }
    }

    private boolean equipItemStack() {
        IInventory tileInventory = this.robot.getDockingStation().getItemInput();
        if (tileInventory == null) {
            return false;
        }
        ItemStack possible = AIRobotLoad.takeSingle(this.robot.getDockingStation(), this.filter, true);
        if (possible == null) {
            return false;
        }
        this.robot.setItemInUse(possible);
        return true;
    }
}

