/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.entities;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IToolScoop;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyGenome;
import forestry.api.lepidopterology.IButterflyRoot;
import forestry.api.lepidopterology.IEntityButterfly;
import forestry.api.lepidopterology.ILepidopteristTracker;
import forestry.core.utils.ItemStackUtil;
import forestry.lepidopterology.entities.AIButterflyFlee;
import forestry.lepidopterology.entities.AIButterflyMate;
import forestry.lepidopterology.entities.AIButterflyPollinate;
import forestry.lepidopterology.entities.AIButterflyRest;
import forestry.lepidopterology.entities.AIButterflyRise;
import forestry.lepidopterology.entities.AIButterflyWander;
import forestry.lepidopterology.entities.EnumButterflyState;
import forestry.lepidopterology.genetics.Butterfly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockWall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IPlantable;

public class EntityButterfly
extends EntityCreature
implements IEntityButterfly {
    public static final int COOLDOWNS = 1500;
    private static final int DATAWATCHER_ID_SPECIES = 16;
    private static final int DATAWATCHER_ID_SIZE = 17;
    private static final int DATAWATCHER_ID_STATE = 18;
    private static final float DEFAULT_BUTTERFLY_SIZE = 0.75f;
    private static final EnumButterflyState DEFAULT_STATE = EnumButterflyState.FLYING;
    public static final int EXHAUSTION_REST = 1000;
    public static final int EXHAUSTION_CONSUMPTION = 100000;
    public static final int MAX_LIFESPAN = 168000;
    private Vec3 flightTarget;
    private int exhaustion;
    private IButterfly contained;
    private IIndividual pollen;
    public int cooldownPollination = 0;
    public int cooldownEgg = 0;
    private IAlleleButterflySpecies species;
    private float size = 0.75f;
    private EnumButterflyState state = DEFAULT_STATE;
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation textureResource;

    public EntityButterfly(World world) {
        super(world);
        this.setDefaults();
    }

    public EntityButterfly(World world, IButterfly butterfly) {
        super(world);
        this.setDefaults();
        this.setIndividual(butterfly);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)"");
        this.field_70180_af.func_75682_a(17, (Object)75);
        this.field_70180_af.func_75682_a(18, (Object)((byte)DEFAULT_STATE.ordinal()));
    }

    private void setDefaults() {
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new AIButterflyFlee(this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new AIButterflyMate(this));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new AIButterflyPollinate(this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new AIButterflyRest(this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new AIButterflyRise(this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new AIButterflyWander(this));
    }

    @Override
    public EntityCreature getEntity() {
        return this;
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        NBTTagCompound bio = new NBTTagCompound();
        this.contained.writeToNBT(bio);
        nbttagcompound.func_74782_a("BTFLY", (NBTBase)bio);
        if (this.pollen != null) {
            NBTTagCompound pln = new NBTTagCompound();
            this.pollen.writeToNBT(pln);
            nbttagcompound.func_74782_a("PLN", (NBTBase)pln);
        }
        nbttagcompound.func_74774_a("STATE", (byte)this.getState().ordinal());
        nbttagcompound.func_74768_a("EXH", this.exhaustion);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        Butterfly butterfly = null;
        if (nbttagcompound.func_74764_b("BTFLY")) {
            butterfly = new Butterfly((NBTTagCompound)nbttagcompound.func_74781_a("BTFLY"));
        }
        this.setIndividual(butterfly);
        if (nbttagcompound.func_74764_b("PLN")) {
            this.pollen = TreeManager.treeRoot.getMember((NBTTagCompound)nbttagcompound.func_74781_a("PLN"));
        }
        EnumButterflyState state = EnumButterflyState.VALUES[nbttagcompound.func_74771_c("STATE")];
        this.setState(state);
        this.exhaustion = nbttagcompound.func_74762_e("EXH");
    }

    public float getWingFlap(float partialTicktime) {
        return this.getState().getWingFlap(this, this.species.getUID().hashCode(), partialTicktime);
    }

    public void setState(EnumButterflyState state) {
        if (this.state != state) {
            this.state = state;
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(18, (Object)((byte)state.ordinal()));
            }
        }
    }

    public EnumButterflyState getState() {
        return this.state;
    }

    public float getSize() {
        return this.size;
    }

    public float getSpeed() {
        return this.contained.getGenome().getSpeed();
    }

    public Vec3 getDestination() {
        return this.flightTarget;
    }

    public void setDestination(Vec3 destination) {
        this.flightTarget = destination;
    }

    public float func_70783_a(int x, int y, int z) {
        int depth;
        float weight = 0.0f;
        if (!this.getButterfly().isAcceptedEnvironment(this.field_70170_p, x, y, z)) {
            weight -= 15.0f;
        }
        if (!this.field_70170_p.func_72872_a(EntityButterfly.class, AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1))).isEmpty()) {
            weight -= 1.0f;
        }
        if ((depth = this.getFluidDepth(x, z)) > 0) {
            weight -= 0.1f * (float)depth;
        } else {
            Block block = this.field_70170_p.func_147439_a(x, y, z);
            if (block instanceof BlockFlower) {
                weight += 2.0f;
            } else if (block instanceof IPlantable) {
                weight += 1.5f;
            } else if (block instanceof IGrowable) {
                weight += 1.0f;
            } else if (block.func_149688_o() == Material.field_151585_k) {
                weight += 1.0f;
            }
            block = this.field_70170_p.func_147439_a(x, y - 1, z);
            if (block.isLeaves((IBlockAccess)this.field_70170_p, x, y - 1, z)) {
                weight += 2.5f;
            } else if (block instanceof BlockFence) {
                weight += 1.0f;
            } else if (block instanceof BlockWall) {
                weight += 1.0f;
            }
        }
        return weight += this.field_70170_p.func_72801_o(x, y, z);
    }

    private int getFluidDepth(int x, int z) {
        Chunk chunk = this.field_70170_p.func_72938_d(x, z);
        int xx = x & 0xF;
        int zz = z & 0xF;
        int depth = 0;
        for (int y = chunk.func_76625_h() + 15; y > 0; --y) {
            Block block = chunk.func_150810_a(xx, y, zz);
            if (block.func_149688_o().func_76224_d()) {
                ++depth;
                continue;
            }
            if (!block.isAir((IBlockAccess)this.field_70170_p, x, y, z)) break;
        }
        return depth;
    }

    @Override
    public IIndividual getPollen() {
        return this.pollen;
    }

    @Override
    public void setPollen(IIndividual pollen) {
        this.pollen = pollen;
    }

    public boolean isRenderable() {
        return this.species != null;
    }

    @Override
    public void changeExhaustion(int change) {
        this.exhaustion = this.exhaustion + change > 0 ? this.exhaustion + change : 0;
    }

    @Override
    public int getExhaustion() {
        return this.exhaustion;
    }

    public boolean canFly() {
        return this.contained.canTakeFlight(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void setIndividual(IButterfly butterfly) {
        if (butterfly == null) {
            butterfly = ButterflyManager.butterflyRoot.templateAsIndividual(ButterflyManager.butterflyRoot.getDefaultTemplate());
        }
        this.contained = butterfly;
        IButterflyGenome genome = this.contained.getGenome();
        this.field_70178_ae = genome.getFireResist();
        this.size = genome.getSize();
        this.func_70105_a(this.size, 0.4f);
        this.species = genome.getPrimary();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_75692_b(17, (Object)((int)(this.size * 100.0f)));
            this.field_70180_af.func_75692_b(16, (Object)this.species.getUID());
        } else {
            this.textureResource = new ResourceLocation(this.species.getEntityTexture());
        }
    }

    @Override
    public IButterfly getButterfly() {
        return this.contained;
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        if (!this.field_70170_p.field_72995_K) {
            this.setIndividual(this.contained);
        }
        return data;
    }

    public String func_70005_c_() {
        if (this.species == null) {
            return super.func_70005_c_();
        }
        return this.species.getName();
    }

    public boolean func_70601_bi() {
        return true;
    }

    public int func_82145_z() {
        return 1000;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getTexture() {
        return this.textureResource;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity other) {
    }

    protected boolean func_70650_aV() {
        return true;
    }

    protected boolean func_70692_ba() {
        return this.field_70173_aa > 168000;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (this.field_70128_L) {
            return false;
        }
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null) {
            return false;
        }
        if (!(heldItem.func_77973_b() instanceof IToolScoop)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K) {
            IButterflyRoot root = this.contained.getGenome().getPrimary().getRoot();
            ILepidopteristTracker tracker = root.getBreedingTracker(this.field_70170_p, player.func_146103_bH());
            ItemStack itemStack = root.getMemberStack(this.contained.copy(), EnumFlutterType.BUTTERFLY.ordinal());
            tracker.registerCatch(this.contained);
            ItemStackUtil.dropItemStackAsEntity(itemStack, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_70106_y();
        } else {
            player.func_71038_i();
        }
        return true;
    }

    protected void func_70628_a(boolean playerKill, int lootLevel) {
        for (ItemStack stack : this.contained.getLootDrop(this, playerKill, lootLevel)) {
            ItemStackUtil.dropItemStackAsEntity(stack, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
        IIndividual pollen = this.getPollen();
        if (pollen != null) {
            ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(pollen.getClass());
            ItemStack pollenStack = root.getMemberStack(pollen, EnumGermlingType.POLLEN.ordinal());
            ItemStackUtil.dropItemStackAsEntity(pollenStack, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            String speciesUid;
            IAllele allele;
            if (this.species == null && (allele = AlleleManager.alleleRegistry.getAllele(speciesUid = this.field_70180_af.func_75681_e(16))) instanceof IAlleleButterflySpecies) {
                this.species = (IAlleleButterflySpecies)allele;
                this.textureResource = new ResourceLocation(this.species.getEntityTexture());
                this.size = (float)this.field_70180_af.func_75679_c(17) / 100.0f;
            }
            byte stateOrdinal = this.field_70180_af.func_75683_a(18);
            if (this.state == null || this.state.ordinal() != stateOrdinal) {
                this.setState(EnumButterflyState.VALUES[stateOrdinal]);
            }
        }
        this.field_70181_x *= (double)0.6f;
        if (this.exhaustion > 100000 && this.func_70681_au().nextInt(20) == 0) {
            this.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
        if (this.field_70173_aa > 168000) {
            this.func_70097_a(DamageSource.field_76377_j, 1.0f);
        }
        if (this.cooldownEgg > 0) {
            --this.cooldownEgg;
        }
        if (this.cooldownPollination > 0) {
            --this.cooldownPollination;
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.getState().doesMovement && this.flightTarget != null) {
            double diffX = this.flightTarget.field_72450_a + 0.5 - this.field_70165_t;
            double diffY = this.flightTarget.field_72448_b + 0.1 - this.field_70163_u;
            double diffZ = this.flightTarget.field_72449_c + 0.5 - this.field_70161_v;
            this.field_70159_w += (Math.signum(diffX) * 0.5 - this.field_70159_w) * (double)0.1f;
            this.field_70181_x += (Math.signum(diffY) * (double)0.7f - this.field_70181_x) * (double)0.1f;
            this.field_70179_y += (Math.signum(diffZ) * 0.5 - this.field_70179_y) * (double)0.1f;
            float horizontal = (float)(Math.atan2(this.field_70179_y, this.field_70159_w) * 180.0 / Math.PI) - 90.0f;
            this.field_70177_z += MathHelper.func_76142_g((float)(horizontal - this.field_70177_z));
            this.func_70657_f(this.contained.getGenome().getSpeed());
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public boolean func_145773_az() {
        return true;
    }

    public float func_70678_g(float partialTicktime) {
        float flap = this.field_70733_aJ - this.field_70732_aI;
        if (flap < 0.0f) {
            flap += 1.0f;
        }
        return this.field_70732_aI + flap * partialTicktime;
    }

    protected float func_70599_aP() {
        return 0.1f;
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        if (this.species == null) {
            return null;
        }
        IButterflyRoot root = this.species.getRoot();
        IAllele[] template = root.getTemplate(this.species.getUID());
        IButterfly butterfly = root.templateAsIndividual(template);
        return root.getMemberStack(butterfly, EnumFlutterType.BUTTERFLY.ordinal());
    }
}

