/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.recipes;

import forestry.api.recipes.ICarpenterManager;
import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.IDescriptiveRecipe;
import forestry.core.recipes.RecipeUtil;
import forestry.core.recipes.ShapedRecipeCustom;
import forestry.core.utils.ItemStackUtil;
import forestry.factory.recipes.CarpenterRecipe;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CarpenterRecipeManager
implements ICarpenterManager {
    private static final Set<ICarpenterRecipe> recipes = new HashSet<ICarpenterRecipe>();
    private static final Set<Fluid> recipeFluids = new HashSet<Fluid>();

    @Override
    public void addRecipe(ItemStack box, ItemStack product, Object[] materials) {
        this.addRecipe(5, (FluidStack)null, box, product, materials);
    }

    @Override
    public void addRecipe(int packagingTime, ItemStack box, ItemStack product, Object[] materials) {
        this.addRecipe(packagingTime, (FluidStack)null, box, product, materials);
    }

    @Override
    public void addRecipe(int packagingTime, FluidStack liquid, ItemStack box, ItemStack product, Object[] materials) {
        CarpenterRecipe recipe = new CarpenterRecipe(packagingTime, liquid, box, ShapedRecipeCustom.createShapedRecipe(product, materials));
        this.addRecipe(recipe);
    }

    public static ICarpenterRecipe findMatchingRecipe(FluidStack liquid, ItemStack item, IInventory inventorycrafting) {
        for (ICarpenterRecipe recipe : recipes) {
            if (!CarpenterRecipeManager.matches(recipe, liquid, item, inventorycrafting)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean matches(ICarpenterRecipe recipe, FluidStack resource, ItemStack item, IInventory inventoryCrafting) {
        if (recipe == null) {
            return false;
        }
        FluidStack liquid = recipe.getFluidResource();
        if (!(liquid == null || resource != null && resource.containsFluid(liquid))) {
            return false;
        }
        ItemStack box = recipe.getBox();
        if (box != null && !ItemStackUtil.isCraftingEquivalent(box, item)) {
            return false;
        }
        IDescriptiveRecipe internal = recipe.getCraftingGridRecipe();
        return RecipeUtil.matches(internal, inventoryCrafting);
    }

    public static boolean isBox(ItemStack resource) {
        if (resource == null) {
            return false;
        }
        for (ICarpenterRecipe recipe : recipes) {
            ItemStack box = recipe.getBox();
            if (!ItemStackUtil.isIdenticalItem(box, resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addRecipe(ICarpenterRecipe recipe) {
        return recipes.add(recipe);
    }

    @Override
    public boolean removeRecipe(ICarpenterRecipe recipe) {
        boolean removed = recipes.remove(recipe);
        if (removed) {
            recipeFluids.clear();
        }
        return removed;
    }

    public static Set<Fluid> getRecipeFluids() {
        if (recipeFluids.isEmpty()) {
            for (ICarpenterRecipe recipe : recipes) {
                FluidStack fluidStack = recipe.getFluidResource();
                if (fluidStack == null) continue;
                recipeFluids.add(fluidStack.getFluid());
            }
        }
        return Collections.unmodifiableSet(recipeFluids);
    }

    @Override
    public Set<ICarpenterRecipe> recipes() {
        return Collections.unmodifiableSet(recipes);
    }

    @Override
    public Map<Object[], Object[]> getRecipes() {
        HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
        for (ICarpenterRecipe recipe : recipes) {
            recipeList.put(recipe.getCraftingGridRecipe().getIngredients(), new Object[]{recipe.getCraftingGridRecipe().func_77571_b()});
        }
        return recipeList;
    }
}

