/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.blocks;

import forestry.core.blocks.IMachineProperties;
import forestry.core.tiles.TileForestry;
import forestry.factory.tiles.TileFabricator;
import forestry.factory.tiles.TileRaintank;
import forestry.factory.tiles.TileWorktable;
import java.util.Locale;
import org.apache.commons.lang3.text.WordUtils;

public enum BlockFactoryPlainType implements IMachineProperties
{
    FABRICATOR(TileFabricator.class),
    RAINTANK(TileRaintank.class),
    WORKTABLE(TileWorktable.class);

    public static final BlockFactoryPlainType[] VALUES;
    private final String teIdent;
    private final Class<? extends TileForestry> teClass;

    private BlockFactoryPlainType(Class<? extends TileForestry> teClass) {
        String name = this.toString().toLowerCase(Locale.ENGLISH);
        this.teIdent = "forestry." + WordUtils.capitalize((String)name);
        this.teClass = teClass;
    }

    @Override
    public int getMeta() {
        return this.ordinal();
    }

    @Override
    public String getTeIdent() {
        return this.teIdent;
    }

    @Override
    public Class<? extends TileForestry> getTeClass() {
        return this.teClass;
    }

    static {
        VALUES = BlockFactoryPlainType.values();
    }
}

