/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.EnumWoodType;
import forestry.arboriculture.blocks.BlockSlab;
import forestry.arboriculture.items.ItemBlockWood;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.tiles.TileUtil;
import forestry.plugins.PluginArboriculture;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileWood
extends TileEntity
implements IStreamable {
    private EnumWoodType woodType = EnumWoodType.LARCH;

    public void setWoodType(EnumWoodType woodType) {
        this.woodType = woodType;
        this.func_70296_d();
    }

    public EnumWoodType getWoodType() {
        return this.woodType;
    }

    public boolean canUpdate() {
        return false;
    }

    public Packet func_145844_m() {
        return new PacketTileStream(this).getPacket();
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        data.writeVarInt(this.woodType.ordinal());
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        int ordinal = data.readVarInt();
        this.woodType = EnumWoodType.VALUES[ordinal];
        this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.woodType != null) {
            nbt.func_74768_a("WT", this.woodType.ordinal());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("WT")) {
            int ordinal = nbt.func_74762_e("WT");
            this.woodType = EnumWoodType.VALUES[ordinal];
        }
    }

    public static ItemStack getPickBlock(Block block, IBlockAccess world, int x, int y, int z) {
        BlockSlab blockSlab;
        TileWood wood = TileWood.getWoodTile(world, x, y, z);
        if (wood == null) {
            return null;
        }
        EnumWoodType woodType = wood.getWoodType();
        int amount = 1;
        if (block instanceof BlockSlab && (blockSlab = (BlockSlab)block).isDoubleSlab()) {
            amount = 2;
            block = PluginArboriculture.blocks.slabs;
        }
        ItemStack itemStack = new ItemStack(block, amount);
        ItemBlockWood.saveToItemStack(woodType, itemStack);
        return itemStack;
    }

    public static TileWood getWoodTile(IBlockAccess world, int x, int y, int z) {
        return TileUtil.getTile(world, x, y, z, TileWood.class);
    }

    public static <T extends Block> ArrayList<ItemStack> getDrops(T block, World world, int x, int y, int z) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        ItemStack stack = TileWood.getPickBlock(block, (IBlockAccess)world, x, y, z);
        if (stack != null) {
            drops.add(stack);
        }
        return drops;
    }
}

